/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.factory.Predicates2;
import com.gs.collections.impl.block.procedure.MapCollectProcedure;
import com.gs.collections.impl.block.procedure.MaxComparatorProcedure;
import com.gs.collections.impl.block.procedure.MinComparatorProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.ListIterate;
import com.gs.collections.impl.utility.internal.InternalArrayIterate;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayIterate {
    private static final int INSERTIONSORT_THRESHOLD = 10;

    private ArrayIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> void reverse(T[] array, int size) {
        int mid = size / 2;
        int j = size - 1;
        int i = 0;
        while (i < mid) {
            T two;
            T one = array[i];
            array[i] = two = array[j];
            array[j] = one;
            ++i;
            --j;
        }
    }

    public static <T> void sort(T[] array, int size, Comparator<? super T> comparator) {
        if (size < 10) {
            if (comparator == null) {
                ArrayIterate.insertionSort(array, size);
            } else {
                ArrayIterate.insertionSort(array, size, comparator);
            }
        } else if (comparator == null) {
            Arrays.sort(array, 0, size);
        } else {
            Arrays.sort(array, 0, size, comparator);
        }
    }

    private static <T> void insertionSort(T[] array, int size, Comparator<? super T> comparator) {
        for (int i = 0; i < size; ++i) {
            for (int j = i; j > 0 && comparator.compare(array[j - 1], array[j]) > 0; --j) {
                ArrayIterate.swapWithPrevious(array, j);
            }
        }
    }

    private static <T> void insertionSort(T[] array, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = i; j > 0 && ((Comparable)array[j - 1]).compareTo(array[j]) > 0; --j) {
                ArrayIterate.swapWithPrevious(array, j);
            }
        }
    }

    private static <T> void swapWithPrevious(T[] array, int index) {
        T t = array[index];
        array[index] = array[index - 1];
        array[index - 1] = t;
    }

    public static <T, V extends Comparable<? super V>> T minBy(T[] array, Function<? super T, ? extends V> function) {
        return ArrayIterate.minBy(array, array.length, function);
    }

    public static <T, V extends Comparable<? super V>> T minBy(T[] array, int size, Function<? super T, ? extends V> function) {
        if (ArrayIterate.isEmpty(array)) {
            throw new NoSuchElementException();
        }
        T min = array[0];
        Comparable minValue = (Comparable)function.valueOf(min);
        for (int i = 1; i < size; ++i) {
            T next = array[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            minValue = nextValue;
        }
        return min;
    }

    public static <T, V extends Comparable<? super V>> T maxBy(T[] array, Function<? super T, ? extends V> function) {
        return ArrayIterate.maxBy(array, array.length, function);
    }

    public static <T, V extends Comparable<? super V>> T maxBy(T[] array, int size, Function<? super T, ? extends V> function) {
        if (ArrayIterate.isEmpty(array)) {
            throw new NoSuchElementException();
        }
        T max = array[0];
        Comparable maxValue = (Comparable)function.valueOf(max);
        for (int i = 1; i < size; ++i) {
            T next = array[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            maxValue = nextValue;
        }
        return max;
    }

    public static <T> T min(T[] array, Comparator<? super T> comparator) {
        MinComparatorProcedure<T> procedure = new MinComparatorProcedure<T>(comparator);
        ArrayIterate.forEach(array, procedure);
        return procedure.getResult();
    }

    public static <T> T max(T[] array, Comparator<? super T> comparator) {
        MaxComparatorProcedure<T> procedure = new MaxComparatorProcedure<T>(comparator);
        ArrayIterate.forEach(array, procedure);
        return procedure.getResult();
    }

    /*
     * Exception decompiling
     */
    public static <T> T min(T[] array) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T max(T[] array) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> MutableList<T> select(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a select on null");
        }
        return ArrayIterate.select(objectArray, predicate, FastList.newList());
    }

    public static <T, P> MutableList<T> selectWith(T[] objectArray, Predicate2<? super T, P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectWith on null");
        }
        return ArrayIterate.selectWith(objectArray, predicate, parameter, FastList.newList());
    }

    public static <T> MutableList<T> selectInstancesOf(Object[] objectArray, Class<T> clazz) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectInstancesOf on null");
        }
        FastList results = FastList.newList(objectArray.length);
        for (Object each : objectArray) {
            if (!clazz.isInstance(each)) continue;
            results.add(each);
        }
        results.trimToSize();
        return results;
    }

    public static <T> int count(T[] objectArray, Predicate<? super T> predicate) {
        int count = 0;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                if (!predicate.accept(each)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T, P> int countWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        int count = 0;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                if (!predicate.accept(each, parameter)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectAndRejectWith on null");
        }
        MutableList positiveResult = Lists.mutable.of();
        MutableList negativeResult = Lists.mutable.of();
        for (T each : objectArray) {
            (predicate.accept(each, parameter) ? positiveResult : negativeResult).add(each);
        }
        return Tuples.twin(positiveResult, negativeResult);
    }

    public static <T> PartitionMutableList<T> partition(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a partition on null");
        }
        PartitionFastList partition = new PartitionFastList();
        MutableList selected = partition.getSelected();
        MutableList rejected = partition.getRejected();
        for (T each : objectArray) {
            MutableList bucket = predicate.accept(each) ? selected : rejected;
            bucket.add(each);
        }
        return partition;
    }

    public static <T, V> MutableList<V> collectIf(T[] objectArray, Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectIf on null");
        }
        return ArrayIterate.collectIf(objectArray, predicate, function, FastList.newList(objectArray.length));
    }

    public static <T, R extends Collection<T>> R select(T[] objectArray, Predicate<? super T> predicate, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a select on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each)) continue;
            targetCollection.add(each);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R selectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectWith on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each, parameter)) continue;
            targetCollection.add(each);
        }
        return targetCollection;
    }

    public static <T, V, R extends Collection<V>> R collectIf(T[] objectArray, Predicate<? super T> predicate, Function<? super T, ? extends V> function, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectIf on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each)) continue;
            targetCollection.add((Object)function.valueOf(each));
        }
        return targetCollection;
    }

    public static <T> MutableList<T> reject(T[] objectArray, Predicate<? super T> predicate) {
        return ArrayIterate.reject(objectArray, predicate, FastList.newList());
    }

    public static <T, P> MutableList<T> rejectWith(T[] objectArray, Predicate2<? super T, P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a rejectWith on null");
        }
        return ArrayIterate.rejectWith(objectArray, predicate, parameter, FastList.newList());
    }

    public static <T, R extends Collection<T>> R reject(T[] objectArray, Predicate<? super T> predicate, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a reject on null");
        }
        for (T each : objectArray) {
            if (predicate.accept(each)) continue;
            targetCollection.add(each);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R rejectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a rejectWith on null");
        }
        for (T each : objectArray) {
            if (predicate.accept(each, parameter)) continue;
            targetCollection.add(each);
        }
        return targetCollection;
    }

    /*
     * Exception decompiling
     */
    public static <T, R extends Collection<T>> R addAllTo(T[] objectArray, R targetCollection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T, V> MutableList<V> collect(T[] objectArray, Function<? super T, ? extends V> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collect on null");
        }
        return ArrayIterate.collect(objectArray, function, FastList.newList(objectArray.length));
    }

    public static <T, V, R extends Collection<V>> R collect(T[] objectArray, Function<? super T, ? extends V> function, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collect on null");
        }
        for (T each : objectArray) {
            targetCollection.add((Object)function.valueOf(each));
        }
        return targetCollection;
    }

    public static <T> MutableBooleanList collectBoolean(T[] objectArray, BooleanFunction<? super T> booleanFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectBoolean on null");
        }
        BooleanArrayList result = new BooleanArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(booleanFunction.booleanValueOf(each));
        }
        return result;
    }

    public static <T> MutableByteList collectByte(T[] objectArray, ByteFunction<? super T> byteFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectByte on null");
        }
        ByteArrayList result = new ByteArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(byteFunction.byteValueOf(each));
        }
        return result;
    }

    public static <T> MutableCharList collectChar(T[] objectArray, CharFunction<? super T> charFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectChar on null");
        }
        CharArrayList result = new CharArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(charFunction.charValueOf(each));
        }
        return result;
    }

    public static <T> MutableDoubleList collectDouble(T[] objectArray, DoubleFunction<? super T> doubleFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectDouble on null");
        }
        DoubleArrayList result = new DoubleArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(doubleFunction.doubleValueOf(each));
        }
        return result;
    }

    public static <T> MutableFloatList collectFloat(T[] objectArray, FloatFunction<? super T> floatFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectFloat on null");
        }
        FloatArrayList result = new FloatArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(floatFunction.floatValueOf(each));
        }
        return result;
    }

    public static <T> MutableIntList collectInt(T[] objectArray, IntFunction<? super T> intFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectInt on null");
        }
        IntArrayList result = new IntArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(intFunction.intValueOf(each));
        }
        return result;
    }

    public static <T> MutableLongList collectLong(T[] objectArray, LongFunction<? super T> longFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectLong on null");
        }
        LongArrayList result = new LongArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(longFunction.longValueOf(each));
        }
        return result;
    }

    public static <T> MutableShortList collectShort(T[] objectArray, ShortFunction<? super T> shortFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectShort on null");
        }
        ShortArrayList result = new ShortArrayList(objectArray.length);
        for (T each : objectArray) {
            result.add(shortFunction.shortValueOf(each));
        }
        return result;
    }

    public static <T, V> MutableList<V> flatCollect(T[] objectArray, Function<? super T, ? extends Iterable<V>> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a flatCollect on null");
        }
        return ArrayIterate.flatCollect(objectArray, function, FastList.newList(objectArray.length));
    }

    public static <T, V, R extends Collection<V>> R flatCollect(T[] objectArray, Function<? super T, ? extends Iterable<V>> function, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a flatCollect on null");
        }
        for (T each : objectArray) {
            Iterate.addAllIterable((Iterable)function.valueOf(each), targetCollection);
        }
        return targetCollection;
    }

    public static <T> T getFirst(T[] objectArray) {
        if (ArrayIterate.notEmpty(objectArray)) {
            return objectArray[0];
        }
        return null;
    }

    public static <T> T getLast(T[] objectArray) {
        if (ArrayIterate.notEmpty(objectArray)) {
            return objectArray[objectArray.length - 1];
        }
        return null;
    }

    public static <T> void forEach(T[] objectArray, Procedure<? super T> procedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEach on null");
        }
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                procedure.value(each);
            }
        }
    }

    public static <T> void forEach(T[] objectArray, int from, int to, Procedure<? super T> procedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEach on null");
        }
        ListIterate.rangeCheck(from, to, objectArray.length);
        InternalArrayIterate.forEachWithoutChecks(objectArray, from, to, procedure);
    }

    public static <T1, T2> void forEachInBoth(T1[] objectArray1, T2[] objectArray2, Procedure2<T1, T2> procedure) {
        if (objectArray1 != null && objectArray2 != null) {
            if (objectArray1.length == objectArray2.length) {
                int size = objectArray1.length;
                for (int i = 0; i < size; ++i) {
                    procedure.value(objectArray1[i], objectArray2[i]);
                }
            } else {
                throw new RuntimeException("Attempt to call forEachInBoth with two arrays of different sizes :" + objectArray1.length + ':' + objectArray2.length);
            }
        }
    }

    public static <T> void forEachWithIndex(T[] objectArray, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEachWithIndex on null");
        }
        int size = objectArray.length;
        for (int i = 0; i < size; ++i) {
            objectIntProcedure.value(objectArray[i], i);
        }
    }

    public static <T> void forEachWithIndex(T[] objectArray, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEachWithIndex on null");
        }
        ListIterate.rangeCheck(from, to, objectArray.length);
        InternalArrayIterate.forEachWithIndexWithoutChecks(objectArray, from, to, objectIntProcedure);
    }

    public static <T> T detect(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detect on null");
        }
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                if (!predicate.accept(each)) continue;
                return each;
            }
        }
        return null;
    }

    public static <T, P> T detectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectWith on null");
        }
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                if (!predicate.accept(each, parameter)) continue;
                return each;
            }
        }
        return null;
    }

    public static <T> T detectIfNone(T[] objectArray, Predicate<? super T> predicate, T ifNone) {
        T result = ArrayIterate.detect(objectArray, predicate);
        return result == null ? ifNone : result;
    }

    public static <T, P> T detectWithIfNone(T[] objectArray, Predicate2<? super T, P> predicate, P parameter, T ifNone) {
        T result = ArrayIterate.detectWith(objectArray, predicate, parameter);
        return result == null ? ifNone : result;
    }

    public static <T, IV> IV injectInto(IV injectValue, T[] objectArray, Function2<? super IV, ? super T, ? extends IV> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        Object result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                result = function.value(result, each);
            }
        }
        return result;
    }

    public static <T> int injectInto(int injectValue, T[] objectArray, IntObjectToIntFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        int result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                result = function.intValueOf(result, each);
            }
        }
        return result;
    }

    public static <T> long injectInto(long injectValue, T[] objectArray, LongObjectToLongFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        long result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                result = function.longValueOf(result, each);
            }
        }
        return result;
    }

    public static <T> double injectInto(double injectValue, T[] objectArray, DoubleObjectToDoubleFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        double result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                result = function.doubleValueOf(result, each);
            }
        }
        return result;
    }

    public static <T, R extends Collection<T>> R distinct(T[] objectArray, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a distinct on null");
        }
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        for (T each : objectArray) {
            if (!seenSoFar.add(each)) continue;
            targetCollection.add(each);
        }
        return targetCollection;
    }

    public static <T> boolean contains(T[] objectArray, T value) {
        return ArrayIterate.anySatisfyWith(objectArray, Predicates2.equal(), value);
    }

    public static boolean contains(int[] intArray, int value) {
        for (int each : intArray) {
            if (each != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] doubleArray, double value) {
        for (double each : doubleArray) {
            if (Double.doubleToLongBits(each) != Double.doubleToLongBits(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] longArray, long value) {
        for (long each : longArray) {
            if (each != value) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(T[] objectArray, T elem) {
        return ArrayIterate.detectIndex(objectArray, Predicates.equal(elem));
    }

    public static <T> int detectIndex(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectIndex on null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!predicate.accept(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T, IV> int detectIndexWith(T[] objectArray, Predicate2<? super T, IV> predicate, IV injectedValue) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectIndexWith on null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!predicate.accept(objectArray[i], injectedValue)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean notEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> boolean anySatisfy(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a anySatisfy on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each)) continue;
            return true;
        }
        return false;
    }

    public static <T, IV> boolean anySatisfyWith(T[] objectArray, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a anySatisfyWith on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each, injectedValue)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean allSatisfy(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a allSatisfy on null");
        }
        for (T each : objectArray) {
            if (predicate.accept(each)) continue;
            return false;
        }
        return true;
    }

    public static <T, IV> boolean allSatisfyWith(T[] objectArray, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a allSatisfyWith on null");
        }
        for (T each : objectArray) {
            if (predicate.accept(each, injectedValue)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean noneSatisfy(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a noneSatisfy on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each)) continue;
            return false;
        }
        return true;
    }

    public static <T, IV> boolean noneSatisfyWith(T[] objectArray, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a noneSatisfyWith on null");
        }
        for (T each : objectArray) {
            if (!predicate.accept(each, injectedValue)) continue;
            return false;
        }
        return true;
    }

    public static <K, V> MutableMap<K, V> toMap(V[] objectArray, Function<? super V, ? extends K> keyFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        MapCollectProcedure procedure = new MapCollectProcedure(map, keyFunction);
        ArrayIterate.forEach(objectArray, procedure);
        return map;
    }

    public static <T, K, V> MutableMap<K, V> toMap(T[] objectArray, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        MapCollectProcedure<? super T, ? extends K, ? extends V> procedure = new MapCollectProcedure<T, K, V>(map, keyFunction, valueFunction);
        ArrayIterate.forEach(objectArray, procedure);
        return map;
    }

    public static <T, P> void forEachWith(T[] objectArray, Procedure2<? super T, ? super P> procedure, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEachWith on null");
        }
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                procedure.value(each, parameter);
            }
        }
    }

    public static <T, P, V> MutableList<V> collectWith(T[] objectArray, Function2<? super T, ? super P, ? extends V> function, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectWith on null");
        }
        return ArrayIterate.collectWith(objectArray, function, parameter, FastList.newList(objectArray.length));
    }

    public static <T, P, V, R extends Collection<V>> R collectWith(T[] objectArray, Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectWith on null");
        }
        for (T each : objectArray) {
            targetCollection.add((Object)function.value(each, parameter));
        }
        return targetCollection;
    }

    public static <T, IV, P> IV injectIntoWith(IV injectValue, T[] objectArray, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectIntoWith on null");
        }
        Object result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each : objectArray) {
                result = function.value(result, each, parameter);
            }
        }
        return result;
    }

    public static <T> MutableList<T> take(T[] array, int count) {
        return ArrayIterate.take(array, count, FastList.newList(Math.max(0, count)));
    }

    public static <T, R extends Collection<T>> R take(T[] array, int count, R target) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int end = Math.min(array.length, count);
        for (int i = 0; i < end; ++i) {
            target.add(array[i]);
        }
        return target;
    }

    public static <T> MutableList<T> drop(T[] array, int count) {
        return ArrayIterate.drop(array, count, FastList.newList(array.length - Math.min(array.length, count)));
    }

    public static <T, R extends Collection<T>> R drop(T[] array, int count, R target) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        for (int i = count; i < array.length; ++i) {
            target.add(array[i]);
        }
        return target;
    }

    public static <T, V> FastListMultimap<V, T> groupBy(T[] array, Function<? super T, ? extends V> function) {
        return ArrayIterate.groupBy(array, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(T[] array, Function<? super T, ? extends V> function, R target) {
        for (int i = 0; i < array.length; ++i) {
            target.put(function.valueOf(array[i]), array[i]);
        }
        return target;
    }

    public static <T, V> FastListMultimap<V, T> groupByEach(T[] array, Function<? super T, ? extends Iterable<V>> function) {
        return ArrayIterate.groupByEach(array, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(T[] array, Function<? super T, ? extends Iterable<V>> function, R target) {
        for (int i = 0; i < array.length; ++i) {
            Iterable iterable = (Iterable)function.valueOf(array[i]);
            for (Object key : iterable) {
                target.put(key, array[i]);
            }
        }
        return target;
    }

    public static <T> RichIterable<RichIterable<T>> chunk(T[] array, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        int index = 0;
        MutableList result = Lists.mutable.of();
        while (index < array.length) {
            MutableList batch = Lists.mutable.of();
            for (int i = 0; i < size && index < array.length; ++index, ++i) {
                batch.add(array[i]);
            }
            result.add((Object)batch);
        }
        return result;
    }

    public static <X, Y> MutableList<Pair<X, Y>> zip(X[] xs, Y[] ys) {
        return ArrayIterate.zip(xs, ys, FastList.newList());
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(X[] xs, Y[] ys, R targetCollection) {
        int size = Math.min(xs.length, ys.length);
        for (int i = 0; i < size; ++i) {
            targetCollection.add(Tuples.pair(xs[i], ys[i]));
        }
        return targetCollection;
    }

    public static <T> MutableList<Pair<T, Integer>> zipWithIndex(T[] array) {
        return ArrayIterate.zipWithIndex(array, FastList.newList());
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(T[] array, R targetCollection) {
        for (int i = 0; i < array.length; ++i) {
            targetCollection.add(Tuples.pair(array[i], i));
        }
        return targetCollection;
    }

    public static <T> String makeString(T[] array) {
        return ArrayIterate.makeString(array, ", ");
    }

    public static <T> String makeString(T[] array, String separator) {
        return ArrayIterate.makeString(array, "", separator, "");
    }

    public static <T> String makeString(T[] array, String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayIterate.appendString(array, stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public static <T> void appendString(T[] array, Appendable appendable) {
        ArrayIterate.appendString(array, appendable, ", ");
    }

    public static <T> void appendString(T[] array, Appendable appendable, String separator) {
        ArrayIterate.appendString(array, appendable, "", separator, "");
    }

    public static <T> void appendString(T[] array, Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            if (array.length > 0) {
                appendable.append(String.valueOf(array[0]));
                int size = array.length;
                for (int i = 1; i < size; ++i) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(array[i]));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

