/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable;

import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.partition.bag.PartitionMutableBag;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.primitive.ObjectIntPair;
import com.gs.collections.impl.bag.mutable.UnmodifiableBag;
import com.gs.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import com.gs.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import com.gs.collections.impl.factory.Bags;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBag<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableBag<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedBag(MutableBag<T> bag) {
        super(bag);
    }

    public SynchronizedBag(MutableBag<T> bag, Object newLock) {
        super(bag, newLock);
    }

    public static <E, B extends MutableBag<E>> SynchronizedBag<E> of(B bag) {
        return new SynchronizedBag(bag);
    }

    @Override
    @GuardedBy(value="getLock()")
    protected MutableBag<T> getDelegate() {
        return (MutableBag)super.getDelegate();
    }

    public MutableBag<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy<T>(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(Object item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().setOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableMap<T, Integer> toMapOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMapOfItemToCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<ObjectIntPair<T>> topOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().topOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().bottomOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachWithOccurrences(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(Object item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toStringOfItemToCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.forEach(procedure);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> select(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntBag collectInt(IntFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectInt(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableBag.of(this);
        }
    }

    public MutableBag<T> asSynchronized() {
        return this;
    }

    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll((Iterable)((Object)this));
    }
}

