/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.set.UnsortedSetMultimap;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.lazy.parallel.set.AbstractParallelUnsortedSetIterable;
import com.gs.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import com.gs.collections.impl.multimap.set.UnifiedSetMultimap;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class ParallelDistinctListIterable<T>
extends AbstractParallelUnsortedSetIterable<T, UnsortedSetBatch<T>> {
    private final AbstractParallelListIterable<T, ? extends ListBatch<T>> delegate;

    ParallelDistinctListIterable(AbstractParallelListIterable<T, ? extends ListBatch<T>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<UnsortedSetBatch<T>> split() {
        final ConcurrentHashMap distinct = new ConcurrentHashMap();
        return this.delegate.split().collect(new Function<ListBatch<T>, UnsortedSetBatch<T>>(){

            public UnsortedSetBatch<T> valueOf(ListBatch<T> listBatch) {
                return listBatch.distinct(distinct);
            }
        });
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        return this;
    }

    public void forEach(final Procedure<? super T> procedure) {
        final ConcurrentHashMap distinct = new ConcurrentHashMap();
        this.delegate.forEach(new Procedure<T>(){

            public void value(T each) {
                if (distinct.put(each, true) == null) {
                    procedure.value(each);
                }
            }
        });
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.delegate.anySatisfy(new DistinctAndPredicate(predicate));
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.delegate.allSatisfy(new DistinctOrPredicate(predicate));
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.delegate.detect(new DistinctAndPredicate(predicate));
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toList().distinct().toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().distinct().toArray((Object[])array);
    }

    @Override
    public <V> UnsortedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (UnsortedSetMultimap)this.delegate.toSet().groupBy(function, new UnifiedSetMultimap());
    }

    @Override
    public <V> UnsortedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (UnsortedSetMultimap)this.delegate.toSet().groupByEach(function, new UnifiedSetMultimap());
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.delegate.toSet().groupByUniqueKey(function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DistinctOrPredicate<T>
    implements Predicate<T> {
        private final ConcurrentHashMap<T, Boolean> distinct = new ConcurrentHashMap();
        private final Predicate<? super T> predicate;

        private DistinctOrPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        public boolean accept(T each) {
            boolean distinct = this.distinct.put(each, true) == null;
            return distinct && this.predicate.accept(each) || !distinct;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DistinctAndPredicate<T>
    implements Predicate<T> {
        private final ConcurrentHashMap<T, Boolean> distinct = new ConcurrentHashMap();
        private final Predicate<? super T> predicate;

        private DistinctAndPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        public boolean accept(T each) {
            return this.distinct.put(each, true) == null && this.predicate.accept(each);
        }
    }
}

