/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectBooleanIterable<T>
extends AbstractLazyBooleanIterable {
    private final LazyIterable<T> iterable;
    private final BooleanFunction<? super T> function;
    private final BooleanFunctionToProcedure<T> booleanFunctionToProcedure;

    public CollectBooleanIterable(LazyIterable<T> adapted, BooleanFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.booleanFunctionToProcedure = new BooleanFunctionToProcedure(function);
    }

    public BooleanIterator booleanIterator() {
        return new BooleanIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectBooleanIterable.this.iterable.iterator();
            }

            public boolean next() {
                return CollectBooleanIterable.this.function.booleanValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    public void each(BooleanProcedure procedure) {
        this.iterable.forEachWith(this.booleanFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final BooleanPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    @Override
    public boolean anySatisfy(final BooleanPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    @Override
    public boolean allSatisfy(final BooleanPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final BooleanPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    @Override
    public boolean[] toArray() {
        final boolean[] array = new boolean[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectBooleanIterable.this.function.booleanValueOf(each);
            }
        });
        return array;
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanFunctionToProcedure<T>
    implements Procedure2<T, BooleanProcedure> {
        private static final long serialVersionUID = 1L;
        private final BooleanFunction<? super T> function;

        private BooleanFunctionToProcedure(BooleanFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, BooleanProcedure procedure) {
            procedure.value(this.function.booleanValueOf(each));
        }
    }
}

