/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectCharIterable<T>
extends AbstractLazyCharIterable {
    private final LazyIterable<T> iterable;
    private final CharFunction<? super T> function;
    private final CharFunctionToProcedure<T> charFunctionToProcedure;

    public CollectCharIterable(LazyIterable<T> adapted, CharFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.charFunctionToProcedure = new CharFunctionToProcedure(function);
    }

    public CharIterator charIterator() {
        return new CharIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectCharIterable.this.iterable.iterator();
            }

            public char next() {
                return CollectCharIterable.this.function.charValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.iterable.forEachWith(this.charFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final CharPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    @Override
    public boolean anySatisfy(final CharPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    @Override
    public boolean allSatisfy(final CharPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final CharPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    @Override
    public char[] toArray() {
        final char[] array = new char[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectCharIterable.this.function.charValueOf(each);
            }
        });
        return array;
    }

    @Override
    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharFunctionToProcedure<T>
    implements Procedure2<T, CharProcedure> {
        private static final long serialVersionUID = 1L;
        private final CharFunction<? super T> function;

        private CharFunctionToProcedure(CharFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, CharProcedure procedure) {
            procedure.value(this.function.charValueOf(each));
        }
    }
}

