/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.procedure.CollectProcedure;
import com.gs.collections.impl.block.procedure.CollectionAddProcedure;
import com.gs.collections.impl.block.procedure.RejectProcedure;
import com.gs.collections.impl.block.procedure.SelectProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.MutableListIterator;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Interval
extends AbstractLazyIterable<Integer>
implements List<Integer>,
Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final int from;
    private final int to;
    private final int step;

    private Interval(int from, int to, int step) {
        this.from = from;
        this.to = to;
        this.step = step;
    }

    public static Interval from(int newFrom) {
        return Interval.fromToBy(newFrom, newFrom, 1);
    }

    public Interval to(int newTo) {
        return Interval.fromToBy(this.from, newTo, this.step);
    }

    public Interval by(int newStep) {
        return Interval.fromToBy(this.from, this.to, newStep);
    }

    public static Interval zero() {
        return Interval.from(0);
    }

    public static Interval oneTo(int count) {
        return Interval.oneToBy(count, 1);
    }

    public static Interval oneToBy(int count, int step) {
        if (count < 1) {
            throw new IllegalArgumentException("Only positive ranges allowed using oneToBy");
        }
        return Interval.fromToBy(1, count, step);
    }

    public static Interval zeroTo(int count) {
        return Interval.zeroToBy(count, 1);
    }

    public static Interval zeroToBy(int count, int step) {
        return Interval.fromToBy(0, count, step);
    }

    public static Interval fromTo(int from, int to) {
        if (from <= to) {
            return Interval.fromToBy(from, to, 1);
        }
        return Interval.fromToBy(from, to, -1);
    }

    public static Interval evensFromTo(int from, int to) {
        if (from % 2 != 0) {
            from = from < to ? ++from : --from;
        }
        if (to % 2 != 0) {
            to = to > from ? --to : ++to;
        }
        return Interval.fromToBy(from, to, to > from ? 2 : -2);
    }

    public static Interval oddsFromTo(int from, int to) {
        if (from % 2 == 0) {
            from = from < to ? ++from : --from;
        }
        if (to % 2 == 0) {
            to = to > from ? --to : ++to;
        }
        return Interval.fromToBy(from, to, to > from ? 2 : -2);
    }

    public static MutableSet<Integer> toSet(int from, int to) {
        UnifiedSet<Integer> targetCollection = UnifiedSet.newSet();
        Interval.fromTo(from, to).forEach(CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static MutableList<Integer> toReverseList(int from, int to) {
        return Interval.fromTo(from, to).reverseThis().toList();
    }

    public static Integer[] toArray(int from, int to) {
        return Interval.fromTo(from, to).toArray();
    }

    public static Integer[] toReverseArray(int from, int to) {
        return Interval.fromTo(from, to).reverseThis().toArray();
    }

    public static Interval fromToBy(int from, int to, int stepBy) {
        if (stepBy == 0) {
            throw new IllegalArgumentException("Cannot use a step by of 0");
        }
        if (from > to && stepBy > 0 || from < to && stepBy < 0) {
            throw new IllegalArgumentException("Step by is incorrect for the range");
        }
        return new Interval(from, to, stepBy);
    }

    public boolean containsAll(int ... values) {
        for (int value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsNone(int ... values) {
        for (int value : values) {
            if (!this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Integer && this.contains((Integer)object);
    }

    public boolean contains(int value) {
        return this.isWithinBoundaries(value) && (value - this.from) % this.step == 0;
    }

    private boolean isWithinBoundaries(int value) {
        return this.step > 0 && this.from <= value && value <= this.to || this.step < 0 && this.to <= value && value <= this.from;
    }

    public Number factorial() {
        this.failIfOutOfFactorialRange();
        return this.from == 0 ? (Number)1 : (Number)this.product();
    }

    public Number product() {
        return this.bigIntegerProduct();
    }

    private BigInteger bigIntegerProduct() {
        return this.injectInto((R)BigInteger.valueOf(1L), (Function2<? super R, ? super Integer, ? extends R>)((Function2)new Function2<BigInteger, Integer, BigInteger>(){

            public BigInteger value(BigInteger result, Integer each) {
                return result.multiply(BigInteger.valueOf(each.longValue()));
            }
        }));
    }

    private void failIfOutOfFactorialRange() {
        if (this.from < 0 || this.step != 1) {
            throw new IllegalStateException("Cannot calculate factorial on negative ranges");
        }
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        int index = 0;
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i, index++);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i, index++);
            }
        }
    }

    @Override
    public void forEachWithIndex(final ObjectIntProcedure<? super Integer> objectIntProcedure) {
        this.forEachWithIndex(new IntIntProcedure(){

            public void value(int each, int index) {
                objectIntProcedure.value((Object)each, index);
            }
        });
    }

    public <P> void forEachWith(IntObjectProcedure<? super P> procedure, P parameter) {
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i, parameter);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i, parameter);
            }
        }
    }

    public boolean goForward() {
        return this.from <= this.to && this.step > 0;
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super Integer, ? super P> procedure, P parameter) {
        this.forEachWith(new IntObjectProcedure<P>(){

            public void value(int each, P parameter) {
                procedure.value((Object)each, parameter);
            }
        }, parameter);
    }

    public void forEach(IntProcedure procedure) {
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i);
            }
        }
    }

    public void each(final Procedure<? super Integer> procedure) {
        this.forEach(new IntProcedure(){

            public void value(int each) {
                procedure.value((Object)each);
            }
        });
    }

    public void forEach(Procedure<? super Integer> procedure, Executor executor) {
        CountDownLatch latch = new CountDownLatch(this.size());
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                this.executeAndCountdown(procedure, executor, latch, i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                this.executeAndCountdown(procedure, executor, latch, i);
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private void executeAndCountdown(final Procedure<? super Integer> procedure, Executor executor, final CountDownLatch latch, final Integer integer) {
        executor.execute(new Runnable(){

            public void run() {
                try {
                    procedure.value((Object)integer);
                }
                finally {
                    latch.countDown();
                }
            }
        });
    }

    public void run(Runnable runnable) {
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                runnable.run();
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                runnable.run();
            }
        }
    }

    public void run(Runnable runnable, Executor executor) {
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                executor.execute(runnable);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                executor.execute(runnable);
            }
        }
    }

    @Override
    public <R> R injectInto(R injectValue, Function2<? super R, ? super Integer, ? extends R> function) {
        Object result = injectValue;
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.value(result, (Object)i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.value(result, (Object)i);
            }
        }
        return result;
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super Integer> function) {
        int result = injectedValue;
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.intValueOf(result, (Object)i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.intValueOf(result, (Object)i);
            }
        }
        return result;
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super Integer> function) {
        long result = injectedValue;
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.longValueOf(result, (Object)i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.longValueOf(result, (Object)i);
            }
        }
        return result;
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super Integer> function) {
        double result = injectedValue;
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.doubleValueOf(result, (Object)i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.doubleValueOf(result, (Object)i);
            }
        }
        return result;
    }

    public void reverseForEach(Procedure<? super Integer> procedure) {
        this.reverseThis().forEach(procedure);
    }

    public <R> R reverseInjectInto(R injectValue, Function2<R, Integer, R> function) {
        return this.reverseThis().injectInto(injectValue, (Function2<? super R, ? super Integer, ? extends R>)function);
    }

    public <R extends Collection<Integer>> R addAllTo(R targetCollection) {
        this.forEach(CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    @Override
    public <T, R extends Collection<T>> R collect(Function<? super Integer, ? extends T> function, R target) {
        CollectProcedure<? super Integer, ? extends T> procedure = new CollectProcedure<Integer, T>(function, target);
        this.forEach(procedure);
        return target;
    }

    @Override
    public <R extends Collection<Integer>> R select(Predicate<? super Integer> predicate, R target) {
        SelectProcedure<? super Integer> procedure = new SelectProcedure<Integer>(predicate, target);
        this.forEach(procedure);
        return target;
    }

    @Override
    public <R extends Collection<Integer>> R reject(Predicate<? super Integer> predicate, R target) {
        RejectProcedure<? super Integer> procedure = new RejectProcedure<Integer>(predicate, target);
        this.forEach(procedure);
        return target;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof List)) {
            return false;
        }
        List list = (List)otherList;
        if (otherList instanceof RandomAccess && this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = ((List)otherList).listIterator();
        if (this.goForward()) {
            for (int i = this.from; i <= this.to && listIterator.hasNext(); i += this.step) {
                Object object = listIterator.next();
                if (!this.intObjectEqual(i, object)) continue;
                return false;
            }
        } else {
            for (int i = this.from; i >= this.to && listIterator.hasNext(); i += this.step) {
                Object object = listIterator.next();
                if (!this.intObjectEqual(i, object)) continue;
                return false;
            }
        }
        return !listIterator.hasNext();
    }

    private boolean intObjectEqual(int i, Object object) {
        return object == null || !(object instanceof Integer) || (Integer)object != i;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        if (this.goForward()) {
            for (int i = this.from; i <= this.to; i += this.step) {
                hashCode = 31 * hashCode + i;
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                hashCode = 31 * hashCode + i;
            }
        }
        return hashCode;
    }

    public Interval reverseThis() {
        return Interval.fromToBy(this.to, this.from, -this.step);
    }

    @Override
    public int size() {
        return (this.to - this.from) / this.step + 1;
    }

    public Integer[] toArray() {
        final Integer[] result = new Integer[this.size()];
        this.forEachWithIndex((ObjectIntProcedure<? super Integer>)new ObjectIntProcedure<Integer>(){

            public void value(Integer each, int index) {
                result[index] = each;
            }
        });
        return result;
    }

    public int[] toIntArray() {
        final int[] result = new int[this.size()];
        this.forEachWithIndex(new IntIntProcedure(){

            public void value(int each, int index) {
                result[index] = each;
            }
        });
        return result;
    }

    @Override
    public String toString() {
        return "Interval from: " + this.from + " to: " + this.to + " step: " + this.step + " size: " + this.size();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntegerIterator();
    }

    @Override
    public Integer getFirst() {
        return this.from;
    }

    @Override
    public Integer getLast() {
        return this.locationAfterN(this.size() - 1);
    }

    public void forEach(Procedure<? super Integer> procedure, int startIndex, int endIndex) {
        this.checkBounds("startIndex", startIndex);
        this.checkBounds("endIndex", endIndex);
        if (startIndex <= endIndex) {
            for (int i = startIndex; i <= endIndex; ++i) {
                procedure.value((Object)this.locationAfterN(i));
            }
        } else {
            for (int i = startIndex; i >= endIndex; --i) {
                procedure.value((Object)this.locationAfterN(i));
            }
        }
    }

    public void forEachWithIndex(ObjectIntProcedure<? super Integer> objectIntProcedure, int startIndex, int endIndex) {
        this.checkBounds("startIndex", startIndex);
        this.checkBounds("endIndex", endIndex);
        if (startIndex <= endIndex) {
            for (int i = startIndex; i <= endIndex; ++i) {
                objectIntProcedure.value((Object)this.locationAfterN(i), i);
            }
        } else {
            for (int i = startIndex; i >= endIndex; --i) {
                objectIntProcedure.value((Object)this.locationAfterN(i), i);
            }
        }
    }

    @Override
    public Integer get(int index) {
        this.checkBounds("index", index);
        return this.locationAfterN(index);
    }

    private void checkBounds(String name, int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(name + ": " + index + ' ' + this.toString());
        }
    }

    private int locationAfterN(int index) {
        if (index <= 0) {
            return this.from;
        }
        if (this.step > 0) {
            return (int)Math.min((long)this.from + (long)this.step * (long)index, (long)this.to);
        }
        return (int)Math.max((long)this.from + (long)this.step * (long)index, (long)this.to);
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        Integer value = (Integer)object;
        if (!this.isWithinBoundaries(value)) {
            return -1;
        }
        int diff = value - this.from;
        if (diff % this.step == 0) {
            return diff / this.step;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public MutableList<Integer> toList() {
        FastList<Integer> list = FastList.newList(this.size());
        this.forEach(CollectionAddProcedure.on(list));
        return list;
    }

    @Override
    public MutableSet<Integer> toSet() {
        UnifiedSet<Integer> set = UnifiedSet.newSet(this.size());
        this.forEach(CollectionAddProcedure.on(set));
        return set;
    }

    @Override
    public MutableBag<Integer> toBag() {
        HashBag<Integer> bag = HashBag.newBag(this.size());
        this.forEach(CollectionAddProcedure.on(bag));
        return bag;
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> collection) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public Integer set(int index, Integer element) {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public void add(int index, Integer element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public Integer remove(int index) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return new MutableListIterator<Integer>(this, 0);
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return new MutableListIterator<Integer>(this, index);
    }

    public Interval subList(int fromIndex, int toIndex) {
        return Interval.fromToBy(this.get(fromIndex), this.get(toIndex - 1), this.step);
    }

    public Interval take(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        if (count > 0 && this.notEmpty()) {
            return Interval.fromToBy(this.from, this.locationAfterN(count - 1), this.step);
        }
        return Interval.fromToBy(this.from, this.from, this.step);
    }

    @Override
    public LazyIterable<Integer> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        if (count >= this.size()) {
            return Lists.immutable.of().asLazy();
        }
        return Interval.fromToBy(this.locationAfterN(count), this.to, this.step);
    }

    @Override
    public LazyIterable<Integer> distinct() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerIterator
    implements Iterator<Integer> {
        private int current;

        private IntegerIterator() {
            this.current = Interval.this.from;
        }

        @Override
        public boolean hasNext() {
            if (Interval.this.from <= Interval.this.to) {
                return this.current <= Interval.this.to;
            }
            return this.current >= Interval.this.to;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                Integer result = this.current;
                this.current += Interval.this.step;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a value from an Interval");
        }
    }
}

