/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharCharPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharCharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.CharCharMap;
import com.gs.collections.api.map.primitive.ImmutableCharCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.CharCharPair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.immutable.primitive.ImmutableCharCharSingletonMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyCharIterate;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharCharEmptyMap
implements ImmutableCharCharMap,
Serializable {
    static final ImmutableCharCharMap INSTANCE = new ImmutableCharCharEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';

    ImmutableCharCharEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public char get(char key) {
        return '\u0000';
    }

    public char getIfAbsent(char key, char ifAbsent) {
        return ifAbsent;
    }

    public char getOrThrow(char key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return false;
    }

    public boolean containsValue(char value) {
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
    }

    public void forEachKey(CharProcedure procedure) {
    }

    public void forEachKeyValue(CharCharProcedure procedure) {
    }

    public LazyCharIterable keysView() {
        return LazyCharIterate.empty();
    }

    public RichIterable<CharCharPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableCharCharMap select(CharCharPredicate predicate) {
        return this;
    }

    public ImmutableCharCharMap reject(CharCharPredicate predicate) {
        return this;
    }

    public ImmutableCharCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    public void forEach(CharProcedure procedure) {
    }

    public void each(CharProcedure procedure) {
    }

    public int count(CharPredicate predicate) {
        return 0;
    }

    public long sum() {
        return 0L;
    }

    public char min() {
        throw new NoSuchElementException();
    }

    public char max() {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public char[] toSortedArray() {
        return new char[0];
    }

    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return CharLists.immutable.with();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return CharLists.immutable.with();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public char[] toArray() {
        return new char[0];
    }

    public boolean contains(char value) {
        return false;
    }

    public boolean containsAll(char ... source) {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    public MutableCharList toList() {
        return new CharArrayList();
    }

    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharCharMap newWithKeyValue(char key, char value) {
        return new ImmutableCharCharSingletonMap(key, value);
    }

    public ImmutableCharCharMap newWithoutKey(char key) {
        return this;
    }

    public ImmutableCharCharMap newWithoutAllKeys(CharIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(new CharHashSet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of((MutableCharCollection)new CharArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap map = (CharCharMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

