/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableObjectShortMap;
import com.gs.collections.api.map.primitive.MutableObjectShortMap;
import com.gs.collections.api.map.primitive.ObjectShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.ObjectShortPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.primitive.ObjectShortMaps;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectShortMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableObjectShortMap<K>
implements MutableObjectShortMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectShortMap<K> map;

    UnmodifiableObjectShortMap(MutableObjectShortMap<K> map) {
        this.map = map;
    }

    private boolean isAbsent(short result, K key) {
        return result == 0 && !this.containsKey(key);
    }

    private short getIfAbsentThrow(K key) {
        short result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, short value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectShortMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public short removeKeyIfAbsent(K key, short value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public short getIfAbsentPut(K key, short value) {
        return this.getIfAbsentThrow(key);
    }

    public short getIfAbsentPut(K key, ShortFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public short getIfAbsentPutWithKey(K key, ShortFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> short getIfAbsentPutWith(K key, ShortFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public short updateValue(K key, short initialValueIfAbsent, ShortToShortFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public short addToValue(K key, short toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public short get(Object key) {
        return this.map.get(key);
    }

    public short getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    public short getIfAbsent(Object key, short ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectShortProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectShortMap<K> select(ObjectShortPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    public MutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    public MutableShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.map.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(ShortToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public short max() {
        return this.map.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.map.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public short[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.map.toSortedList();
    }

    public short[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(short value) {
        return this.map.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.map.containsAll(source);
    }

    public MutableShortList toList() {
        return this.map.toList();
    }

    public MutableShortSet toSet() {
        return this.map.toSet();
    }

    public MutableShortBag toBag() {
        return this.map.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableObjectShortMap<K> withKeyValue(K key, short value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectShortMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectShortMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectShortMap<K> asUnmodifiable() {
        return this;
    }

    public MutableObjectShortMap<K> asSynchronized() {
        return new SynchronizedObjectShortMap(this);
    }

    public ImmutableObjectShortMap<K> toImmutable() {
        return ObjectShortMaps.immutable.withAll((ObjectShortMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    public RichIterable<ObjectShortPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

