/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.sorted.immutable;

import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.sorted.ImmutableSortedMap;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableSortedMapSerializationProxy<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSortedMap<K, V> map;

    public ImmutableSortedMapSerializationProxy() {
    }

    ImmutableSortedMapSerializationProxy(ImmutableSortedMap<K, V> map) {
        this.map = map;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.map.comparator());
        out.writeInt(this.map.size());
        try {
            this.map.forEachKeyValue((Procedure2)new CheckedProcedure2<K, V>(){

                @Override
                public void safeValue(K key, V value) throws IOException {
                    out.writeObject(key);
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Comparator comparator = (Comparator)in.readObject();
        int size = in.readInt();
        TreeSortedMap deserializedMap = TreeSortedMap.newMap(comparator);
        for (int i = 0; i < size; ++i) {
            deserializedMap.put(in.readObject(), in.readObject());
        }
        this.map = deserializedMap.toImmutable();
    }

    protected Object readResolve() {
        return this.map;
    }
}

