/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableByteStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableByteStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableByteArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableByteEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableByteSingletonStack;

public class ImmutableByteStackFactoryImpl
implements ImmutableByteStackFactory {
    public ImmutableByteStack empty() {
        return ImmutableByteEmptyStack.INSTANCE;
    }

    public ImmutableByteStack of() {
        return this.empty();
    }

    public ImmutableByteStack with() {
        return this.empty();
    }

    public ImmutableByteStack of(byte one) {
        return this.with(one);
    }

    public ImmutableByteStack with(byte one) {
        return new ImmutableByteSingletonStack(one);
    }

    public ImmutableByteStack of(byte ... items) {
        return this.with(items);
    }

    public ImmutableByteStack with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteArrayStack.newStackWith(items);
    }

    public ImmutableByteStack ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public ImmutableByteStack withAll(ByteIterable items) {
        if (items instanceof ImmutableByteStack) {
            return (ImmutableByteStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableByteStack ofAllReversed(ByteIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableByteStack withAllReversed(ByteIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableByteArrayStack.newStackFromTopToBottom(items);
    }
}

