/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.ByteList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ByteStack;
import com.gs.collections.api.stack.primitive.ImmutableByteStack;
import com.gs.collections.api.stack.primitive.MutableByteStack;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.primitive.ByteStacks;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedByteStack;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableByteStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class ByteArrayStack
implements MutableByteStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient ByteArrayList delegate;

    public ByteArrayStack() {
        this.delegate = new ByteArrayList();
    }

    private ByteArrayStack(int size) {
        this.delegate = new ByteArrayList(size);
    }

    private ByteArrayStack(byte ... items) {
        this.delegate = new ByteArrayList(items);
    }

    public static ByteArrayStack newStackFromTopToBottom(byte ... items) {
        ByteArrayStack stack = new ByteArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static ByteArrayStack newStackWith(byte ... items) {
        return new ByteArrayStack(items);
    }

    public static ByteArrayStack newStack(ByteIterable items) {
        ByteArrayStack stack = new ByteArrayStack(items.size());
        stack.delegate = ByteArrayList.newList(items);
        return stack;
    }

    public static ByteArrayStack newStackFromTopToBottom(ByteIterable items) {
        ByteArrayStack stack = new ByteArrayStack(items.size());
        stack.delegate = ByteArrayList.newList(items).reverseThis();
        return stack;
    }

    public void push(byte item) {
        this.delegate.add(item);
    }

    public byte pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public ByteList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ByteArrayList(0);
        }
        ByteArrayList subList = new ByteArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    public MutableByteStack select(BytePredicate predicate) {
        return ByteArrayStack.newStackFromTopToBottom((ByteIterable)this.delegate.asReversed().select(predicate));
    }

    public MutableByteStack reject(BytePredicate predicate) {
        return ByteArrayStack.newStackFromTopToBottom((ByteIterable)this.delegate.asReversed().reject(predicate));
    }

    public byte peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    public ByteList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ByteArrayList(0);
        }
        ByteArrayList subList = new ByteArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public byte peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(this.delegate.asReversed().byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public int count(BytePredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> MutableStack<V> collect(ByteToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        return (V)this.delegate.asReversed().injectInto(injectedValue, function);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public byte[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(byte value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ByteStack)) {
            return false;
        }
        ByteStack stack = (ByteStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyByteIterable iterable = this.delegate.asReversed();
        ByteIterator iterator = iterable.byteIterator();
        while (iterator.hasNext()) {
            byte item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public MutableByteStack asUnmodifiable() {
        return new UnmodifiableByteStack(this);
    }

    public MutableByteStack asSynchronized() {
        return new SynchronizedByteStack(this);
    }

    public ImmutableByteStack toImmutable() {
        return ByteStacks.immutable.withAll((ByteIterable)this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        ByteIterator iterator = this.delegate.asReversed().byteIterator();
        while (iterator.hasNext()) {
            byte each = iterator.next();
            out.writeByte(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        byte[] array = new byte[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readByte();
        }
        this.delegate = ByteArrayList.newListWith(array);
    }
}

