/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;
import com.gs.collections.api.stack.primitive.LongStack;
import com.gs.collections.api.stack.primitive.MutableLongStack;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.primitive.LongStacks;
import com.gs.collections.impl.iterator.UnmodifiableLongIterator;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedLongStack;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableLongStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class LongArrayStack
implements MutableLongStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient LongArrayList delegate;

    public LongArrayStack() {
        this.delegate = new LongArrayList();
    }

    private LongArrayStack(int size) {
        this.delegate = new LongArrayList(size);
    }

    private LongArrayStack(long ... items) {
        this.delegate = new LongArrayList(items);
    }

    public static LongArrayStack newStackFromTopToBottom(long ... items) {
        LongArrayStack stack = new LongArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static LongArrayStack newStackWith(long ... items) {
        return new LongArrayStack(items);
    }

    public static LongArrayStack newStack(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items);
        return stack;
    }

    public static LongArrayStack newStackFromTopToBottom(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items).reverseThis();
        return stack;
    }

    public void push(long item) {
        this.delegate.add(item);
    }

    public long pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public LongList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new LongArrayList(0);
        }
        LongArrayList subList = new LongArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    public MutableLongStack select(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom((LongIterable)this.delegate.asReversed().select(predicate));
    }

    public MutableLongStack reject(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom((LongIterable)this.delegate.asReversed().reject(predicate));
    }

    public long peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    public LongList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new LongArrayList(0);
        }
        LongArrayList subList = new LongArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public long peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.asReversed().longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public int count(LongPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        return (V)this.delegate.asReversed().injectInto(injectedValue, function);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public long[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(long value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyLongIterable iterable = this.delegate.asReversed();
        LongIterator iterator = iterable.longIterator();
        while (iterator.hasNext()) {
            long item = iterator.next();
            hashCode = 31 * hashCode + (int)(item ^ item >>> 32);
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public MutableLongStack asUnmodifiable() {
        return new UnmodifiableLongStack(this);
    }

    public MutableLongStack asSynchronized() {
        return new SynchronizedLongStack(this);
    }

    public ImmutableLongStack toImmutable() {
        return LongStacks.immutable.withAll((LongIterable)this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        LongIterator iterator = this.delegate.asReversed().longIterator();
        while (iterator.hasNext()) {
            long each = iterator.next();
            out.writeLong(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        long[] array = new long[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readLong();
        }
        this.delegate = LongArrayList.newListWith(array);
    }
}

