/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.adk.tools.mcp.McpToolException;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.FunctionDeclaration;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractMcpTool<T>
extends BaseTool {
    protected final McpSchema.Tool mcpTool;
    protected final McpSessionManager mcpSessionManager;
    protected final ObjectMapper objectMapper;
    protected volatile T mcpSession;

    protected AbstractMcpTool(McpSchema.Tool mcpTool, T mcpSession, McpSessionManager mcpSessionManager, ObjectMapper objectMapper) {
        super(mcpTool == null ? "" : mcpTool.name(), mcpTool == null ? "" : (mcpTool.description().isEmpty() ? "" : mcpTool.description()));
        if (mcpTool == null) {
            throw new IllegalArgumentException("mcpTool cannot be null");
        }
        if (mcpSession == null) {
            throw new IllegalArgumentException("mcpSession cannot be null");
        }
        if (mcpSessionManager == null) {
            throw new IllegalArgumentException("mcpSessionManager cannot be null");
        }
        if (objectMapper == null) {
            throw new IllegalArgumentException("objectMapper cannot be null");
        }
        this.mcpTool = mcpTool;
        this.mcpSession = mcpSession;
        this.mcpSessionManager = mcpSessionManager;
        this.objectMapper = objectMapper;
    }

    public T getMcpSession() {
        return this.mcpSession;
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        McpSchema.JsonSchema schema = this.mcpTool.inputSchema();
        try {
            return Optional.ofNullable(schema).map(value -> FunctionDeclaration.builder().name(this.name()).description(this.description()).parametersJsonSchema(value).build());
        }
        catch (Exception e) {
            throw new McpToolException.McpToolDeclarationException(String.format("MCP tool:%s failed to get declaration, schema:%s.", this.name(), schema), e);
        }
    }

    protected static Map<String, Object> wrapCallResult(ObjectMapper objectMapper, String mcpToolName, McpSchema.CallToolResult callResult) {
        if (callResult == null) {
            return ImmutableMap.of((Object)"error", (Object)"MCP framework error: CallToolResult was null");
        }
        List contents = callResult.content();
        Boolean isToolError = callResult.isError();
        if (isToolError != null && isToolError.booleanValue()) {
            McpSchema.TextContent textContent;
            Object e;
            Object errorMessage = "Tool execution failed.";
            if (contents != null && !contents.isEmpty() && (e = contents.get(0)) instanceof McpSchema.TextContent && (textContent = (McpSchema.TextContent)e).text() != null && !textContent.text().isEmpty()) {
                errorMessage = (String)errorMessage + " Details: " + textContent.text();
            }
            return ImmutableMap.of((Object)"error", (Object)errorMessage);
        }
        if (contents == null || contents.isEmpty()) {
            return ImmutableMap.of();
        }
        ArrayList<String> textOutputs = new ArrayList<String>();
        for (McpSchema.Content content : contents) {
            McpSchema.TextContent textContent;
            if (!(content instanceof McpSchema.TextContent) || (textContent = (McpSchema.TextContent)content).text() == null) continue;
            textOutputs.add(textContent.text());
        }
        if (textOutputs.isEmpty()) {
            return ImmutableMap.of((Object)"error", (Object)("Tool '" + mcpToolName + "' returned content that is not TextContent."), (Object)"content_details", (Object)contents.toString());
        }
        ArrayList resultMaps = new ArrayList();
        for (String textOutput : textOutputs) {
            try {
                resultMaps.add((Map)objectMapper.readValue(textOutput, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            catch (JsonProcessingException e) {
                resultMaps.add(ImmutableMap.of((Object)"text", (Object)textOutput));
            }
        }
        return ImmutableMap.of((Object)"text_output", resultMaps);
    }
}

