/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import io.modelcontextprotocol.spec.McpSchema;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

class McpServerLogConsumer
implements Consumer<McpSchema.LoggingMessageNotification> {
    McpServerLogConsumer() {
    }

    @Override
    public void accept(McpSchema.LoggingMessageNotification notif) {
        Logger log = LoggerFactory.getLogger((String)notif.logger());
        log.atLevel(this.convert(notif.level())).log("{}", (Object)notif.data());
    }

    private Level convert(McpSchema.LoggingLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case McpSchema.LoggingLevel.DEBUG -> Level.DEBUG;
            case McpSchema.LoggingLevel.INFO, McpSchema.LoggingLevel.NOTICE -> Level.INFO;
            case McpSchema.LoggingLevel.WARNING -> Level.WARN;
            case McpSchema.LoggingLevel.ERROR, McpSchema.LoggingLevel.CRITICAL, McpSchema.LoggingLevel.ALERT, McpSchema.LoggingLevel.EMERGENCY -> Level.ERROR;
        };
    }
}

