/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.retrieval;

import com.google.adk.models.LlmRequest;
import com.google.adk.tools.ToolContext;
import com.google.adk.tools.retrieval.BaseRetrievalTool;
import com.google.cloud.aiplatform.v1.RagContexts;
import com.google.cloud.aiplatform.v1.RagQuery;
import com.google.cloud.aiplatform.v1.RetrieveContextsRequest;
import com.google.cloud.aiplatform.v1.RetrieveContextsResponse;
import com.google.cloud.aiplatform.v1.VertexRagServiceClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Retrieval;
import com.google.genai.types.Tool;
import com.google.genai.types.VertexRagStore;
import com.google.genai.types.VertexRagStoreRagResource;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexAiRagRetrieval
extends BaseRetrievalTool {
    private static final Logger logger = LoggerFactory.getLogger(VertexAiRagRetrieval.class);
    private final VertexRagServiceClient vertexRagServiceClient;
    private final String parent;
    private final List<RetrieveContextsRequest.VertexRagStore.RagResource> ragResources;
    private final Double vectorDistanceThreshold;
    private final VertexRagStore vertexRagStore;
    private final RetrieveContextsRequest.VertexRagStore apiVertexRagStore;

    public VertexAiRagRetrieval(@Nonnull String name, @Nonnull String description, @Nonnull VertexRagServiceClient vertexRagServiceClient, @Nonnull String parent, @Nullable List<RetrieveContextsRequest.VertexRagStore.RagResource> ragResources, @Nullable Double vectorDistanceThreshold) {
        super(name, description);
        this.vertexRagServiceClient = vertexRagServiceClient;
        this.parent = parent;
        this.ragResources = ragResources;
        this.vectorDistanceThreshold = vectorDistanceThreshold;
        VertexRagStore.Builder vertexRagStoreBuilder = VertexRagStore.builder();
        if (this.ragResources != null) {
            vertexRagStoreBuilder.ragResources((List)this.ragResources.stream().map(ragResource -> VertexRagStoreRagResource.builder().ragCorpus(ragResource.getRagCorpus()).build()).collect(ImmutableList.toImmutableList()));
        }
        if (this.vectorDistanceThreshold != null) {
            vertexRagStoreBuilder.vectorDistanceThreshold(this.vectorDistanceThreshold);
        }
        this.vertexRagStore = vertexRagStoreBuilder.build();
        RetrieveContextsRequest.VertexRagStore.Builder apiVertexRagStoreBuilder = RetrieveContextsRequest.VertexRagStore.newBuilder();
        if (this.ragResources != null) {
            apiVertexRagStoreBuilder.addAllRagResources(this.ragResources);
        }
        if (this.vectorDistanceThreshold != null) {
            apiVertexRagStoreBuilder.setVectorDistanceThreshold(this.vectorDistanceThreshold.doubleValue());
        }
        this.apiVertexRagStore = apiVertexRagStoreBuilder.build();
    }

    @Override
    @CanIgnoreReturnValue
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        LlmRequest llmRequest = llmRequestBuilder.build();
        boolean useVertexAi = Boolean.parseBoolean(System.getenv("GOOGLE_GENAI_USE_VERTEXAI"));
        if (useVertexAi && llmRequest.model().isPresent() && llmRequest.model().get().startsWith("gemini-2")) {
            GenerateContentConfig config = llmRequest.config().orElse(GenerateContentConfig.builder().build());
            ImmutableList.Builder toolsBuilder = ImmutableList.builder();
            if (config.tools().isPresent()) {
                toolsBuilder.addAll((Iterable)config.tools().get());
            }
            toolsBuilder.add((Object)Tool.builder().retrieval(Retrieval.builder().vertexRagStore(this.vertexRagStore).build()).build());
            logger.info("Using Gemini built-in Vertex AI RAG tool for model: {}", (Object)llmRequest.model().get());
            llmRequestBuilder.config(config.toBuilder().tools((List)toolsBuilder.build()).build());
            return Completable.complete();
        }
        return super.processLlmRequest(llmRequestBuilder, toolContext);
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        String query = (String)args.get("query");
        logger.info("VertexAiRagRetrieval.runAsync called with query: {}", (Object)query);
        return Single.fromCallable(() -> {
            logger.info("Retrieving context for query: {}", (Object)query);
            RetrieveContextsRequest retrieveContextsRequest = RetrieveContextsRequest.newBuilder().setParent(this.parent).setQuery(RagQuery.newBuilder().setText(query)).setVertexRagStore(this.apiVertexRagStore).build();
            logger.info("Request to VertexRagService: {}", (Object)retrieveContextsRequest);
            RetrieveContextsResponse response = this.vertexRagServiceClient.retrieveContexts(retrieveContextsRequest);
            logger.info("Response from VertexRagService: {}", (Object)response);
            if (response.getContexts().getContextsList().isEmpty()) {
                logger.warn("No matching result found for query: {}", (Object)query);
                return ImmutableMap.of((Object)"response", (Object)String.format("No matching result found with the config: resources: %s", this.ragResources));
            }
            logger.info("Found {} matching results for query: {}", (Object)response.getContexts().getContextsCount(), (Object)query);
            ImmutableList contexts = (ImmutableList)response.getContexts().getContextsList().stream().map(RagContexts.Context::getText).collect(ImmutableList.toImmutableList());
            logger.info("Returning contexts: {}", (Object)contexts);
            return ImmutableMap.of((Object)"response", (Object)contexts);
        });
    }
}

