/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import androidx.annotation.Nullable;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.cct.a.zzo;
import com.google.android.datatransport.cct.a.zzp;
import com.google.android.datatransport.cct.a.zzq;
import com.google.android.datatransport.cct.a.zzr;
import com.google.android.datatransport.cct.a.zzs;
import com.google.android.datatransport.cct.a.zzt;
import com.google.android.datatransport.cct.a.zzu;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.retries.Function;
import com.google.android.datatransport.runtime.retries.Retries;
import com.google.android.datatransport.runtime.retries.RetryStrategy;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

final class zzc
implements TransportBackend {
    private final DataEncoder zza;
    private final ConnectivityManager zzb;
    final URL zzc;
    private final Clock zzd;
    private final Clock zze;
    private final int zzf;

    private static URL zza(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid url: " + string, malformedURLException);
        }
    }

    zzc(Context context, Clock clock, Clock clock2) {
        zzc zzc2 = this;
        this.zza = new JsonDataEncoderBuilder().configureWith(com.google.android.datatransport.cct.a.zzb.zza).ignoreNullValues(true).build();
        zzc2.zzb = (ConnectivityManager)context.getSystemService("connectivity");
        zzc2.zzc = com.google.android.datatransport.cct.zzc.zza(CCTDestination.zza);
        this.zzd = clock2;
        this.zze = clock;
        this.zzf = 40000;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private zzb zza(zza object) throws IOException {
        void var0_11;
        block37: {
            GZIPOutputStream gZIPOutputStream;
            GZIPOutputStream gZIPOutputStream2;
            Object object2 = object;
            Object object3 = ((zza)object2).zza;
            Logging.d((String)"CctTransportBackend", (String)"Making request to: %s", (Object)object3);
            object3 = (HttpURLConnection)((zza)object2).zza.openConnection();
            ((URLConnection)object3).setConnectTimeout(30000);
            ((URLConnection)object3).setReadTimeout(this.zzf);
            ((URLConnection)object3).setDoOutput(true);
            ((HttpURLConnection)object3).setInstanceFollowRedirects(false);
            ((HttpURLConnection)object3).setRequestMethod("POST");
            Object[] objectArray = new Object[1];
            Object object4 = objectArray;
            objectArray[0] = "2.3.1";
            ((URLConnection)object3).setRequestProperty("User-Agent", String.format("datatransport/%s android/", (Object[])object4));
            ((URLConnection)object3).setRequestProperty("Content-Encoding", "gzip");
            ((URLConnection)object3).setRequestProperty("Content-Type", "application/json");
            ((URLConnection)object3).setRequestProperty("Accept-Encoding", "gzip");
            object4 = ((zza)object2).zzc;
            if (object4 != null) {
                ((URLConnection)object3).setRequestProperty("X-Goog-Api-Key", (String)object4);
            }
            Object object5 = object4 = ((URLConnection)object3).getOutputStream();
            GZIPOutputStream gZIPOutputStream3 = gZIPOutputStream2 = gZIPOutputStream;
            zzc zzc2 = this;
            gZIPOutputStream2((OutputStream)object4);
            zzc2.zza.encode((Object)((zza)object).zzb, (Writer)new BufferedWriter(new OutputStreamWriter(gZIPOutputStream2)));
            gZIPOutputStream3.close();
            if (object5 != null) {
                ((OutputStream)object4).close();
            }
            int n = ((HttpURLConnection)object3).getResponseCode();
            Logging.i((String)"CctTransportBackend", (String)("Status Code: " + n));
            Logging.i((String)"CctTransportBackend", (String)("Content-Type: " + ((URLConnection)object3).getHeaderField("Content-Type")));
            Logging.i((String)"CctTransportBackend", (String)("Content-Encoding: " + ((URLConnection)object3).getHeaderField("Content-Encoding")));
            if (n != 302 && n != 301 && n != 307) {
                zzb zzb2;
                block35: {
                    zzb zzb3;
                    block34: {
                        if (n != 200) {
                            return new zzb(n, null, 0L);
                        }
                        Object object6 = object3;
                        object = ((URLConnection)object6).getInputStream();
                        if ("gzip".equals(((URLConnection)object6).getHeaderField("Content-Encoding"))) {
                            GZIPInputStream gZIPInputStream;
                            object3 = gZIPInputStream;
                            gZIPInputStream = new GZIPInputStream((InputStream)object);
                            break block34;
                        }
                        object3 = object;
                        {
                            catch (Throwable throwable) {
                                if (object == null) throw throwable;
                                try {
                                    ((InputStream)object).close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {}
                                throw throwable;
                            }
                        }
                    }
                    long l = zzs.zza(new BufferedReader(new InputStreamReader((InputStream)object3))).zza();
                    zzb2 = zzb3;
                    zzb3 = new zzb(n, null, l);
                    if (object3 == null) break block35;
                    ((InputStream)object3).close();
                }
                if (object == null) return zzb2;
                ((InputStream)object).close();
                return zzb2;
                catch (Throwable throwable) {
                    if (object3 != null) {
                        try {
                            ((InputStream)object3).close();
                        }
                        catch (Throwable throwable3) {}
                    }
                    throw throwable;
                }
            }
            object = ((URLConnection)object3).getHeaderField("Location");
            return new zzb(n, new URL((String)object), 0L);
            catch (Throwable throwable) {
                try {
                    gZIPOutputStream2.close();
                }
                catch (Throwable throwable4) {}
                try {
                    throw throwable;
                }
                catch (Throwable throwable5) {
                    void var0_8;
                    if (object4 != null) {
                        try {
                            ((OutputStream)object4).close();
                        }
                        catch (Throwable throwable6) {}
                    }
                    try {
                        throw throwable5;
                    }
                    catch (IOException iOException) {
                    }
                    catch (EncodingException encodingException) {
                        // empty catch block
                    }
                    Logging.e((String)"CctTransportBackend", (String)"Couldn't encode request, returning with 400", (Throwable)var0_8);
                    return new zzb(400, null, 0L);
                    catch (UnknownHostException unknownHostException) {
                        break block37;
                    }
                    catch (ConnectException connectException) {
                        // empty catch block
                    }
                }
            }
        }
        Logging.e((String)"CctTransportBackend", (String)"Couldn't open connection, returning with 500", (Throwable)var0_11);
        return new zzb(500, null, 0L);
    }

    static /* synthetic */ zza zza(zza zza2, zzb zzb2) {
        URL uRL = zzb2.zzb;
        if (uRL != null) {
            Logging.d((String)"CctTransportBackend", (String)"Following redirect to: %s", (Object)uRL);
            return zza2.zza(zzb2.zzb);
        }
        return null;
    }

    static /* synthetic */ zzb zza(zzc zzc2, zza zza2) {
        return zzc2.zza(zza2);
    }

    public EventInternal decorate(EventInternal eventInternal) {
        int n;
        zzc zzc2 = zzc2.zzb.getActiveNetworkInfo();
        EventInternal.Builder builder = eventInternal.toBuilder().addMetadata("sdk-version", Build.VERSION.SDK_INT).addMetadata("model", Build.MODEL).addMetadata("hardware", Build.HARDWARE).addMetadata("device", Build.DEVICE).addMetadata("product", Build.PRODUCT).addMetadata("os-uild", Build.ID).addMetadata("manufacturer", Build.MANUFACTURER).addMetadata("fingerprint", Build.FINGERPRINT);
        Calendar.getInstance();
        eventInternal = builder.addMetadata("tz-offset", (long)(TimeZone.getDefault().getOffset(Calendar.getInstance().getTimeInMillis()) / 1000));
        String string = "net-type";
        int n2 = zzc2 == null ? zzt.zzc.zzs.zza() : zzc2.getType();
        eventInternal = eventInternal.addMetadata(string, n2);
        string = "mobile-subtype";
        if (zzc2 == null) {
            n = zzt.zzb.zza.zza();
        } else {
            n = zzc2.getSubtype();
            if (n == -1) {
                n = zzt.zzb.zzu.zza();
            } else if (zzt.zzb.zza(n) == null) {
                n = 0;
            }
        }
        return eventInternal.addMetadata(string, n).build();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackendResponse send(BackendRequest object) {
        ArrayList arrayList;
        Object object2;
        HashMap hashMap;
        Object object3 = hashMap;
        hashMap = new HashMap();
        for (EventInternal eventInternal : object.getEvents()) {
            object2 = eventInternal.getTransportName();
            if (!((HashMap)object3).containsKey(object2)) {
                ArrayList<EventInternal> arrayList2 = new ArrayList<EventInternal>();
                arrayList2.add(eventInternal);
                ((HashMap)object3).put(object2, arrayList2);
                continue;
            }
            ((List)((HashMap)object3).get(object2)).add(eventInternal);
        }
        HashMap hashMap2 = object3;
        object3 = arrayList;
        arrayList = new ArrayList();
        Object object4 = hashMap2.entrySet().iterator();
        while (true) {
            Iterator iterator;
            ArrayList<zzq> arrayList3;
            if (object4.hasNext()) {
                ArrayList<zzq> arrayList4;
                Map.Entry entry = (Map.Entry)object4.next();
                object2 = (EventInternal)((List)entry.getValue()).get(0);
                object2 = zzr.zza().zza(zzu.zza).zza(((zzc)((Object)zzb2)).zze.getTime()).zzb(((zzc)((Object)zzb2)).zzd.getTime()).zza(zzp.zza().zza(zzp.zzb.zzb).zza(com.google.android.datatransport.cct.a.zza.zza().zza(object2.getInteger("sdk-version")).zze(object2.get("model")).zzc(object2.get("hardware")).zza(object2.get("device")).zzg(object2.get("product")).zzf(object2.get("os-uild")).zzd(object2.get("manufacturer")).zzb(object2.get("fingerprint")).zza()).zza());
                try {
                    ((zzr.zza)object2).zza(Integer.parseInt((String)entry.getKey()));
                }
                catch (NumberFormatException numberFormatException) {
                    ((zzr.zza)object2).zzb((String)entry.getKey());
                }
                arrayList3 = arrayList4;
                arrayList4 = new ArrayList<zzq>();
                iterator = ((List)entry.getValue()).iterator();
            } else {
                object3 = zzo.zza((List<zzr>)object3);
                object4 = null;
                URL uRL = ((zzc)((Object)zzb2)).zzc;
                if (object.getExtras() != null) {
                    try {
                        object = CCTDestination.fromByteArray(object.getExtras());
                        if (((CCTDestination)object).getAPIKey() != null) {
                            object4 = ((CCTDestination)object).getAPIKey();
                        }
                        if (((CCTDestination)object).getEndPoint() != null) {
                            URL uRL2 = com.google.android.datatransport.cct.zzc.zza(((CCTDestination)object).getEndPoint());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return BackendResponse.fatalError();
                    }
                }
                try {
                    void var4_12;
                    zzb zzb2 = (zzb)Retries.retry((int)5, (Object)new zza((URL)var4_12, (zzo)object3, (String)object4), (Function)com.google.android.datatransport.cct.zza.zza((zzc)((Object)zzb2)), (RetryStrategy)com.google.android.datatransport.cct.zzb.zza());
                    if (zzb2.zza == 200) {
                        return BackendResponse.ok((long)zzb2.zzc);
                    }
                    int n = zzb2.zza;
                    if (n >= 500) return BackendResponse.transientError();
                    if (n != 404) return BackendResponse.fatalError();
                    return BackendResponse.transientError();
                }
                catch (IOException iOException) {
                    Logging.e((String)"CctTransportBackend", (String)"Could not make request to the backend", (Throwable)iOException);
                    return BackendResponse.transientError();
                }
            }
            while (iterator.hasNext()) {
                Encoding encoding;
                block24: {
                    Object object5;
                    EventInternal eventInternal;
                    block23: {
                        block22: {
                            eventInternal = (EventInternal)iterator.next();
                            object5 = eventInternal.getEncodedPayload();
                            encoding = object5.getEncoding();
                            if (!encoding.equals((Object)Encoding.of((String)"proto"))) break block22;
                            object5 = zzq.zza(object5.getBytes());
                            break block23;
                        }
                        if (!encoding.equals((Object)Encoding.of((String)"json"))) break block24;
                        object5 = zzq.zza(new String(object5.getBytes(), Charset.forName("UTF-8")));
                    }
                    ((zzq.zza)object5).zza(eventInternal.getEventMillis()).zzb(eventInternal.getUptimeMillis()).zzc(eventInternal.getLong("tz-offset")).zza(zzt.zza().zza(zzt.zzc.zza(eventInternal.getInteger("net-type"))).zza(zzt.zzb.zza(eventInternal.getInteger("mobile-subtype"))).zza());
                    if (eventInternal.getCode() != null) {
                        ((zzq.zza)object5).zza(eventInternal.getCode());
                    }
                    arrayList3.add(((zzq.zza)object5).zza());
                    continue;
                }
                Logging.w((String)"CctTransportBackend", (String)"Received event of unsupported encoding %s. Skipping...", (Object)encoding);
            }
            Object object6 = object2;
            ((zzr.zza)object6).zza(arrayList3);
            object3.add(((zzr.zza)object6).zza());
        }
    }

    static final class zza {
        final URL zza;
        final zzo zzb;
        @Nullable
        final String zzc;

        zza(URL uRL, zzo zzo2, @Nullable String string) {
            this.zza = uRL;
            this.zzb = zzo2;
            this.zzc = string;
        }

        zza zza(URL uRL) {
            return new zza(uRL, this.zzb, this.zzc);
        }
    }

    static final class zzb {
        final int zza;
        @Nullable
        final URL zzb;
        final long zzc;

        zzb(int n, @Nullable URL uRL, long l) {
            this.zza = n;
            this.zzb = uRL;
            this.zzc = l;
        }
    }
}

