/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct.internal;

import android.util.JsonReader;
import android.util.JsonToken;
import androidx.annotation.NonNull;
import com.google.android.datatransport.cct.internal.AutoValue_LogResponse;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Reader;

@AutoValue
public abstract class LogResponse {
    private static final String LOG_TAG = "LogResponseInternal";

    public abstract long getNextRequestWaitMillis();

    static LogResponse create(long nextRequestWaitMillis) {
        return new AutoValue_LogResponse(nextRequestWaitMillis);
    }

    @NonNull
    public static LogResponse fromJson(@NonNull Reader reader) throws IOException {
        try (JsonReader jsonReader = new JsonReader(reader);){
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (name.equals("nextRequestWaitMillis")) {
                    if (jsonReader.peek() == JsonToken.STRING) {
                        LogResponse logResponse = LogResponse.create(Long.parseLong(jsonReader.nextString()));
                        return logResponse;
                    }
                    LogResponse logResponse = LogResponse.create(jsonReader.nextLong());
                    return logResponse;
                }
                jsonReader.skipValue();
            }
            throw new IOException("Response is missing nextRequestWaitMillis field.");
        }
    }
}

