/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import androidx.annotation.RestrictTo;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.runtime.AutoValue_TransportContext;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class TransportContext {
    public abstract String getBackendName();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public abstract Priority getPriority();

    public static Builder builder() {
        return new AutoValue_TransportContext.Builder().setPriority(Priority.DEFAULT);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TransportContext withPriority(Priority priority) {
        return TransportContext.builder().setBackendName(this.getBackendName()).setPriority(priority).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private static final Priority[] ALL_PRIORITIES = Priority.values();

        public abstract Builder setBackendName(String var1);

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public abstract Builder setPriority(Priority var1);

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public Builder setPriority(int value) {
            if (value < 0 || value >= ALL_PRIORITIES.length) {
                throw new IllegalArgumentException("Unknown Priority for value " + value);
            }
            this.setPriority(ALL_PRIORITIES[value]);
            return this;
        }

        public abstract TransportContext build();
    }
}

