/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling;

import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.scheduling.ImmediateScheduler$$Lambda$1;
import com.google.android.datatransport.runtime.scheduling.Scheduler;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.inject.Inject;

public class ImmediateScheduler
implements Scheduler {
    private static final Logger LOGGER = Logger.getLogger(TransportRuntime.class.getName());
    private final Executor executor;
    private final BackendRegistry backendRegistry;

    @Inject
    public ImmediateScheduler(Executor executor, BackendRegistry backendRegistry) {
        this.executor = executor;
        this.backendRegistry = backendRegistry;
    }

    @Override
    public void schedule(TransportContext transportContext, EventInternal event) {
        this.executor.execute(ImmediateScheduler$$Lambda$1.lambdaFactory$(this, transportContext, event));
    }

    static /* synthetic */ void lambda$schedule$0(ImmediateScheduler this_, TransportContext transportContext, EventInternal event) {
        TransportBackend backend = this_.backendRegistry.get(transportContext.getBackendName());
        if (backend == null) {
            LOGGER.warning(String.format("Transport backend '%s' is not registered", transportContext.getBackendName()));
            return;
        }
        backend.send(BackendRequest.create(Collections.singleton(backend.decorate(event))));
    }
}

