/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.persistence;

import com.google.android.datatransport.runtime.scheduling.persistence.EventStoreConfig;

final class AutoValue_EventStoreConfig
extends EventStoreConfig {
    private final long maxStorageSizeInBytes;
    private final int loadBatchSize;
    private final int criticalSectionEnterTimeoutMs;
    private final long eventCleanUpAge;

    private AutoValue_EventStoreConfig(long maxStorageSizeInBytes, int loadBatchSize, int criticalSectionEnterTimeoutMs, long eventCleanUpAge) {
        this.maxStorageSizeInBytes = maxStorageSizeInBytes;
        this.loadBatchSize = loadBatchSize;
        this.criticalSectionEnterTimeoutMs = criticalSectionEnterTimeoutMs;
        this.eventCleanUpAge = eventCleanUpAge;
    }

    @Override
    long getMaxStorageSizeInBytes() {
        return this.maxStorageSizeInBytes;
    }

    @Override
    int getLoadBatchSize() {
        return this.loadBatchSize;
    }

    @Override
    int getCriticalSectionEnterTimeoutMs() {
        return this.criticalSectionEnterTimeoutMs;
    }

    @Override
    long getEventCleanUpAge() {
        return this.eventCleanUpAge;
    }

    public String toString() {
        return "EventStoreConfig{maxStorageSizeInBytes=" + this.maxStorageSizeInBytes + ", loadBatchSize=" + this.loadBatchSize + ", criticalSectionEnterTimeoutMs=" + this.criticalSectionEnterTimeoutMs + ", eventCleanUpAge=" + this.eventCleanUpAge + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventStoreConfig) {
            EventStoreConfig that = (EventStoreConfig)o;
            return this.maxStorageSizeInBytes == that.getMaxStorageSizeInBytes() && this.loadBatchSize == that.getLoadBatchSize() && this.criticalSectionEnterTimeoutMs == that.getCriticalSectionEnterTimeoutMs() && this.eventCleanUpAge == that.getEventCleanUpAge();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.maxStorageSizeInBytes >>> 32 ^ this.maxStorageSizeInBytes);
        h$ *= 1000003;
        h$ ^= this.loadBatchSize;
        h$ *= 1000003;
        h$ ^= this.criticalSectionEnterTimeoutMs;
        h$ *= 1000003;
        return h$ ^= (int)(this.eventCleanUpAge >>> 32 ^ this.eventCleanUpAge);
    }

    static final class Builder
    extends EventStoreConfig.Builder {
        private Long maxStorageSizeInBytes;
        private Integer loadBatchSize;
        private Integer criticalSectionEnterTimeoutMs;
        private Long eventCleanUpAge;

        Builder() {
        }

        @Override
        EventStoreConfig.Builder setMaxStorageSizeInBytes(long maxStorageSizeInBytes) {
            this.maxStorageSizeInBytes = maxStorageSizeInBytes;
            return this;
        }

        @Override
        EventStoreConfig.Builder setLoadBatchSize(int loadBatchSize) {
            this.loadBatchSize = loadBatchSize;
            return this;
        }

        @Override
        EventStoreConfig.Builder setCriticalSectionEnterTimeoutMs(int criticalSectionEnterTimeoutMs) {
            this.criticalSectionEnterTimeoutMs = criticalSectionEnterTimeoutMs;
            return this;
        }

        @Override
        EventStoreConfig.Builder setEventCleanUpAge(long eventCleanUpAge) {
            this.eventCleanUpAge = eventCleanUpAge;
            return this;
        }

        @Override
        EventStoreConfig build() {
            String missing = "";
            if (this.maxStorageSizeInBytes == null) {
                missing = missing + " maxStorageSizeInBytes";
            }
            if (this.loadBatchSize == null) {
                missing = missing + " loadBatchSize";
            }
            if (this.criticalSectionEnterTimeoutMs == null) {
                missing = missing + " criticalSectionEnterTimeoutMs";
            }
            if (this.eventCleanUpAge == null) {
                missing = missing + " eventCleanUpAge";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventStoreConfig(this.maxStorageSizeInBytes, this.loadBatchSize, this.criticalSectionEnterTimeoutMs, this.eventCleanUpAge);
        }
    }
}

