/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import androidx.annotation.NonNull;
import com.google.android.datatransport.Encoding;
import java.util.Arrays;

public final class EncodedPayload {
    private final Encoding encoding;
    private final byte[] bytes;

    public EncodedPayload(@NonNull Encoding encoding, @NonNull byte[] bytes) {
        if (encoding == null) {
            throw new NullPointerException("encoding is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        this.encoding = encoding;
        this.bytes = bytes;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncodedPayload)) {
            return false;
        }
        EncodedPayload that = (EncodedPayload)o;
        if (!this.encoding.equals((Object)that.encoding)) {
            return false;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int h = 1000003;
        h ^= this.encoding.hashCode();
        h *= 1000003;
        return h ^= Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return "EncodedPayload{encoding=" + this.encoding + ", bytes=[...]}";
    }
}

