/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AlarmManagerSchedulerBroadcastReceiver;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.util.PriorityMapping;

public class AlarmManagerScheduler
implements WorkScheduler {
    private static final String LOG_TAG = "AlarmManagerScheduler";
    static final String ATTEMPT_NUMBER = "attemptNumber";
    static final String BACKEND_NAME = "backendName";
    static final String EVENT_PRIORITY = "priority";
    static final String EXTRAS = "extras";
    private final Context context;
    private final EventStore eventStore;
    private AlarmManager alarmManager;
    private final SchedulerConfig config;
    private final Clock clock;

    public AlarmManagerScheduler(Context applicationContext, EventStore eventStore, Clock clock, SchedulerConfig config) {
        this(applicationContext, eventStore, (AlarmManager)applicationContext.getSystemService("alarm"), clock, config);
    }

    @VisibleForTesting
    AlarmManagerScheduler(Context applicationContext, EventStore eventStore, AlarmManager alarmManager, Clock clock, SchedulerConfig config) {
        this.context = applicationContext;
        this.eventStore = eventStore;
        this.alarmManager = alarmManager;
        this.clock = clock;
        this.config = config;
    }

    @VisibleForTesting
    boolean isJobServiceOn(Intent intent) {
        int flags = Build.VERSION.SDK_INT >= 23 ? 0x24000000 : 0x20000000;
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)flags) != null;
    }

    @Override
    public void schedule(TransportContext transportContext, int attemptNumber) {
        this.schedule(transportContext, attemptNumber, false);
    }

    @Override
    public void schedule(TransportContext transportContext, int attemptNumber, boolean force) {
        Uri.Builder intentDataBuilder = new Uri.Builder();
        intentDataBuilder.appendQueryParameter(BACKEND_NAME, transportContext.getBackendName());
        intentDataBuilder.appendQueryParameter(EVENT_PRIORITY, String.valueOf(PriorityMapping.toInt(transportContext.getPriority())));
        if (transportContext.getExtras() != null) {
            intentDataBuilder.appendQueryParameter(EXTRAS, Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        Intent intent = new Intent(this.context, AlarmManagerSchedulerBroadcastReceiver.class);
        intent.setData(intentDataBuilder.build());
        intent.putExtra(ATTEMPT_NUMBER, attemptNumber);
        if (!force && this.isJobServiceOn(intent)) {
            Logging.d(LOG_TAG, "Upload for context %s is already scheduled. Returning...", (Object)transportContext);
            return;
        }
        long backendTime = this.eventStore.getNextCallTime(transportContext);
        long scheduleDelay = this.config.getScheduleDelay(transportContext.getPriority(), backendTime, attemptNumber);
        Logging.d(LOG_TAG, "Scheduling upload for context %s in %dms(Backend next call timestamp %d). Attempt %d", transportContext, scheduleDelay, backendTime, attemptNumber);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)(Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0));
        this.alarmManager.set(3, this.clock.getTime() + scheduleDelay, pendingIntent);
    }
}

