/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.MediaPeriodId;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ExoPlaybackException
extends Exception
implements Bundleable {
    public static final int TYPE_SOURCE = 0;
    public static final int TYPE_RENDERER = 1;
    public static final int TYPE_UNEXPECTED = 2;
    public static final int TYPE_REMOTE = 3;
    public final int type;
    @Nullable
    public final String rendererName;
    public final int rendererIndex;
    @Nullable
    public final Format rendererFormat;
    public final int rendererFormatSupport;
    public final long timestampMs;
    @Nullable
    public final MediaPeriodId mediaPeriodId;
    final boolean isRecoverable;
    @Nullable
    private final Throwable cause;
    private static final int FIELD_MESSAGE = 0;
    private static final int FIELD_TYPE = 1;
    private static final int FIELD_RENDERER_NAME = 2;
    private static final int FIELD_RENDERER_INDEX = 3;
    private static final int FIELD_RENDERER_FORMAT = 4;
    private static final int FIELD_RENDERER_FORMAT_SUPPORT = 5;
    private static final int FIELD_TIME_STAMP_MS = 6;
    private static final int FIELD_IS_RECOVERABLE = 7;
    private static final int FIELD_CAUSE_CLASS_NAME = 8;
    private static final int FIELD_CAUSE_MESSAGE = 9;
    public static final Bundleable.Creator<ExoPlaybackException> CREATOR = ExoPlaybackException::fromBundle;

    public static ExoPlaybackException createForSource(IOException cause) {
        return new ExoPlaybackException(0, (Throwable)cause);
    }

    public static ExoPlaybackException createForRenderer(Exception cause) {
        return new ExoPlaybackException(1, cause, null, null, -1, null, 4, false);
    }

    public static ExoPlaybackException createForRenderer(Throwable cause, String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        return ExoPlaybackException.createForRenderer(cause, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, false);
    }

    public static ExoPlaybackException createForRenderer(Throwable cause, String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, boolean isRecoverable) {
        return new ExoPlaybackException(1, cause, null, rendererName, rendererIndex, rendererFormat, rendererFormat == null ? 4 : rendererFormatSupport, isRecoverable);
    }

    public static ExoPlaybackException createForUnexpected(RuntimeException cause) {
        return new ExoPlaybackException(2, (Throwable)cause);
    }

    public static ExoPlaybackException createForRemote(String message) {
        return new ExoPlaybackException(3, message);
    }

    private ExoPlaybackException(int type, Throwable cause) {
        this(type, cause, null, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int type, String message) {
        this(type, null, message, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int type, @Nullable Throwable cause, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, boolean isRecoverable) {
        this(ExoPlaybackException.deriveMessage(type, customMessage, rendererName, rendererIndex, rendererFormat, rendererFormatSupport), cause, type, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, null, SystemClock.elapsedRealtime(), isRecoverable);
    }

    private ExoPlaybackException(String message, @Nullable Throwable cause, int type, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, @Nullable MediaPeriodId mediaPeriodId, long timestampMs, boolean isRecoverable) {
        super(message, cause);
        Assertions.checkArgument(!isRecoverable || type == 1);
        this.type = type;
        this.cause = cause;
        this.rendererName = rendererName;
        this.rendererIndex = rendererIndex;
        this.rendererFormat = rendererFormat;
        this.rendererFormatSupport = rendererFormatSupport;
        this.mediaPeriodId = mediaPeriodId;
        this.timestampMs = timestampMs;
        this.isRecoverable = isRecoverable;
    }

    public IOException getSourceException() {
        Assertions.checkState(this.type == 0);
        return (IOException)Assertions.checkNotNull(this.cause);
    }

    public Exception getRendererException() {
        Assertions.checkState(this.type == 1);
        return (Exception)Assertions.checkNotNull(this.cause);
    }

    public RuntimeException getUnexpectedException() {
        Assertions.checkState(this.type == 2);
        return (RuntimeException)Assertions.checkNotNull(this.cause);
    }

    @CheckResult
    ExoPlaybackException copyWithMediaPeriodId(@Nullable MediaPeriodId mediaPeriodId) {
        return new ExoPlaybackException(Util.castNonNull(this.getMessage()), this.cause, this.type, this.rendererName, this.rendererIndex, this.rendererFormat, this.rendererFormatSupport, mediaPeriodId, this.timestampMs, this.isRecoverable);
    }

    private static String deriveMessage(int type, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        String string;
        String message;
        switch (type) {
            case 0: {
                message = "Source error";
                break;
            }
            case 1: {
                string = String.valueOf(rendererFormat);
                String string2 = C.getFormatSupportString(rendererFormatSupport);
                message = new StringBuilder(53 + String.valueOf(rendererName).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(rendererName).append(" error, index=").append(rendererIndex).append(", format=").append(string).append(", format_supported=").append(string2).toString();
                break;
            }
            case 3: {
                message = "Remote error";
                break;
            }
            default: {
                message = "Unexpected runtime error";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)customMessage)) {
            string = String.valueOf(message);
            message = new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(customMessage).length()).append(string).append(": ").append(customMessage).toString();
        }
        return message;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(ExoPlaybackException.keyForField(0), this.getMessage());
        bundle.putInt(ExoPlaybackException.keyForField(1), this.type);
        bundle.putString(ExoPlaybackException.keyForField(2), this.rendererName);
        bundle.putInt(ExoPlaybackException.keyForField(3), this.rendererIndex);
        bundle.putParcelable(ExoPlaybackException.keyForField(4), (Parcelable)this.rendererFormat);
        bundle.putInt(ExoPlaybackException.keyForField(5), this.rendererFormatSupport);
        bundle.putLong(ExoPlaybackException.keyForField(6), this.timestampMs);
        bundle.putBoolean(ExoPlaybackException.keyForField(7), this.isRecoverable);
        if (this.cause != null) {
            bundle.putString(ExoPlaybackException.keyForField(8), this.cause.getClass().getName());
            bundle.putString(ExoPlaybackException.keyForField(9), this.cause.getMessage());
        }
        return bundle;
    }

    private static ExoPlaybackException fromBundle(Bundle bundle) {
        int type = bundle.getInt(ExoPlaybackException.keyForField(1), 2);
        String rendererName = bundle.getString(ExoPlaybackException.keyForField(2));
        int rendererIndex = bundle.getInt(ExoPlaybackException.keyForField(3), -1);
        Format rendererFormat = (Format)bundle.getParcelable(ExoPlaybackException.keyForField(4));
        int rendererFormatSupport = bundle.getInt(ExoPlaybackException.keyForField(5), 4);
        long timestampMs = bundle.getLong(ExoPlaybackException.keyForField(6), SystemClock.elapsedRealtime());
        boolean isRecoverable = bundle.getBoolean(ExoPlaybackException.keyForField(7), false);
        String message = bundle.getString(ExoPlaybackException.keyForField(0));
        if (message == null) {
            message = ExoPlaybackException.deriveMessage(type, null, rendererName, rendererIndex, rendererFormat, rendererFormatSupport);
        }
        String causeClassName = bundle.getString(ExoPlaybackException.keyForField(8));
        String causeMessage = bundle.getString(ExoPlaybackException.keyForField(9));
        Throwable cause = null;
        if (!TextUtils.isEmpty((CharSequence)causeClassName)) {
            try {
                Class<?> clazz = Class.forName(causeClassName, true, ExoPlaybackException.class.getClassLoader());
                if (Throwable.class.isAssignableFrom(clazz)) {
                    cause = ExoPlaybackException.createThrowable(clazz, causeMessage);
                }
            }
            catch (Throwable e) {
                cause = ExoPlaybackException.createRemoteException(causeMessage);
            }
        }
        return new ExoPlaybackException(message, cause, type, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, null, timestampMs, isRecoverable);
    }

    private static Throwable createThrowable(Class<?> throwableClazz, @Nullable String message) throws Exception {
        return (Throwable)throwableClazz.getConstructor(String.class).newInstance(message);
    }

    private static RemoteException createRemoteException(@Nullable String message) {
        return new RemoteException(message);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

