/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class MediaItem
implements Bundleable {
    public static final String DEFAULT_MEDIA_ID = "";
    public final String mediaId;
    @Nullable
    public final PlaybackProperties playbackProperties;
    public final LiveConfiguration liveConfiguration;
    public final MediaMetadata mediaMetadata;
    public final ClippingProperties clippingProperties;
    private static final int FIELD_MEDIA_ID = 0;
    private static final int FIELD_LIVE_CONFIGURATION = 1;
    private static final int FIELD_MEDIA_METADATA = 2;
    private static final int FIELD_CLIPPING_PROPERTIES = 3;
    public static final Bundleable.Creator<MediaItem> CREATOR = MediaItem::fromBundle;

    public static MediaItem fromUri(String uri) {
        return new Builder().setUri(uri).build();
    }

    public static MediaItem fromUri(Uri uri) {
        return new Builder().setUri(uri).build();
    }

    private MediaItem(String mediaId, ClippingProperties clippingProperties, @Nullable PlaybackProperties playbackProperties, LiveConfiguration liveConfiguration, MediaMetadata mediaMetadata) {
        this.mediaId = mediaId;
        this.playbackProperties = playbackProperties;
        this.liveConfiguration = liveConfiguration;
        this.mediaMetadata = mediaMetadata;
        this.clippingProperties = clippingProperties;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaItem)) {
            return false;
        }
        MediaItem other = (MediaItem)obj;
        return Util.areEqual(this.mediaId, other.mediaId) && this.clippingProperties.equals(other.clippingProperties) && Util.areEqual(this.playbackProperties, other.playbackProperties) && Util.areEqual(this.liveConfiguration, other.liveConfiguration) && Util.areEqual(this.mediaMetadata, other.mediaMetadata);
    }

    public int hashCode() {
        int result = this.mediaId.hashCode();
        result = 31 * result + (this.playbackProperties != null ? this.playbackProperties.hashCode() : 0);
        result = 31 * result + this.liveConfiguration.hashCode();
        result = 31 * result + this.clippingProperties.hashCode();
        result = 31 * result + this.mediaMetadata.hashCode();
        return result;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(MediaItem.keyForField(0), this.mediaId);
        bundle.putBundle(MediaItem.keyForField(1), this.liveConfiguration.toBundle());
        bundle.putBundle(MediaItem.keyForField(2), this.mediaMetadata.toBundle());
        bundle.putBundle(MediaItem.keyForField(3), this.clippingProperties.toBundle());
        return bundle;
    }

    private static MediaItem fromBundle(Bundle bundle) {
        String mediaId = Assertions.checkNotNull(bundle.getString(MediaItem.keyForField(0), DEFAULT_MEDIA_ID));
        Bundle liveConfigurationBundle = bundle.getBundle(MediaItem.keyForField(1));
        LiveConfiguration liveConfiguration = liveConfigurationBundle == null ? LiveConfiguration.UNSET : LiveConfiguration.CREATOR.fromBundle(liveConfigurationBundle);
        Bundle mediaMetadataBundle = bundle.getBundle(MediaItem.keyForField(2));
        MediaMetadata mediaMetadata = mediaMetadataBundle == null ? MediaMetadata.EMPTY : MediaMetadata.CREATOR.fromBundle(mediaMetadataBundle);
        Bundle clippingPropertiesBundle = bundle.getBundle(MediaItem.keyForField(3));
        ClippingProperties clippingProperties = clippingPropertiesBundle == null ? new ClippingProperties(0L, Long.MIN_VALUE, false, false, false) : ClippingProperties.CREATOR.fromBundle(clippingPropertiesBundle);
        return new MediaItem(mediaId, clippingProperties, null, liveConfiguration, mediaMetadata);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    public static final class ClippingProperties
    implements Bundleable {
        public final long startPositionMs;
        public final long endPositionMs;
        public final boolean relativeToLiveWindow;
        public final boolean relativeToDefaultPosition;
        public final boolean startsAtKeyFrame;
        private static final int FIELD_START_POSITION_MS = 0;
        private static final int FIELD_END_POSITION_MS = 1;
        private static final int FIELD_RELATIVE_TO_LIVE_WINDOW = 2;
        private static final int FIELD_RELATIVE_TO_DEFAULT_POSITION = 3;
        private static final int FIELD_STARTS_AT_KEY_FRAME = 4;
        public static final Bundleable.Creator<ClippingProperties> CREATOR = bundle -> new ClippingProperties(bundle.getLong(ClippingProperties.keyForField(0), 0L), bundle.getLong(ClippingProperties.keyForField(1), Long.MIN_VALUE), bundle.getBoolean(ClippingProperties.keyForField(2), false), bundle.getBoolean(ClippingProperties.keyForField(3), false), bundle.getBoolean(ClippingProperties.keyForField(4), false));

        private ClippingProperties(long startPositionMs, long endPositionMs, boolean relativeToLiveWindow, boolean relativeToDefaultPosition, boolean startsAtKeyFrame) {
            this.startPositionMs = startPositionMs;
            this.endPositionMs = endPositionMs;
            this.relativeToLiveWindow = relativeToLiveWindow;
            this.relativeToDefaultPosition = relativeToDefaultPosition;
            this.startsAtKeyFrame = startsAtKeyFrame;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClippingProperties)) {
                return false;
            }
            ClippingProperties other = (ClippingProperties)obj;
            return this.startPositionMs == other.startPositionMs && this.endPositionMs == other.endPositionMs && this.relativeToLiveWindow == other.relativeToLiveWindow && this.relativeToDefaultPosition == other.relativeToDefaultPosition && this.startsAtKeyFrame == other.startsAtKeyFrame;
        }

        public int hashCode() {
            int result = (int)(this.startPositionMs ^ this.startPositionMs >>> 32);
            result = 31 * result + (int)(this.endPositionMs ^ this.endPositionMs >>> 32);
            result = 31 * result + (this.relativeToLiveWindow ? 1 : 0);
            result = 31 * result + (this.relativeToDefaultPosition ? 1 : 0);
            result = 31 * result + (this.startsAtKeyFrame ? 1 : 0);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putLong(ClippingProperties.keyForField(0), this.startPositionMs);
            bundle.putLong(ClippingProperties.keyForField(1), this.endPositionMs);
            bundle.putBoolean(ClippingProperties.keyForField(2), this.relativeToLiveWindow);
            bundle.putBoolean(ClippingProperties.keyForField(3), this.relativeToDefaultPosition);
            bundle.putBoolean(ClippingProperties.keyForField(4), this.startsAtKeyFrame);
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }

    public static final class Subtitle {
        public final Uri uri;
        public final String mimeType;
        @Nullable
        public final String language;
        public final int selectionFlags;
        public final int roleFlags;
        @Nullable
        public final String label;

        public Subtitle(Uri uri, String mimeType, @Nullable String language) {
            this(uri, mimeType, language, 0);
        }

        public Subtitle(Uri uri, String mimeType, @Nullable String language, int selectionFlags) {
            this(uri, mimeType, language, selectionFlags, 0, null);
        }

        public Subtitle(Uri uri, String mimeType, @Nullable String language, int selectionFlags, int roleFlags, @Nullable String label) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.language = language;
            this.selectionFlags = selectionFlags;
            this.roleFlags = roleFlags;
            this.label = label;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Subtitle)) {
                return false;
            }
            Subtitle other = (Subtitle)obj;
            return this.uri.equals((Object)other.uri) && this.mimeType.equals(other.mimeType) && Util.areEqual(this.language, other.language) && this.selectionFlags == other.selectionFlags && this.roleFlags == other.roleFlags && Util.areEqual(this.label, other.label);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + this.mimeType.hashCode();
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + this.selectionFlags;
            result = 31 * result + this.roleFlags;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }
    }

    public static final class LiveConfiguration
    implements Bundleable {
        public static final LiveConfiguration UNSET = new LiveConfiguration(-9223372036854775807L, -9223372036854775807L, -9223372036854775807L, -3.4028235E38f, -3.4028235E38f);
        public final long targetOffsetMs;
        public final long minOffsetMs;
        public final long maxOffsetMs;
        public final float minPlaybackSpeed;
        public final float maxPlaybackSpeed;
        private static final int FIELD_TARGET_OFFSET_MS = 0;
        private static final int FIELD_MIN_OFFSET_MS = 1;
        private static final int FIELD_MAX_OFFSET_MS = 2;
        private static final int FIELD_MIN_PLAYBACK_SPEED = 3;
        private static final int FIELD_MAX_PLAYBACK_SPEED = 4;
        public static final Bundleable.Creator<LiveConfiguration> CREATOR = bundle -> new LiveConfiguration(bundle.getLong(LiveConfiguration.keyForField(0), -9223372036854775807L), bundle.getLong(LiveConfiguration.keyForField(1), -9223372036854775807L), bundle.getLong(LiveConfiguration.keyForField(2), -9223372036854775807L), bundle.getFloat(LiveConfiguration.keyForField(3), -3.4028235E38f), bundle.getFloat(LiveConfiguration.keyForField(4), -3.4028235E38f));

        public LiveConfiguration(long targetOffsetMs, long minOffsetMs, long maxOffsetMs, float minPlaybackSpeed, float maxPlaybackSpeed) {
            this.targetOffsetMs = targetOffsetMs;
            this.minOffsetMs = minOffsetMs;
            this.maxOffsetMs = maxOffsetMs;
            this.minPlaybackSpeed = minPlaybackSpeed;
            this.maxPlaybackSpeed = maxPlaybackSpeed;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LiveConfiguration)) {
                return false;
            }
            LiveConfiguration other = (LiveConfiguration)obj;
            return this.targetOffsetMs == other.targetOffsetMs && this.minOffsetMs == other.minOffsetMs && this.maxOffsetMs == other.maxOffsetMs && this.minPlaybackSpeed == other.minPlaybackSpeed && this.maxPlaybackSpeed == other.maxPlaybackSpeed;
        }

        public int hashCode() {
            int result = (int)(this.targetOffsetMs ^ this.targetOffsetMs >>> 32);
            result = 31 * result + (int)(this.minOffsetMs ^ this.minOffsetMs >>> 32);
            result = 31 * result + (int)(this.maxOffsetMs ^ this.maxOffsetMs >>> 32);
            result = 31 * result + (this.minPlaybackSpeed != 0.0f ? Float.floatToIntBits(this.minPlaybackSpeed) : 0);
            result = 31 * result + (this.maxPlaybackSpeed != 0.0f ? Float.floatToIntBits(this.maxPlaybackSpeed) : 0);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putLong(LiveConfiguration.keyForField(0), this.targetOffsetMs);
            bundle.putLong(LiveConfiguration.keyForField(1), this.minOffsetMs);
            bundle.putLong(LiveConfiguration.keyForField(2), this.maxOffsetMs);
            bundle.putFloat(LiveConfiguration.keyForField(3), this.minPlaybackSpeed);
            bundle.putFloat(LiveConfiguration.keyForField(4), this.maxPlaybackSpeed);
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }

    public static final class PlaybackProperties {
        public final Uri uri;
        @Nullable
        public final String mimeType;
        @Nullable
        public final DrmConfiguration drmConfiguration;
        @Nullable
        public final AdsConfiguration adsConfiguration;
        public final List<StreamKey> streamKeys;
        @Nullable
        public final String customCacheKey;
        public final List<Subtitle> subtitles;
        @Nullable
        public final Object tag;

        private PlaybackProperties(Uri uri, @Nullable String mimeType, @Nullable DrmConfiguration drmConfiguration, @Nullable AdsConfiguration adsConfiguration, List<StreamKey> streamKeys, @Nullable String customCacheKey, List<Subtitle> subtitles, @Nullable Object tag) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.drmConfiguration = drmConfiguration;
            this.adsConfiguration = adsConfiguration;
            this.streamKeys = streamKeys;
            this.customCacheKey = customCacheKey;
            this.subtitles = subtitles;
            this.tag = tag;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PlaybackProperties)) {
                return false;
            }
            PlaybackProperties other = (PlaybackProperties)obj;
            return this.uri.equals((Object)other.uri) && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.drmConfiguration, other.drmConfiguration) && Util.areEqual(this.adsConfiguration, other.adsConfiguration) && this.streamKeys.equals(other.streamKeys) && Util.areEqual(this.customCacheKey, other.customCacheKey) && this.subtitles.equals(other.subtitles) && Util.areEqual(this.tag, other.tag);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.drmConfiguration == null ? 0 : this.drmConfiguration.hashCode());
            result = 31 * result + (this.adsConfiguration == null ? 0 : this.adsConfiguration.hashCode());
            result = 31 * result + this.streamKeys.hashCode();
            result = 31 * result + (this.customCacheKey == null ? 0 : this.customCacheKey.hashCode());
            result = 31 * result + this.subtitles.hashCode();
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }
    }

    public static final class AdsConfiguration {
        public final Uri adTagUri;
        @Nullable
        public final Object adsId;

        private AdsConfiguration(Uri adTagUri, @Nullable Object adsId) {
            this.adTagUri = adTagUri;
            this.adsId = adsId;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AdsConfiguration)) {
                return false;
            }
            AdsConfiguration other = (AdsConfiguration)obj;
            return this.adTagUri.equals((Object)other.adTagUri) && Util.areEqual(this.adsId, other.adsId);
        }

        public int hashCode() {
            int result = this.adTagUri.hashCode();
            result = 31 * result + (this.adsId != null ? this.adsId.hashCode() : 0);
            return result;
        }
    }

    public static final class DrmConfiguration {
        public final UUID uuid;
        @Nullable
        public final Uri licenseUri;
        public final Map<String, String> requestHeaders;
        public final boolean multiSession;
        public final boolean playClearContentWithoutKey;
        public final boolean forceDefaultLicenseUri;
        public final List<Integer> sessionForClearTypes;
        @Nullable
        private final byte[] keySetId;

        private DrmConfiguration(UUID uuid, @Nullable Uri licenseUri, Map<String, String> requestHeaders, boolean multiSession, boolean forceDefaultLicenseUri, boolean playClearContentWithoutKey, List<Integer> drmSessionForClearTypes, @Nullable byte[] keySetId) {
            Assertions.checkArgument(!forceDefaultLicenseUri || licenseUri != null);
            this.uuid = uuid;
            this.licenseUri = licenseUri;
            this.requestHeaders = requestHeaders;
            this.multiSession = multiSession;
            this.forceDefaultLicenseUri = forceDefaultLicenseUri;
            this.playClearContentWithoutKey = playClearContentWithoutKey;
            this.sessionForClearTypes = drmSessionForClearTypes;
            this.keySetId = keySetId != null ? Arrays.copyOf(keySetId, keySetId.length) : null;
        }

        @Nullable
        public byte[] getKeySetId() {
            return this.keySetId != null ? Arrays.copyOf(this.keySetId, this.keySetId.length) : null;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DrmConfiguration)) {
                return false;
            }
            DrmConfiguration other = (DrmConfiguration)obj;
            return this.uuid.equals(other.uuid) && Util.areEqual(this.licenseUri, other.licenseUri) && Util.areEqual(this.requestHeaders, other.requestHeaders) && this.multiSession == other.multiSession && this.forceDefaultLicenseUri == other.forceDefaultLicenseUri && this.playClearContentWithoutKey == other.playClearContentWithoutKey && this.sessionForClearTypes.equals(other.sessionForClearTypes) && Arrays.equals(this.keySetId, other.keySetId);
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = 31 * result + (this.licenseUri != null ? this.licenseUri.hashCode() : 0);
            result = 31 * result + this.requestHeaders.hashCode();
            result = 31 * result + (this.multiSession ? 1 : 0);
            result = 31 * result + (this.forceDefaultLicenseUri ? 1 : 0);
            result = 31 * result + (this.playClearContentWithoutKey ? 1 : 0);
            result = 31 * result + this.sessionForClearTypes.hashCode();
            result = 31 * result + Arrays.hashCode(this.keySetId);
            return result;
        }
    }

    public static final class Builder {
        @Nullable
        private String mediaId;
        @Nullable
        private Uri uri;
        @Nullable
        private String mimeType;
        private long clipStartPositionMs;
        private long clipEndPositionMs = Long.MIN_VALUE;
        private boolean clipRelativeToLiveWindow;
        private boolean clipRelativeToDefaultPosition;
        private boolean clipStartsAtKeyFrame;
        @Nullable
        private Uri drmLicenseUri;
        private Map<String, String> drmLicenseRequestHeaders;
        @Nullable
        private UUID drmUuid;
        private boolean drmMultiSession;
        private boolean drmPlayClearContentWithoutKey;
        private boolean drmForceDefaultLicenseUri;
        private List<Integer> drmSessionForClearTypes = Collections.emptyList();
        @Nullable
        private byte[] drmKeySetId;
        private List<StreamKey> streamKeys;
        @Nullable
        private String customCacheKey;
        private List<Subtitle> subtitles;
        @Nullable
        private Uri adTagUri;
        @Nullable
        private Object adsId;
        @Nullable
        private Object tag;
        @Nullable
        private MediaMetadata mediaMetadata;
        private long liveTargetOffsetMs = -9223372036854775807L;
        private long liveMinOffsetMs = -9223372036854775807L;
        private long liveMaxOffsetMs = -9223372036854775807L;
        private float liveMinPlaybackSpeed = -3.4028235E38f;
        private float liveMaxPlaybackSpeed = -3.4028235E38f;

        public Builder() {
            this.drmLicenseRequestHeaders = Collections.emptyMap();
            this.streamKeys = Collections.emptyList();
            this.subtitles = Collections.emptyList();
        }

        private Builder(MediaItem mediaItem) {
            this();
            this.clipEndPositionMs = mediaItem.clippingProperties.endPositionMs;
            this.clipRelativeToLiveWindow = mediaItem.clippingProperties.relativeToLiveWindow;
            this.clipRelativeToDefaultPosition = mediaItem.clippingProperties.relativeToDefaultPosition;
            this.clipStartPositionMs = mediaItem.clippingProperties.startPositionMs;
            this.clipStartsAtKeyFrame = mediaItem.clippingProperties.startsAtKeyFrame;
            this.mediaId = mediaItem.mediaId;
            this.mediaMetadata = mediaItem.mediaMetadata;
            this.liveTargetOffsetMs = mediaItem.liveConfiguration.targetOffsetMs;
            this.liveMinOffsetMs = mediaItem.liveConfiguration.minOffsetMs;
            this.liveMaxOffsetMs = mediaItem.liveConfiguration.maxOffsetMs;
            this.liveMinPlaybackSpeed = mediaItem.liveConfiguration.minPlaybackSpeed;
            this.liveMaxPlaybackSpeed = mediaItem.liveConfiguration.maxPlaybackSpeed;
            PlaybackProperties playbackProperties = mediaItem.playbackProperties;
            if (playbackProperties != null) {
                AdsConfiguration adsConfiguration;
                this.customCacheKey = playbackProperties.customCacheKey;
                this.mimeType = playbackProperties.mimeType;
                this.uri = playbackProperties.uri;
                this.streamKeys = playbackProperties.streamKeys;
                this.subtitles = playbackProperties.subtitles;
                this.tag = playbackProperties.tag;
                DrmConfiguration drmConfiguration = playbackProperties.drmConfiguration;
                if (drmConfiguration != null) {
                    this.drmLicenseUri = drmConfiguration.licenseUri;
                    this.drmLicenseRequestHeaders = drmConfiguration.requestHeaders;
                    this.drmMultiSession = drmConfiguration.multiSession;
                    this.drmForceDefaultLicenseUri = drmConfiguration.forceDefaultLicenseUri;
                    this.drmPlayClearContentWithoutKey = drmConfiguration.playClearContentWithoutKey;
                    this.drmSessionForClearTypes = drmConfiguration.sessionForClearTypes;
                    this.drmUuid = drmConfiguration.uuid;
                    this.drmKeySetId = drmConfiguration.getKeySetId();
                }
                if ((adsConfiguration = playbackProperties.adsConfiguration) != null) {
                    this.adTagUri = adsConfiguration.adTagUri;
                    this.adsId = adsConfiguration.adsId;
                }
            }
        }

        public Builder setMediaId(String mediaId) {
            this.mediaId = Assertions.checkNotNull(mediaId);
            return this;
        }

        public Builder setUri(@Nullable String uri) {
            return this.setUri(uri == null ? null : Uri.parse((String)uri));
        }

        public Builder setUri(@Nullable Uri uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMimeType(@Nullable String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setClipStartPositionMs(long startPositionMs) {
            Assertions.checkArgument(startPositionMs >= 0L);
            this.clipStartPositionMs = startPositionMs;
            return this;
        }

        public Builder setClipEndPositionMs(long endPositionMs) {
            Assertions.checkArgument(endPositionMs == Long.MIN_VALUE || endPositionMs >= 0L);
            this.clipEndPositionMs = endPositionMs;
            return this;
        }

        public Builder setClipRelativeToLiveWindow(boolean relativeToLiveWindow) {
            this.clipRelativeToLiveWindow = relativeToLiveWindow;
            return this;
        }

        public Builder setClipRelativeToDefaultPosition(boolean relativeToDefaultPosition) {
            this.clipRelativeToDefaultPosition = relativeToDefaultPosition;
            return this;
        }

        public Builder setClipStartsAtKeyFrame(boolean startsAtKeyFrame) {
            this.clipStartsAtKeyFrame = startsAtKeyFrame;
            return this;
        }

        public Builder setDrmLicenseUri(@Nullable Uri licenseUri) {
            this.drmLicenseUri = licenseUri;
            return this;
        }

        public Builder setDrmLicenseUri(@Nullable String licenseUri) {
            this.drmLicenseUri = licenseUri == null ? null : Uri.parse((String)licenseUri);
            return this;
        }

        public Builder setDrmLicenseRequestHeaders(@Nullable Map<String, String> licenseRequestHeaders) {
            this.drmLicenseRequestHeaders = licenseRequestHeaders != null && !licenseRequestHeaders.isEmpty() ? Collections.unmodifiableMap(new HashMap<String, String>(licenseRequestHeaders)) : Collections.emptyMap();
            return this;
        }

        public Builder setDrmUuid(@Nullable UUID uuid) {
            this.drmUuid = uuid;
            return this;
        }

        public Builder setDrmMultiSession(boolean multiSession) {
            this.drmMultiSession = multiSession;
            return this;
        }

        public Builder setDrmForceDefaultLicenseUri(boolean forceDefaultLicenseUri) {
            this.drmForceDefaultLicenseUri = forceDefaultLicenseUri;
            return this;
        }

        public Builder setDrmPlayClearContentWithoutKey(boolean playClearContentWithoutKey) {
            this.drmPlayClearContentWithoutKey = playClearContentWithoutKey;
            return this;
        }

        public Builder setDrmSessionForClearPeriods(boolean sessionForClearPeriods) {
            this.setDrmSessionForClearTypes(sessionForClearPeriods ? Arrays.asList(2, 1) : Collections.emptyList());
            return this;
        }

        public Builder setDrmSessionForClearTypes(@Nullable List<Integer> sessionForClearTypes) {
            this.drmSessionForClearTypes = sessionForClearTypes != null && !sessionForClearTypes.isEmpty() ? Collections.unmodifiableList(new ArrayList<Integer>(sessionForClearTypes)) : Collections.emptyList();
            return this;
        }

        public Builder setDrmKeySetId(@Nullable byte[] keySetId) {
            this.drmKeySetId = keySetId != null ? Arrays.copyOf(keySetId, keySetId.length) : null;
            return this;
        }

        public Builder setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null && !streamKeys.isEmpty() ? Collections.unmodifiableList(new ArrayList<StreamKey>(streamKeys)) : Collections.emptyList();
            return this;
        }

        public Builder setCustomCacheKey(@Nullable String customCacheKey) {
            this.customCacheKey = customCacheKey;
            return this;
        }

        public Builder setSubtitles(@Nullable List<Subtitle> subtitles) {
            this.subtitles = subtitles != null && !subtitles.isEmpty() ? Collections.unmodifiableList(new ArrayList<Subtitle>(subtitles)) : Collections.emptyList();
            return this;
        }

        public Builder setAdTagUri(@Nullable String adTagUri) {
            return this.setAdTagUri(adTagUri != null ? Uri.parse((String)adTagUri) : null);
        }

        public Builder setAdTagUri(@Nullable Uri adTagUri) {
            return this.setAdTagUri(adTagUri, null);
        }

        public Builder setAdTagUri(@Nullable Uri adTagUri, @Nullable Object adsId) {
            this.adTagUri = adTagUri;
            this.adsId = adsId;
            return this;
        }

        public Builder setLiveTargetOffsetMs(long liveTargetOffsetMs) {
            this.liveTargetOffsetMs = liveTargetOffsetMs;
            return this;
        }

        public Builder setLiveMinOffsetMs(long liveMinOffsetMs) {
            this.liveMinOffsetMs = liveMinOffsetMs;
            return this;
        }

        public Builder setLiveMaxOffsetMs(long liveMaxOffsetMs) {
            this.liveMaxOffsetMs = liveMaxOffsetMs;
            return this;
        }

        public Builder setLiveMinPlaybackSpeed(float minPlaybackSpeed) {
            this.liveMinPlaybackSpeed = minPlaybackSpeed;
            return this;
        }

        public Builder setLiveMaxPlaybackSpeed(float maxPlaybackSpeed) {
            this.liveMaxPlaybackSpeed = maxPlaybackSpeed;
            return this;
        }

        public Builder setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public Builder setMediaMetadata(MediaMetadata mediaMetadata) {
            this.mediaMetadata = mediaMetadata;
            return this;
        }

        public MediaItem build() {
            Assertions.checkState(this.drmLicenseUri == null || this.drmUuid != null);
            PlaybackProperties playbackProperties = null;
            Uri uri = this.uri;
            if (uri != null) {
                playbackProperties = new PlaybackProperties(uri, this.mimeType, this.drmUuid != null ? new DrmConfiguration(this.drmUuid, this.drmLicenseUri, this.drmLicenseRequestHeaders, this.drmMultiSession, this.drmForceDefaultLicenseUri, this.drmPlayClearContentWithoutKey, this.drmSessionForClearTypes, this.drmKeySetId) : null, this.adTagUri != null ? new AdsConfiguration(this.adTagUri, this.adsId) : null, this.streamKeys, this.customCacheKey, this.subtitles, this.tag);
            }
            return new MediaItem(this.mediaId != null ? this.mediaId : MediaItem.DEFAULT_MEDIA_ID, new ClippingProperties(this.clipStartPositionMs, this.clipEndPositionMs, this.clipRelativeToLiveWindow, this.clipRelativeToDefaultPosition, this.clipStartsAtKeyFrame), playbackProperties, new LiveConfiguration(this.liveTargetOffsetMs, this.liveMinOffsetMs, this.liveMaxOffsetMs, this.liveMinPlaybackSpeed, this.liveMaxPlaybackSpeed), this.mediaMetadata != null ? this.mediaMetadata : MediaMetadata.EMPTY);
        }
    }
}

