/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BundleListRetriever;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.BundleUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;

public abstract class Timeline
implements Bundleable {
    public static final Timeline EMPTY = new Timeline(){

        @Override
        public int getWindowCount() {
            return 0;
        }

        @Override
        public Window getWindow(int windowIndex, Window window, long defaultPositionProjectionUs) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getPeriodCount() {
            return 0;
        }

        @Override
        public Period getPeriod(int periodIndex, Period period, boolean setIds) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            return -1;
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            throw new IndexOutOfBoundsException();
        }
    };
    private static final int FIELD_WINDOWS = 0;
    private static final int FIELD_PERIODS = 1;
    private static final int FIELD_SHUFFLED_WINDOW_INDICES = 2;
    public static final Bundleable.Creator<Timeline> CREATOR = Timeline::fromBundle;

    public final boolean isEmpty() {
        return this.getWindowCount() == 0;
    }

    public abstract int getWindowCount();

    public int getNextWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
        switch (repeatMode) {
            case 0: {
                return windowIndex == this.getLastWindowIndex(shuffleModeEnabled) ? -1 : windowIndex + 1;
            }
            case 1: {
                return windowIndex;
            }
            case 2: {
                return windowIndex == this.getLastWindowIndex(shuffleModeEnabled) ? this.getFirstWindowIndex(shuffleModeEnabled) : windowIndex + 1;
            }
        }
        throw new IllegalStateException();
    }

    public int getPreviousWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
        switch (repeatMode) {
            case 0: {
                return windowIndex == this.getFirstWindowIndex(shuffleModeEnabled) ? -1 : windowIndex - 1;
            }
            case 1: {
                return windowIndex;
            }
            case 2: {
                return windowIndex == this.getFirstWindowIndex(shuffleModeEnabled) ? this.getLastWindowIndex(shuffleModeEnabled) : windowIndex - 1;
            }
        }
        throw new IllegalStateException();
    }

    public int getLastWindowIndex(boolean shuffleModeEnabled) {
        return this.isEmpty() ? -1 : this.getWindowCount() - 1;
    }

    public int getFirstWindowIndex(boolean shuffleModeEnabled) {
        return this.isEmpty() ? -1 : 0;
    }

    public final Window getWindow(int windowIndex, Window window) {
        return this.getWindow(windowIndex, window, 0L);
    }

    @Deprecated
    public final Window getWindow(int windowIndex, Window window, boolean setTag) {
        return this.getWindow(windowIndex, window, 0L);
    }

    public abstract Window getWindow(int var1, Window var2, long var3);

    public abstract int getPeriodCount();

    public final int getNextPeriodIndex(int periodIndex, Period period, Window window, int repeatMode, boolean shuffleModeEnabled) {
        int windowIndex = this.getPeriod((int)periodIndex, (Period)period).windowIndex;
        if (this.getWindow((int)windowIndex, (Window)window).lastPeriodIndex == periodIndex) {
            int nextWindowIndex = this.getNextWindowIndex(windowIndex, repeatMode, shuffleModeEnabled);
            if (nextWindowIndex == -1) {
                return -1;
            }
            return this.getWindow((int)nextWindowIndex, (Window)window).firstPeriodIndex;
        }
        return periodIndex + 1;
    }

    public final boolean isLastPeriod(int periodIndex, Period period, Window window, int repeatMode, boolean shuffleModeEnabled) {
        return this.getNextPeriodIndex(periodIndex, period, window, repeatMode, shuffleModeEnabled) == -1;
    }

    public final Pair<Object, Long> getPeriodPosition(Window window, Period period, int windowIndex, long windowPositionUs) {
        return Assertions.checkNotNull(this.getPeriodPosition(window, period, windowIndex, windowPositionUs, 0L));
    }

    @Nullable
    public final Pair<Object, Long> getPeriodPosition(Window window, Period period, int windowIndex, long windowPositionUs, long defaultPositionProjectionUs) {
        int periodIndex;
        Assertions.checkIndex(windowIndex, 0, this.getWindowCount());
        this.getWindow(windowIndex, window, defaultPositionProjectionUs);
        if (windowPositionUs == -9223372036854775807L && (windowPositionUs = window.getDefaultPositionUs()) == -9223372036854775807L) {
            return null;
        }
        this.getPeriod(periodIndex, period);
        for (periodIndex = window.firstPeriodIndex; periodIndex < window.lastPeriodIndex && period.positionInWindowUs != windowPositionUs && this.getPeriod((int)(periodIndex + 1), (Period)period).positionInWindowUs <= windowPositionUs; ++periodIndex) {
        }
        this.getPeriod(periodIndex, period, true);
        long periodPositionUs = windowPositionUs - period.positionInWindowUs;
        return Pair.create((Object)Assertions.checkNotNull(period.uid), (Object)periodPositionUs);
    }

    public Period getPeriodByUid(Object periodUid, Period period) {
        return this.getPeriod(this.getIndexOfPeriod(periodUid), period, true);
    }

    public final Period getPeriod(int periodIndex, Period period) {
        return this.getPeriod(periodIndex, period, false);
    }

    public abstract Period getPeriod(int var1, Period var2, boolean var3);

    public abstract int getIndexOfPeriod(Object var1);

    public abstract Object getUidOfPeriod(int var1);

    public boolean equals(@Nullable Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timeline)) {
            return false;
        }
        Timeline other = (Timeline)obj;
        if (other.getWindowCount() != this.getWindowCount() || other.getPeriodCount() != this.getPeriodCount()) {
            return false;
        }
        Window window = new Window();
        Period period = new Period();
        Window otherWindow = new Window();
        Period otherPeriod = new Period();
        for (i = 0; i < this.getWindowCount(); ++i) {
            if (this.getWindow(i, window).equals(other.getWindow(i, otherWindow))) continue;
            return false;
        }
        for (i = 0; i < this.getPeriodCount(); ++i) {
            if (this.getPeriod(i, period, true).equals(other.getPeriod(i, otherPeriod, true))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        Window window = new Window();
        Period period = new Period();
        int result = 7;
        result = 31 * result + this.getWindowCount();
        for (i = 0; i < this.getWindowCount(); ++i) {
            result = 31 * result + this.getWindow(i, window).hashCode();
        }
        result = 31 * result + this.getPeriodCount();
        for (i = 0; i < this.getPeriodCount(); ++i) {
            result = 31 * result + this.getPeriod(i, period, true).hashCode();
        }
        return result;
    }

    @Override
    public final Bundle toBundle() {
        ArrayList<Bundle> windowBundles = new ArrayList<Bundle>();
        int windowCount = this.getWindowCount();
        Window window = new Window();
        for (int i = 0; i < windowCount; ++i) {
            windowBundles.add(this.getWindow(i, window, 0L).toBundle());
        }
        ArrayList<Bundle> periodBundles = new ArrayList<Bundle>();
        int periodCount = this.getPeriodCount();
        Period period = new Period();
        for (int i = 0; i < periodCount; ++i) {
            periodBundles.add(this.getPeriod(i, period, false).toBundle());
        }
        int[] shuffledWindowIndices = new int[windowCount];
        if (windowCount > 0) {
            shuffledWindowIndices[0] = this.getFirstWindowIndex(true);
        }
        for (int i = 1; i < windowCount; ++i) {
            shuffledWindowIndices[i] = this.getNextWindowIndex(shuffledWindowIndices[i - 1], 0, true);
        }
        Bundle bundle = new Bundle();
        BundleUtil.putBinder(bundle, Timeline.keyForField(0), (IBinder)new BundleListRetriever(windowBundles));
        BundleUtil.putBinder(bundle, Timeline.keyForField(1), (IBinder)new BundleListRetriever(periodBundles));
        bundle.putIntArray(Timeline.keyForField(2), shuffledWindowIndices);
        return bundle;
    }

    private static Timeline fromBundle(Bundle bundle) {
        ImmutableList<Window> windows = Timeline.fromBundleListRetriever(Window.CREATOR, BundleUtil.getBinder(bundle, Timeline.keyForField(0)));
        ImmutableList<Period> periods = Timeline.fromBundleListRetriever(Period.CREATOR, BundleUtil.getBinder(bundle, Timeline.keyForField(1)));
        int[] shuffledWindowIndices = bundle.getIntArray(Timeline.keyForField(2));
        return new RemotableTimeline(windows, periods, shuffledWindowIndices == null ? Timeline.generateUnshuffledIndices(windows.size()) : shuffledWindowIndices);
    }

    private static <T extends Bundleable> ImmutableList<T> fromBundleListRetriever(Bundleable.Creator<T> creator, @Nullable IBinder binder) {
        if (binder == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ImmutableList<Bundle> bundleList = BundleListRetriever.getList(binder);
        for (int i = 0; i < bundleList.size(); ++i) {
            builder.add(creator.fromBundle((Bundle)bundleList.get(i)));
        }
        return builder.build();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    private static int[] generateUnshuffledIndices(int n) {
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    private static final class RemotableTimeline
    extends Timeline {
        private final ImmutableList<Window> windows;
        private final ImmutableList<Period> periods;
        private final int[] shuffledWindowIndices;
        private final int[] windowIndicesInShuffled;

        public RemotableTimeline(ImmutableList<Window> windows, ImmutableList<Period> periods, int[] shuffledWindowIndices) {
            Assertions.checkArgument(windows.size() == shuffledWindowIndices.length);
            this.windows = windows;
            this.periods = periods;
            this.shuffledWindowIndices = shuffledWindowIndices;
            this.windowIndicesInShuffled = new int[shuffledWindowIndices.length];
            for (int i = 0; i < shuffledWindowIndices.length; ++i) {
                this.windowIndicesInShuffled[shuffledWindowIndices[i]] = i;
            }
        }

        @Override
        public int getWindowCount() {
            return this.windows.size();
        }

        @Override
        public Window getWindow(int windowIndex, Window window, long ignoredDefaultPositionProjectionUs) {
            Window w = (Window)this.windows.get(windowIndex);
            window.set(w.uid, w.mediaItem, w.manifest, w.presentationStartTimeMs, w.windowStartTimeMs, w.elapsedRealtimeEpochOffsetMs, w.isSeekable, w.isDynamic, w.liveConfiguration, w.defaultPositionUs, w.durationUs, w.firstPeriodIndex, w.lastPeriodIndex, w.positionInFirstPeriodUs);
            window.isPlaceholder = w.isPlaceholder;
            return window;
        }

        @Override
        public int getNextWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
            if (repeatMode == 1) {
                return windowIndex;
            }
            if (windowIndex == this.getLastWindowIndex(shuffleModeEnabled)) {
                return repeatMode == 2 ? this.getFirstWindowIndex(shuffleModeEnabled) : -1;
            }
            return shuffleModeEnabled ? this.shuffledWindowIndices[this.windowIndicesInShuffled[windowIndex] + 1] : windowIndex + 1;
        }

        @Override
        public int getPreviousWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
            if (repeatMode == 1) {
                return windowIndex;
            }
            if (windowIndex == this.getFirstWindowIndex(shuffleModeEnabled)) {
                return repeatMode == 2 ? this.getLastWindowIndex(shuffleModeEnabled) : -1;
            }
            return shuffleModeEnabled ? this.shuffledWindowIndices[this.windowIndicesInShuffled[windowIndex] - 1] : windowIndex - 1;
        }

        @Override
        public int getLastWindowIndex(boolean shuffleModeEnabled) {
            if (this.isEmpty()) {
                return -1;
            }
            return shuffleModeEnabled ? this.shuffledWindowIndices[this.getWindowCount() - 1] : this.getWindowCount() - 1;
        }

        @Override
        public int getFirstWindowIndex(boolean shuffleModeEnabled) {
            if (this.isEmpty()) {
                return -1;
            }
            return shuffleModeEnabled ? this.shuffledWindowIndices[0] : 0;
        }

        @Override
        public int getPeriodCount() {
            return this.periods.size();
        }

        @Override
        public Period getPeriod(int periodIndex, Period period, boolean ignoredSetIds) {
            Period p = (Period)this.periods.get(periodIndex);
            period.set(p.id, p.uid, p.windowIndex, p.durationUs, p.positionInWindowUs, p.adPlaybackState, p.isPlaceholder);
            return period;
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Period
    implements Bundleable {
        @Nullable
        public Object id;
        @Nullable
        public Object uid;
        public int windowIndex;
        public long durationUs;
        public long positionInWindowUs;
        public boolean isPlaceholder;
        private AdPlaybackState adPlaybackState = AdPlaybackState.NONE;
        private static final int FIELD_WINDOW_INDEX = 0;
        private static final int FIELD_DURATION_US = 1;
        private static final int FIELD_POSITION_IN_WINDOW_US = 2;
        private static final int FIELD_PLACEHOLDER = 3;
        private static final int FIELD_AD_PLAYBACK_STATE = 4;
        public static final Bundleable.Creator<Period> CREATOR = Period::fromBundle;

        public Period set(@Nullable Object id, @Nullable Object uid, int windowIndex, long durationUs, long positionInWindowUs) {
            return this.set(id, uid, windowIndex, durationUs, positionInWindowUs, AdPlaybackState.NONE, false);
        }

        public Period set(@Nullable Object id, @Nullable Object uid, int windowIndex, long durationUs, long positionInWindowUs, AdPlaybackState adPlaybackState, boolean isPlaceholder) {
            this.id = id;
            this.uid = uid;
            this.windowIndex = windowIndex;
            this.durationUs = durationUs;
            this.positionInWindowUs = positionInWindowUs;
            this.adPlaybackState = adPlaybackState;
            this.isPlaceholder = isPlaceholder;
            return this;
        }

        public long getDurationMs() {
            return C.usToMs(this.durationUs);
        }

        public long getDurationUs() {
            return this.durationUs;
        }

        public long getPositionInWindowMs() {
            return C.usToMs(this.positionInWindowUs);
        }

        public long getPositionInWindowUs() {
            return this.positionInWindowUs;
        }

        @Nullable
        public Object getAdsId() {
            return this.adPlaybackState.adsId;
        }

        public int getAdGroupCount() {
            return this.adPlaybackState.adGroupCount;
        }

        public long getAdGroupTimeUs(int adGroupIndex) {
            return this.adPlaybackState.adGroupTimesUs[adGroupIndex];
        }

        public int getFirstAdIndexToPlay(int adGroupIndex) {
            return this.adPlaybackState.adGroups[adGroupIndex].getFirstAdIndexToPlay();
        }

        public int getNextAdIndexToPlay(int adGroupIndex, int lastPlayedAdIndex) {
            return this.adPlaybackState.adGroups[adGroupIndex].getNextAdIndexToPlay(lastPlayedAdIndex);
        }

        public boolean hasPlayedAdGroup(int adGroupIndex) {
            return !this.adPlaybackState.adGroups[adGroupIndex].hasUnplayedAds();
        }

        public int getAdGroupIndexForPositionUs(long positionUs) {
            return this.adPlaybackState.getAdGroupIndexForPositionUs(positionUs, this.durationUs);
        }

        public int getAdGroupIndexAfterPositionUs(long positionUs) {
            return this.adPlaybackState.getAdGroupIndexAfterPositionUs(positionUs, this.durationUs);
        }

        public int getAdCountInAdGroup(int adGroupIndex) {
            return this.adPlaybackState.adGroups[adGroupIndex].count;
        }

        public long getAdDurationUs(int adGroupIndex, int adIndexInAdGroup) {
            AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
            return adGroup.count != -1 ? adGroup.durationsUs[adIndexInAdGroup] : -9223372036854775807L;
        }

        public long getAdResumePositionUs() {
            return this.adPlaybackState.adResumePositionUs;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Period that = (Period)obj;
            return Util.areEqual(this.id, that.id) && Util.areEqual(this.uid, that.uid) && this.windowIndex == that.windowIndex && this.durationUs == that.durationUs && this.positionInWindowUs == that.positionInWindowUs && this.isPlaceholder == that.isPlaceholder && Util.areEqual(this.adPlaybackState, that.adPlaybackState);
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            result = 31 * result + this.windowIndex;
            result = 31 * result + (int)(this.durationUs ^ this.durationUs >>> 32);
            result = 31 * result + (int)(this.positionInWindowUs ^ this.positionInWindowUs >>> 32);
            result = 31 * result + (this.isPlaceholder ? 1 : 0);
            result = 31 * result + this.adPlaybackState.hashCode();
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(Period.keyForField(0), this.windowIndex);
            bundle.putLong(Period.keyForField(1), this.durationUs);
            bundle.putLong(Period.keyForField(2), this.positionInWindowUs);
            bundle.putBoolean(Period.keyForField(3), this.isPlaceholder);
            bundle.putBundle(Period.keyForField(4), this.adPlaybackState.toBundle());
            return bundle;
        }

        private static Period fromBundle(Bundle bundle) {
            int windowIndex = bundle.getInt(Period.keyForField(0), 0);
            long durationUs = bundle.getLong(Period.keyForField(1), -9223372036854775807L);
            long positionInWindowUs = bundle.getLong(Period.keyForField(2), 0L);
            boolean isPlaceholder = bundle.getBoolean(Period.keyForField(3));
            Bundle adPlaybackStateBundle = bundle.getBundle(Period.keyForField(4));
            AdPlaybackState adPlaybackState = adPlaybackStateBundle != null ? AdPlaybackState.CREATOR.fromBundle(adPlaybackStateBundle) : AdPlaybackState.NONE;
            Period period = new Period();
            period.set(null, null, windowIndex, durationUs, positionInWindowUs, adPlaybackState, isPlaceholder);
            return period;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }

    public static final class Window
    implements Bundleable {
        public static final Object SINGLE_WINDOW_UID = new Object();
        private static final Object FAKE_WINDOW_UID = new Object();
        private static final MediaItem EMPTY_MEDIA_ITEM = new MediaItem.Builder().setMediaId("com.google.android.exoplayer2.Timeline").setUri(Uri.EMPTY).build();
        public Object uid = SINGLE_WINDOW_UID;
        @Deprecated
        @Nullable
        public Object tag;
        public MediaItem mediaItem = EMPTY_MEDIA_ITEM;
        @Nullable
        public Object manifest;
        public long presentationStartTimeMs;
        public long windowStartTimeMs;
        public long elapsedRealtimeEpochOffsetMs;
        public boolean isSeekable;
        public boolean isDynamic;
        @Deprecated
        public boolean isLive;
        @Nullable
        public MediaItem.LiveConfiguration liveConfiguration;
        public boolean isPlaceholder;
        public long defaultPositionUs;
        public long durationUs;
        public int firstPeriodIndex;
        public int lastPeriodIndex;
        public long positionInFirstPeriodUs;
        private static final int FIELD_MEDIA_ITEM = 1;
        private static final int FIELD_PRESENTATION_START_TIME_MS = 2;
        private static final int FIELD_WINDOW_START_TIME_MS = 3;
        private static final int FIELD_ELAPSED_REALTIME_EPOCH_OFFSET_MS = 4;
        private static final int FIELD_IS_SEEKABLE = 5;
        private static final int FIELD_IS_DYNAMIC = 6;
        private static final int FIELD_LIVE_CONFIGURATION = 7;
        private static final int FIELD_IS_PLACEHOLDER = 8;
        private static final int FIELD_DEFAULT_POSITION_US = 9;
        private static final int FIELD_DURATION_US = 10;
        private static final int FIELD_FIRST_PERIOD_INDEX = 11;
        private static final int FIELD_LAST_PERIOD_INDEX = 12;
        private static final int FIELD_POSITION_IN_FIRST_PERIOD_US = 13;
        public static final Bundleable.Creator<Window> CREATOR = Window::fromBundle;

        public Window set(Object uid, @Nullable MediaItem mediaItem, @Nullable Object manifest, long presentationStartTimeMs, long windowStartTimeMs, long elapsedRealtimeEpochOffsetMs, boolean isSeekable, boolean isDynamic, @Nullable MediaItem.LiveConfiguration liveConfiguration, long defaultPositionUs, long durationUs, int firstPeriodIndex, int lastPeriodIndex, long positionInFirstPeriodUs) {
            this.uid = uid;
            this.mediaItem = mediaItem != null ? mediaItem : EMPTY_MEDIA_ITEM;
            this.tag = mediaItem != null && mediaItem.playbackProperties != null ? mediaItem.playbackProperties.tag : null;
            this.manifest = manifest;
            this.presentationStartTimeMs = presentationStartTimeMs;
            this.windowStartTimeMs = windowStartTimeMs;
            this.elapsedRealtimeEpochOffsetMs = elapsedRealtimeEpochOffsetMs;
            this.isSeekable = isSeekable;
            this.isDynamic = isDynamic;
            this.isLive = liveConfiguration != null;
            this.liveConfiguration = liveConfiguration;
            this.defaultPositionUs = defaultPositionUs;
            this.durationUs = durationUs;
            this.firstPeriodIndex = firstPeriodIndex;
            this.lastPeriodIndex = lastPeriodIndex;
            this.positionInFirstPeriodUs = positionInFirstPeriodUs;
            this.isPlaceholder = false;
            return this;
        }

        public long getDefaultPositionMs() {
            return C.usToMs(this.defaultPositionUs);
        }

        public long getDefaultPositionUs() {
            return this.defaultPositionUs;
        }

        public long getDurationMs() {
            return C.usToMs(this.durationUs);
        }

        public long getDurationUs() {
            return this.durationUs;
        }

        public long getPositionInFirstPeriodMs() {
            return C.usToMs(this.positionInFirstPeriodUs);
        }

        public long getPositionInFirstPeriodUs() {
            return this.positionInFirstPeriodUs;
        }

        public long getCurrentUnixTimeMs() {
            return Util.getNowUnixTimeMs(this.elapsedRealtimeEpochOffsetMs);
        }

        public boolean isLive() {
            Assertions.checkState(this.isLive == (this.liveConfiguration != null));
            return this.liveConfiguration != null;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Window that = (Window)obj;
            return Util.areEqual(this.uid, that.uid) && Util.areEqual(this.mediaItem, that.mediaItem) && Util.areEqual(this.manifest, that.manifest) && Util.areEqual(this.liveConfiguration, that.liveConfiguration) && this.presentationStartTimeMs == that.presentationStartTimeMs && this.windowStartTimeMs == that.windowStartTimeMs && this.elapsedRealtimeEpochOffsetMs == that.elapsedRealtimeEpochOffsetMs && this.isSeekable == that.isSeekable && this.isDynamic == that.isDynamic && this.isPlaceholder == that.isPlaceholder && this.defaultPositionUs == that.defaultPositionUs && this.durationUs == that.durationUs && this.firstPeriodIndex == that.firstPeriodIndex && this.lastPeriodIndex == that.lastPeriodIndex && this.positionInFirstPeriodUs == that.positionInFirstPeriodUs;
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + this.uid.hashCode();
            result = 31 * result + this.mediaItem.hashCode();
            result = 31 * result + (this.manifest == null ? 0 : this.manifest.hashCode());
            result = 31 * result + (this.liveConfiguration == null ? 0 : this.liveConfiguration.hashCode());
            result = 31 * result + (int)(this.presentationStartTimeMs ^ this.presentationStartTimeMs >>> 32);
            result = 31 * result + (int)(this.windowStartTimeMs ^ this.windowStartTimeMs >>> 32);
            result = 31 * result + (int)(this.elapsedRealtimeEpochOffsetMs ^ this.elapsedRealtimeEpochOffsetMs >>> 32);
            result = 31 * result + (this.isSeekable ? 1 : 0);
            result = 31 * result + (this.isDynamic ? 1 : 0);
            result = 31 * result + (this.isPlaceholder ? 1 : 0);
            result = 31 * result + (int)(this.defaultPositionUs ^ this.defaultPositionUs >>> 32);
            result = 31 * result + (int)(this.durationUs ^ this.durationUs >>> 32);
            result = 31 * result + this.firstPeriodIndex;
            result = 31 * result + this.lastPeriodIndex;
            result = 31 * result + (int)(this.positionInFirstPeriodUs ^ this.positionInFirstPeriodUs >>> 32);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putBundle(Window.keyForField(1), this.mediaItem.toBundle());
            bundle.putLong(Window.keyForField(2), this.presentationStartTimeMs);
            bundle.putLong(Window.keyForField(3), this.windowStartTimeMs);
            bundle.putLong(Window.keyForField(4), this.elapsedRealtimeEpochOffsetMs);
            bundle.putBoolean(Window.keyForField(5), this.isSeekable);
            bundle.putBoolean(Window.keyForField(6), this.isDynamic);
            MediaItem.LiveConfiguration liveConfiguration = this.liveConfiguration;
            if (liveConfiguration != null) {
                bundle.putBundle(Window.keyForField(7), liveConfiguration.toBundle());
            }
            bundle.putBoolean(Window.keyForField(8), this.isPlaceholder);
            bundle.putLong(Window.keyForField(9), this.defaultPositionUs);
            bundle.putLong(Window.keyForField(10), this.durationUs);
            bundle.putInt(Window.keyForField(11), this.firstPeriodIndex);
            bundle.putInt(Window.keyForField(12), this.lastPeriodIndex);
            bundle.putLong(Window.keyForField(13), this.positionInFirstPeriodUs);
            return bundle;
        }

        private static Window fromBundle(Bundle bundle) {
            Bundle mediaItemBundle = bundle.getBundle(Window.keyForField(1));
            MediaItem mediaItem = mediaItemBundle != null ? MediaItem.CREATOR.fromBundle(mediaItemBundle) : null;
            long presentationStartTimeMs = bundle.getLong(Window.keyForField(2), -9223372036854775807L);
            long windowStartTimeMs = bundle.getLong(Window.keyForField(3), -9223372036854775807L);
            long elapsedRealtimeEpochOffsetMs = bundle.getLong(Window.keyForField(4), -9223372036854775807L);
            boolean isSeekable = bundle.getBoolean(Window.keyForField(5), false);
            boolean isDynamic = bundle.getBoolean(Window.keyForField(6), false);
            Bundle liveConfigurationBundle = bundle.getBundle(Window.keyForField(7));
            MediaItem.LiveConfiguration liveConfiguration = liveConfigurationBundle != null ? MediaItem.LiveConfiguration.CREATOR.fromBundle(liveConfigurationBundle) : null;
            boolean isPlaceHolder = bundle.getBoolean(Window.keyForField(8), false);
            long defaultPositionUs = bundle.getLong(Window.keyForField(9), 0L);
            long durationUs = bundle.getLong(Window.keyForField(10), -9223372036854775807L);
            int firstPeriodIndex = bundle.getInt(Window.keyForField(11), 0);
            int lastPeriodIndex = bundle.getInt(Window.keyForField(12), 0);
            long positionInFirstPeriodUs = bundle.getLong(Window.keyForField(13), 0L);
            Window window = new Window();
            window.set(FAKE_WINDOW_UID, mediaItem, null, presentationStartTimeMs, windowStartTimeMs, elapsedRealtimeEpochOffsetMs, isSeekable, isDynamic, liveConfiguration, defaultPositionUs, durationUs, firstPeriodIndex, lastPeriodIndex, positionInFirstPeriodUs);
            window.isPlaceholder = isPlaceHolder;
            return window;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }
}

