/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AacUtil {
    private static final String TAG = "AacUtil";
    public static final int AAC_LC_AUDIO_SAMPLE_COUNT = 1024;
    public static final int AAC_XHE_AUDIO_SAMPLE_COUNT = 1024;
    public static final int AAC_HE_AUDIO_SAMPLE_COUNT = 2048;
    public static final int AAC_LD_AUDIO_SAMPLE_COUNT = 512;
    public static final int AAC_LC_MAX_RATE_BYTES_PER_SECOND = 100000;
    public static final int AAC_HE_V1_MAX_RATE_BYTES_PER_SECOND = 16000;
    public static final int AAC_HE_V2_MAX_RATE_BYTES_PER_SECOND = 7000;
    public static final int AAC_XHE_MAX_RATE_BYTES_PER_SECOND = 256000;
    public static final int AAC_ELD_MAX_RATE_BYTES_PER_SECOND = 8000;
    private static final int AUDIO_SPECIFIC_CONFIG_FREQUENCY_INDEX_ARBITRARY = 15;
    private static final int[] AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    private static final int AUDIO_SPECIFIC_CONFIG_CHANNEL_CONFIGURATION_INVALID = -1;
    private static final int[] AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 8, -1, -1, -1, 7, 8, -1, 8, -1};
    private static final String CODECS_STRING_PREFIX = "mp4a.40.";
    public static final int AUDIO_OBJECT_TYPE_AAC_LC = 2;
    public static final int AUDIO_OBJECT_TYPE_AAC_SBR = 5;
    public static final int AUDIO_OBJECT_TYPE_AAC_ER_BSAC = 22;
    public static final int AUDIO_OBJECT_TYPE_AAC_ELD = 23;
    public static final int AUDIO_OBJECT_TYPE_AAC_PS = 29;
    private static final int AUDIO_OBJECT_TYPE_ESCAPE = 31;
    public static final int AUDIO_OBJECT_TYPE_AAC_XHE = 42;

    public static Config parseAudioSpecificConfig(byte[] audioSpecificConfig) throws ParserException {
        return AacUtil.parseAudioSpecificConfig(new ParsableBitArray(audioSpecificConfig), false);
    }

    public static Config parseAudioSpecificConfig(ParsableBitArray bitArray, boolean forceReadToEnd) throws ParserException {
        int channelCount;
        int audioObjectType = AacUtil.getAudioObjectType(bitArray);
        int sampleRateHz = AacUtil.getSamplingFrequency(bitArray);
        int channelConfiguration = bitArray.readBits(4);
        int n = audioObjectType;
        String codecs = new StringBuilder(19).append(CODECS_STRING_PREFIX).append(n).toString();
        if (audioObjectType == 5 || audioObjectType == 29) {
            sampleRateHz = AacUtil.getSamplingFrequency(bitArray);
            audioObjectType = AacUtil.getAudioObjectType(bitArray);
            if (audioObjectType == 22) {
                channelConfiguration = bitArray.readBits(4);
            }
        }
        if (forceReadToEnd) {
            switch (audioObjectType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    AacUtil.parseGaSpecificConfig(bitArray, audioObjectType, channelConfiguration);
                    break;
                }
                default: {
                    n = audioObjectType;
                    throw new ParserException(new StringBuilder(42).append("Unsupported audio object type: ").append(n).toString());
                }
            }
            switch (audioObjectType) {
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    int epConfig = bitArray.readBits(2);
                    if (epConfig != 2 && epConfig != 3) break;
                    throw new ParserException(new StringBuilder(33).append("Unsupported epConfig: ").append(epConfig).toString());
                }
            }
        }
        if ((channelCount = AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[channelConfiguration]) == -1) {
            throw new ParserException();
        }
        return new Config(sampleRateHz, channelCount, codecs);
    }

    public static byte[] buildAacLcAudioSpecificConfig(int sampleRate, int channelCount) {
        int sampleRateIndex = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE.length; ++i) {
            if (sampleRate != AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[i]) continue;
            sampleRateIndex = i;
        }
        int channelConfig = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE.length; ++i) {
            if (channelCount != AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[i]) continue;
            channelConfig = i;
        }
        if (sampleRate == -1 || channelConfig == -1) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Invalid sample rate or number of channels: ").append(sampleRate).append(", ").append(channelCount).toString());
        }
        return AacUtil.buildAudioSpecificConfig(2, sampleRateIndex, channelConfig);
    }

    public static byte[] buildAudioSpecificConfig(int audioObjectType, int sampleRateIndex, int channelConfig) {
        byte[] specificConfig = new byte[]{(byte)(audioObjectType << 3 & 0xF8 | sampleRateIndex >> 1 & 7), (byte)(sampleRateIndex << 7 & 0x80 | channelConfig << 3 & 0x78)};
        return specificConfig;
    }

    public static int getEncodingForAudioObjectType(int audioObjectType) {
        switch (audioObjectType) {
            case 2: {
                return 10;
            }
            case 5: {
                return 11;
            }
            case 29: {
                return 12;
            }
            case 42: {
                return 16;
            }
            case 23: {
                return 15;
            }
            case 22: {
                return 0x40000000;
            }
        }
        return 0;
    }

    private static int getAudioObjectType(ParsableBitArray bitArray) {
        int audioObjectType = bitArray.readBits(5);
        if (audioObjectType == 31) {
            audioObjectType = 32 + bitArray.readBits(6);
        }
        return audioObjectType;
    }

    private static int getSamplingFrequency(ParsableBitArray bitArray) throws ParserException {
        int samplingFrequency;
        int frequencyIndex = bitArray.readBits(4);
        if (frequencyIndex == 15) {
            samplingFrequency = bitArray.readBits(24);
        } else if (frequencyIndex < 13) {
            samplingFrequency = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[frequencyIndex];
        } else {
            throw new ParserException();
        }
        return samplingFrequency;
    }

    private static void parseGaSpecificConfig(ParsableBitArray bitArray, int audioObjectType, int channelConfiguration) {
        boolean dependsOnCoreDecoder;
        boolean frameLengthFlag = bitArray.readBit();
        if (frameLengthFlag) {
            Log.w(TAG, "Unexpected frameLengthFlag = 1");
        }
        if (dependsOnCoreDecoder = bitArray.readBit()) {
            bitArray.skipBits(14);
        }
        boolean extensionFlag = bitArray.readBit();
        if (channelConfiguration == 0) {
            throw new UnsupportedOperationException();
        }
        if (audioObjectType == 6 || audioObjectType == 20) {
            bitArray.skipBits(3);
        }
        if (extensionFlag) {
            if (audioObjectType == 22) {
                bitArray.skipBits(16);
            }
            if (audioObjectType == 17 || audioObjectType == 19 || audioObjectType == 20 || audioObjectType == 23) {
                bitArray.skipBits(3);
            }
            bitArray.skipBits(1);
        }
    }

    private AacUtil() {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AacAudioObjectType {
    }

    public static final class Config {
        public final int sampleRateHz;
        public final int channelCount;
        public final String codecs;

        private Config(int sampleRateHz, int channelCount, String codecs) {
            this.sampleRateHz = sampleRateHz;
            this.channelCount = channelCount;
            this.codecs = codecs;
        }
    }
}

