/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import java.util.Arrays;

public final class TrackGroup
implements Parcelable {
    private static final String TAG = "TrackGroup";
    public final int length;
    private final Format[] formats;
    private int hashCode;
    public static final Parcelable.Creator<TrackGroup> CREATOR = new Parcelable.Creator<TrackGroup>(){

        public TrackGroup createFromParcel(Parcel in) {
            return new TrackGroup(in);
        }

        public TrackGroup[] newArray(int size) {
            return new TrackGroup[size];
        }
    };

    public TrackGroup(Format ... formats) {
        Assertions.checkState(formats.length > 0);
        this.formats = formats;
        this.length = formats.length;
        this.verifyCorrectness();
    }

    TrackGroup(Parcel in) {
        this.length = in.readInt();
        this.formats = new Format[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.formats[i] = (Format)in.readParcelable(Format.class.getClassLoader());
        }
    }

    public Format getFormat(int index) {
        return this.formats[index];
    }

    public int indexOf(Format format) {
        for (int i = 0; i < this.formats.length; ++i) {
            if (format != this.formats[i]) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            this.hashCode = result = 31 * result + Arrays.hashCode(this.formats);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroup other = (TrackGroup)obj;
        return this.length == other.length && Arrays.equals(this.formats, other.formats);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            dest.writeParcelable((Parcelable)this.formats[i], 0);
        }
    }

    private void verifyCorrectness() {
        String language = TrackGroup.normalizeLanguage(this.formats[0].language);
        int roleFlags = TrackGroup.normalizeRoleFlags(this.formats[0].roleFlags);
        for (int i = 1; i < this.formats.length; ++i) {
            if (!language.equals(TrackGroup.normalizeLanguage(this.formats[i].language))) {
                TrackGroup.logErrorMessage("languages", this.formats[0].language, this.formats[i].language, i);
                return;
            }
            if (roleFlags == TrackGroup.normalizeRoleFlags(this.formats[i].roleFlags)) continue;
            TrackGroup.logErrorMessage("role flags", Integer.toBinaryString(this.formats[0].roleFlags), Integer.toBinaryString(this.formats[i].roleFlags), i);
            return;
        }
    }

    private static String normalizeLanguage(@Nullable String language) {
        return language == null || language.equals("und") ? "" : language;
    }

    private static int normalizeRoleFlags(int roleFlags) {
        return roleFlags | 0x4000;
    }

    private static void logErrorMessage(String mismatchField, @Nullable String valueIndex0, @Nullable String otherValue, int otherIndex) {
        Log.e(TAG, "", new IllegalStateException(new StringBuilder(78 + String.valueOf(mismatchField).length() + String.valueOf(valueIndex0).length() + String.valueOf(otherValue).length()).append("Different ").append(mismatchField).append(" combined in one TrackGroup: '").append(valueIndex0).append("' (track 0) and '").append(otherValue).append("' (track ").append(otherIndex).append(")").toString()));
    }
}

