/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.ads;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.CheckResult;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class AdPlaybackState
implements Bundleable {
    public static final int AD_STATE_UNAVAILABLE = 0;
    public static final int AD_STATE_AVAILABLE = 1;
    public static final int AD_STATE_SKIPPED = 2;
    public static final int AD_STATE_PLAYED = 3;
    public static final int AD_STATE_ERROR = 4;
    public static final AdPlaybackState NONE = new AdPlaybackState(null, new AdGroup[0], 0L, -9223372036854775807L, 0);
    private static final AdGroup REMOVED_AD_GROUP = new AdGroup(0L).withAdCount(0);
    @Nullable
    public final Object adsId;
    public final int adGroupCount;
    public final long adResumePositionUs;
    public final long contentDurationUs;
    public final int removedAdGroupCount;
    private final AdGroup[] adGroups;
    private static final int FIELD_AD_GROUPS = 1;
    private static final int FIELD_AD_RESUME_POSITION_US = 2;
    private static final int FIELD_CONTENT_DURATION_US = 3;
    private static final int FIELD_REMOVED_AD_GROUP_COUNT = 4;
    public static final Bundleable.Creator<AdPlaybackState> CREATOR = AdPlaybackState::fromBundle;

    public AdPlaybackState(Object adsId, long ... adGroupTimesUs) {
        this(adsId, AdPlaybackState.createEmptyAdGroups(adGroupTimesUs), 0L, -9223372036854775807L, 0);
    }

    private AdPlaybackState(@Nullable Object adsId, AdGroup[] adGroups, long adResumePositionUs, long contentDurationUs, int removedAdGroupCount) {
        this.adsId = adsId;
        this.adResumePositionUs = adResumePositionUs;
        this.contentDurationUs = contentDurationUs;
        this.adGroupCount = adGroups.length + removedAdGroupCount;
        this.adGroups = adGroups;
        this.removedAdGroupCount = removedAdGroupCount;
    }

    public AdGroup getAdGroup(@IntRange(from=0L) int adGroupIndex) {
        return adGroupIndex < this.removedAdGroupCount ? REMOVED_AD_GROUP : this.adGroups[adGroupIndex - this.removedAdGroupCount];
    }

    public int getAdGroupIndexForPositionUs(long positionUs, long periodDurationUs) {
        int index;
        for (index = this.adGroupCount - 1; index >= 0 && this.isPositionBeforeAdGroup(positionUs, periodDurationUs, index); --index) {
        }
        return index >= 0 && this.getAdGroup(index).hasUnplayedAds() ? index : -1;
    }

    public int getAdGroupIndexAfterPositionUs(long positionUs, long periodDurationUs) {
        int index;
        if (positionUs == Long.MIN_VALUE || periodDurationUs != -9223372036854775807L && positionUs >= periodDurationUs) {
            return -1;
        }
        for (index = this.removedAdGroupCount; index < this.adGroupCount && (this.getAdGroup((int)index).timeUs != Long.MIN_VALUE && this.getAdGroup((int)index).timeUs <= positionUs || !this.getAdGroup(index).shouldPlayAdGroup()); ++index) {
        }
        return index < this.adGroupCount ? index : -1;
    }

    public boolean isAdInErrorState(@IntRange(from=0L) int adGroupIndex, @IntRange(from=0L) int adIndexInAdGroup) {
        if (adGroupIndex >= this.adGroupCount) {
            return false;
        }
        AdGroup adGroup = this.getAdGroup(adGroupIndex);
        if (adGroup.count == -1 || adIndexInAdGroup >= adGroup.count) {
            return false;
        }
        return adGroup.states[adIndexInAdGroup] == 4;
    }

    @CheckResult
    public AdPlaybackState withAdGroupTimeUs(@IntRange(from=0L) int adGroupIndex, long adGroupTimeUs) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = this.adGroups[adjustedIndex].withTimeUs(adGroupTimeUs);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withNewAdGroup(@IntRange(from=0L) int adGroupIndex, long adGroupTimeUs) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup newAdGroup = new AdGroup(adGroupTimeUs);
        AdGroup[] adGroups = Util.nullSafeArrayAppend(this.adGroups, newAdGroup);
        System.arraycopy(adGroups, adjustedIndex, adGroups, adjustedIndex + 1, this.adGroups.length - adjustedIndex);
        adGroups[adjustedIndex] = newAdGroup;
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withAdCount(@IntRange(from=0L) int adGroupIndex, @IntRange(from=1L) int adCount) {
        Assertions.checkArgument(adCount > 0);
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        if (this.adGroups[adjustedIndex].count == adCount) {
            return this;
        }
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = this.adGroups[adjustedIndex].withAdCount(adCount);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withAdUri(@IntRange(from=0L) int adGroupIndex, @IntRange(from=0L) int adIndexInAdGroup, Uri uri) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAdUri(uri, adIndexInAdGroup);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withPlayedAd(@IntRange(from=0L) int adGroupIndex, @IntRange(from=0L) int adIndexInAdGroup) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAdState(3, adIndexInAdGroup);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withSkippedAd(@IntRange(from=0L) int adGroupIndex, @IntRange(from=0L) int adIndexInAdGroup) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAdState(2, adIndexInAdGroup);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withAdLoadError(@IntRange(from=0L) int adGroupIndex, @IntRange(from=0L) int adIndexInAdGroup) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAdState(4, adIndexInAdGroup);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withSkippedAdGroup(@IntRange(from=0L) int adGroupIndex) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAllAdsSkipped();
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withAdDurationsUs(long[][] adDurationUs) {
        Assertions.checkState(this.removedAdGroupCount == 0);
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        for (int adGroupIndex = 0; adGroupIndex < this.adGroupCount; ++adGroupIndex) {
            adGroups[adGroupIndex] = adGroups[adGroupIndex].withAdDurationsUs(adDurationUs[adGroupIndex]);
        }
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withAdDurationsUs(@IntRange(from=0L) int adGroupIndex, long ... adDurationsUs) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAdDurationsUs(adDurationsUs);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withAdResumePositionUs(long adResumePositionUs) {
        if (this.adResumePositionUs == adResumePositionUs) {
            return this;
        }
        return new AdPlaybackState(this.adsId, this.adGroups, adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withContentDurationUs(long contentDurationUs) {
        if (this.contentDurationUs == contentDurationUs) {
            return this;
        }
        return new AdPlaybackState(this.adsId, this.adGroups, this.adResumePositionUs, contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withRemovedAdGroupCount(@IntRange(from=0L) int removedAdGroupCount) {
        if (this.removedAdGroupCount == removedAdGroupCount) {
            return this;
        }
        Assertions.checkArgument(removedAdGroupCount > this.removedAdGroupCount);
        AdGroup[] adGroups = new AdGroup[this.adGroupCount - removedAdGroupCount];
        System.arraycopy(this.adGroups, removedAdGroupCount - this.removedAdGroupCount, adGroups, 0, adGroups.length);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withContentResumeOffsetUs(@IntRange(from=0L) int adGroupIndex, long contentResumeOffsetUs) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        if (this.adGroups[adjustedIndex].contentResumeOffsetUs == contentResumeOffsetUs) {
            return this;
        }
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withContentResumeOffsetUs(contentResumeOffsetUs);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withIsServerSideInserted(@IntRange(from=0L) int adGroupIndex, boolean isServerSideInserted) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        if (this.adGroups[adjustedIndex].isServerSideInserted == isServerSideInserted) {
            return this;
        }
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withIsServerSideInserted(isServerSideInserted);
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    @CheckResult
    public AdPlaybackState withResetAdGroup(@IntRange(from=0L) int adGroupIndex) {
        int adjustedIndex = adGroupIndex - this.removedAdGroupCount;
        AdGroup[] adGroups = Util.nullSafeArrayCopy(this.adGroups, this.adGroups.length);
        adGroups[adjustedIndex] = adGroups[adjustedIndex].withAllAdsReset();
        return new AdPlaybackState(this.adsId, adGroups, this.adResumePositionUs, this.contentDurationUs, this.removedAdGroupCount);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdPlaybackState that = (AdPlaybackState)o;
        return Util.areEqual(this.adsId, that.adsId) && this.adGroupCount == that.adGroupCount && this.adResumePositionUs == that.adResumePositionUs && this.contentDurationUs == that.contentDurationUs && this.removedAdGroupCount == that.removedAdGroupCount && Arrays.equals(this.adGroups, that.adGroups);
    }

    public int hashCode() {
        int result = this.adGroupCount;
        result = 31 * result + (this.adsId == null ? 0 : this.adsId.hashCode());
        result = 31 * result + (int)this.adResumePositionUs;
        result = 31 * result + (int)this.contentDurationUs;
        result = 31 * result + this.removedAdGroupCount;
        result = 31 * result + Arrays.hashCode(this.adGroups);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AdPlaybackState(adsId=");
        sb.append(this.adsId);
        sb.append(", adResumePositionUs=");
        sb.append(this.adResumePositionUs);
        sb.append(", adGroups=[");
        for (int i = 0; i < this.adGroups.length; ++i) {
            sb.append("adGroup(timeUs=");
            sb.append(this.adGroups[i].timeUs);
            sb.append(", ads=[");
            for (int j = 0; j < this.adGroups[i].states.length; ++j) {
                sb.append("ad(state=");
                switch (this.adGroups[i].states[j]) {
                    case 0: {
                        sb.append('_');
                        break;
                    }
                    case 4: {
                        sb.append('!');
                        break;
                    }
                    case 1: {
                        sb.append('R');
                        break;
                    }
                    case 3: {
                        sb.append('P');
                        break;
                    }
                    case 2: {
                        sb.append('S');
                        break;
                    }
                    default: {
                        sb.append('?');
                    }
                }
                sb.append(", durationUs=");
                sb.append(this.adGroups[i].durationsUs[j]);
                sb.append(')');
                if (j >= this.adGroups[i].states.length - 1) continue;
                sb.append(", ");
            }
            sb.append("])");
            if (i >= this.adGroups.length - 1) continue;
            sb.append(", ");
        }
        sb.append("])");
        return sb.toString();
    }

    private boolean isPositionBeforeAdGroup(long positionUs, long periodDurationUs, int adGroupIndex) {
        if (positionUs == Long.MIN_VALUE) {
            return false;
        }
        long adGroupPositionUs = this.getAdGroup((int)adGroupIndex).timeUs;
        if (adGroupPositionUs == Long.MIN_VALUE) {
            return periodDurationUs == -9223372036854775807L || positionUs < periodDurationUs;
        }
        return positionUs < adGroupPositionUs;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        ArrayList<Bundle> adGroupBundleList = new ArrayList<Bundle>();
        for (AdGroup adGroup : this.adGroups) {
            adGroupBundleList.add(adGroup.toBundle());
        }
        bundle.putParcelableArrayList(AdPlaybackState.keyForField(1), adGroupBundleList);
        bundle.putLong(AdPlaybackState.keyForField(2), this.adResumePositionUs);
        bundle.putLong(AdPlaybackState.keyForField(3), this.contentDurationUs);
        bundle.putInt(AdPlaybackState.keyForField(4), this.removedAdGroupCount);
        return bundle;
    }

    private static AdPlaybackState fromBundle(Bundle bundle) {
        AdGroup[] adGroups;
        ArrayList adGroupBundleList = bundle.getParcelableArrayList(AdPlaybackState.keyForField(1));
        if (adGroupBundleList == null) {
            adGroups = new AdGroup[]{};
        } else {
            adGroups = new AdGroup[adGroupBundleList.size()];
            for (int i = 0; i < adGroupBundleList.size(); ++i) {
                adGroups[i] = AdGroup.CREATOR.fromBundle((Bundle)adGroupBundleList.get(i));
            }
        }
        long adResumePositionUs = bundle.getLong(AdPlaybackState.keyForField(2), 0L);
        long contentDurationUs = bundle.getLong(AdPlaybackState.keyForField(3), -9223372036854775807L);
        int removedAdGroupCount = bundle.getInt(AdPlaybackState.keyForField(4));
        return new AdPlaybackState(null, adGroups, adResumePositionUs, contentDurationUs, removedAdGroupCount);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    private static AdGroup[] createEmptyAdGroups(long[] adGroupTimesUs) {
        AdGroup[] adGroups = new AdGroup[adGroupTimesUs.length];
        for (int i = 0; i < adGroups.length; ++i) {
            adGroups[i] = new AdGroup(adGroupTimesUs[i]);
        }
        return adGroups;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface AdState {
    }

    public static final class AdGroup
    implements Bundleable {
        public final long timeUs;
        public final int count;
        public final @NullableType Uri[] uris;
        public final int[] states;
        public final long[] durationsUs;
        public final long contentResumeOffsetUs;
        public final boolean isServerSideInserted;
        private static final int FIELD_TIME_US = 0;
        private static final int FIELD_COUNT = 1;
        private static final int FIELD_URIS = 2;
        private static final int FIELD_STATES = 3;
        private static final int FIELD_DURATIONS_US = 4;
        private static final int FIELD_CONTENT_RESUME_OFFSET_US = 5;
        private static final int FIELD_IS_SERVER_SIDE_INSERTED = 6;
        public static final Bundleable.Creator<AdGroup> CREATOR = AdGroup::fromBundle;

        public AdGroup(long timeUs) {
            this(timeUs, -1, new int[0], new Uri[0], new long[0], 0L, false);
        }

        private AdGroup(long timeUs, int count, int[] states, @NullableType Uri[] uris, long[] durationsUs, long contentResumeOffsetUs, boolean isServerSideInserted) {
            Assertions.checkArgument(states.length == uris.length);
            this.timeUs = timeUs;
            this.count = count;
            this.states = states;
            this.uris = uris;
            this.durationsUs = durationsUs;
            this.contentResumeOffsetUs = contentResumeOffsetUs;
            this.isServerSideInserted = isServerSideInserted;
        }

        public int getFirstAdIndexToPlay() {
            return this.getNextAdIndexToPlay(-1);
        }

        public int getNextAdIndexToPlay(@IntRange(from=-1L) int lastPlayedAdIndex) {
            int nextAdIndexToPlay;
            for (nextAdIndexToPlay = lastPlayedAdIndex + 1; nextAdIndexToPlay < this.states.length && !this.isServerSideInserted && this.states[nextAdIndexToPlay] != 0 && this.states[nextAdIndexToPlay] != 1; ++nextAdIndexToPlay) {
            }
            return nextAdIndexToPlay;
        }

        public boolean shouldPlayAdGroup() {
            return this.count == -1 || this.getFirstAdIndexToPlay() < this.count;
        }

        public boolean hasUnplayedAds() {
            if (this.count == -1) {
                return true;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.states[i] != 0 && this.states[i] != 1) continue;
                return true;
            }
            return false;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdGroup adGroup = (AdGroup)o;
            return this.timeUs == adGroup.timeUs && this.count == adGroup.count && Arrays.equals(this.uris, adGroup.uris) && Arrays.equals(this.states, adGroup.states) && Arrays.equals(this.durationsUs, adGroup.durationsUs) && this.contentResumeOffsetUs == adGroup.contentResumeOffsetUs && this.isServerSideInserted == adGroup.isServerSideInserted;
        }

        public int hashCode() {
            int result = this.count;
            result = 31 * result + (int)(this.timeUs ^ this.timeUs >>> 32);
            result = 31 * result + Arrays.hashCode(this.uris);
            result = 31 * result + Arrays.hashCode(this.states);
            result = 31 * result + Arrays.hashCode(this.durationsUs);
            result = 31 * result + (int)(this.contentResumeOffsetUs ^ this.contentResumeOffsetUs >>> 32);
            result = 31 * result + (this.isServerSideInserted ? 1 : 0);
            return result;
        }

        @CheckResult
        public AdGroup withTimeUs(long timeUs) {
            return new AdGroup(timeUs, this.count, this.states, this.uris, this.durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withAdCount(int count) {
            int[] states = AdGroup.copyStatesWithSpaceForAdCount(this.states, count);
            long[] durationsUs = AdGroup.copyDurationsUsWithSpaceForAdCount(this.durationsUs, count);
            @NullableType Uri[] uris = Arrays.copyOf(this.uris, count);
            return new AdGroup(this.timeUs, count, states, uris, durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withAdUri(Uri uri, @IntRange(from=0L) int index) {
            int[] states = AdGroup.copyStatesWithSpaceForAdCount(this.states, index + 1);
            long[] durationsUs = this.durationsUs.length == states.length ? this.durationsUs : AdGroup.copyDurationsUsWithSpaceForAdCount(this.durationsUs, states.length);
            @NullableType Uri[] uris = Arrays.copyOf(this.uris, states.length);
            uris[index] = uri;
            states[index] = 1;
            return new AdGroup(this.timeUs, this.count, states, uris, durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withAdState(int state, @IntRange(from=0L) int index) {
            Assertions.checkArgument(this.count == -1 || index < this.count);
            int[] states = AdGroup.copyStatesWithSpaceForAdCount(this.states, index + 1);
            Assertions.checkArgument(states[index] == 0 || states[index] == 1 || states[index] == state);
            long[] durationsUs = this.durationsUs.length == states.length ? this.durationsUs : AdGroup.copyDurationsUsWithSpaceForAdCount(this.durationsUs, states.length);
            @NullableType Uri[] uris = this.uris.length == states.length ? this.uris : Arrays.copyOf(this.uris, states.length);
            states[index] = state;
            return new AdGroup(this.timeUs, this.count, states, uris, durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withAdDurationsUs(long[] durationsUs) {
            if (durationsUs.length < this.uris.length) {
                durationsUs = AdGroup.copyDurationsUsWithSpaceForAdCount(durationsUs, this.uris.length);
            } else if (this.count != -1 && durationsUs.length > this.uris.length) {
                durationsUs = Arrays.copyOf(durationsUs, this.uris.length);
            }
            return new AdGroup(this.timeUs, this.count, this.states, this.uris, durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withContentResumeOffsetUs(long contentResumeOffsetUs) {
            return new AdGroup(this.timeUs, this.count, this.states, this.uris, this.durationsUs, contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withIsServerSideInserted(boolean isServerSideInserted) {
            return new AdGroup(this.timeUs, this.count, this.states, this.uris, this.durationsUs, this.contentResumeOffsetUs, isServerSideInserted);
        }

        @CheckResult
        public AdGroup withAllAdsSkipped() {
            if (this.count == -1) {
                return new AdGroup(this.timeUs, 0, new int[0], new Uri[0], new long[0], this.contentResumeOffsetUs, this.isServerSideInserted);
            }
            int count = this.states.length;
            int[] states = Arrays.copyOf(this.states, count);
            for (int i = 0; i < count; ++i) {
                if (states[i] != 1 && states[i] != 0) continue;
                states[i] = 2;
            }
            return new AdGroup(this.timeUs, count, states, this.uris, this.durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        public AdGroup withAllAdsReset() {
            if (this.count == -1) {
                return this;
            }
            int count = this.states.length;
            int[] states = Arrays.copyOf(this.states, count);
            for (int i = 0; i < count; ++i) {
                if (states[i] != 3 && states[i] != 2 && states[i] != 4) continue;
                states[i] = this.uris[i] == null ? 0 : 1;
            }
            return new AdGroup(this.timeUs, count, states, this.uris, this.durationsUs, this.contentResumeOffsetUs, this.isServerSideInserted);
        }

        @CheckResult
        private static int[] copyStatesWithSpaceForAdCount(int[] states, int count) {
            int oldStateCount = states.length;
            int newStateCount = Math.max(count, oldStateCount);
            states = Arrays.copyOf(states, newStateCount);
            Arrays.fill(states, oldStateCount, newStateCount, 0);
            return states;
        }

        @CheckResult
        private static long[] copyDurationsUsWithSpaceForAdCount(long[] durationsUs, int count) {
            int oldDurationsUsCount = durationsUs.length;
            int newDurationsUsCount = Math.max(count, oldDurationsUsCount);
            durationsUs = Arrays.copyOf(durationsUs, newDurationsUsCount);
            Arrays.fill(durationsUs, oldDurationsUsCount, newDurationsUsCount, -9223372036854775807L);
            return durationsUs;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putLong(AdGroup.keyForField(0), this.timeUs);
            bundle.putInt(AdGroup.keyForField(1), this.count);
            bundle.putParcelableArrayList(AdGroup.keyForField(2), new ArrayList<Uri>(Arrays.asList(this.uris)));
            bundle.putIntArray(AdGroup.keyForField(3), this.states);
            bundle.putLongArray(AdGroup.keyForField(4), this.durationsUs);
            bundle.putLong(AdGroup.keyForField(5), this.contentResumeOffsetUs);
            bundle.putBoolean(AdGroup.keyForField(6), this.isServerSideInserted);
            return bundle;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static AdGroup fromBundle(Bundle bundle) {
            long timeUs = bundle.getLong(AdGroup.keyForField(0));
            int count = bundle.getInt(AdGroup.keyForField(1), -1);
            @NullableType ArrayList uriList = bundle.getParcelableArrayList(AdGroup.keyForField(2));
            int[] states = bundle.getIntArray(AdGroup.keyForField(3));
            long[] durationsUs = bundle.getLongArray(AdGroup.keyForField(4));
            long contentResumeOffsetUs = bundle.getLong(AdGroup.keyForField(5));
            boolean isServerSideInserted = bundle.getBoolean(AdGroup.keyForField(6));
            return new AdGroup(timeUs, count, states == null ? new int[]{} : states, uriList == null ? new Uri[]{} : uriList.toArray(new Uri[0]), durationsUs == null ? new long[]{} : durationsUs, contentResumeOffsetUs, isServerSideInserted);
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }
}

