/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLU;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.List;

public final class GlUtil {
    public static boolean glAssertionsEnabled = false;
    public static final int HOMOGENEOUS_COORDINATE_VECTOR_SIZE = 4;
    public static final float LENGTH_NDC = 2.0f;
    private static final String TAG = "GlUtil";
    private static final String EXTENSION_PROTECTED_CONTENT = "EGL_EXT_protected_content";
    private static final String EXTENSION_SURFACELESS_CONTEXT = "EGL_KHR_surfaceless_context";
    private static final int EGL_GL_COLORSPACE_KHR = 12445;
    private static final int EGL_GL_COLORSPACE_BT2020_PQ_EXT = 13120;
    private static final int[] EGL_WINDOW_SURFACE_ATTRIBUTES_NONE = new int[]{12344};
    private static final int[] EGL_WINDOW_SURFACE_ATTRIBUTES_BT2020_PQ = new int[]{12445, 13120, 12344};
    private static final int[] EGL_CONFIG_ATTRIBUTES_RGBA_8888 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
    private static final int[] EGL_CONFIG_ATTRIBUTES_RGBA_1010102 = new int[]{12352, 4, 12324, 10, 12323, 10, 12322, 10, 12321, 2, 12325, 0, 12326, 0, 12344};

    private GlUtil() {
    }

    public static float[] getNormalizedCoordinateBounds() {
        return new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] getTextureCoordinateBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] createVertexBuffer(List<float[]> vertexList) {
        float[] vertexBuffer = new float[4 * vertexList.size()];
        for (int i = 0; i < vertexList.size(); ++i) {
            System.arraycopy(vertexList.get(i), 0, vertexBuffer, 4 * i, 4);
        }
        return vertexBuffer;
    }

    public static boolean isProtectedContentExtensionSupported(Context context) {
        if (Util.SDK_INT < 24) {
            return false;
        }
        if (Util.SDK_INT < 26 && ("samsung".equals(Util.MANUFACTURER) || "XT1650".equals(Util.MODEL))) {
            return false;
        }
        if (Util.SDK_INT < 26 && !context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance")) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_PROTECTED_CONTENT);
    }

    public static boolean isSurfacelessContextExtensionSupported() {
        if (Util.SDK_INT < 17) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_SURFACELESS_CONTEXT);
    }

    @RequiresApi(value=17)
    public static EGLDisplay createEglDisplay() {
        return Api17.createEglDisplay();
    }

    @RequiresApi(value=17)
    public static EGLContext createEglContext(EGLDisplay eglDisplay) {
        return Api17.createEglContext(eglDisplay, 2, EGL_CONFIG_ATTRIBUTES_RGBA_8888);
    }

    @RequiresApi(value=17)
    public static EGLContext createEglContextEs3Rgba1010102(EGLDisplay eglDisplay) {
        return Api17.createEglContext(eglDisplay, 3, EGL_CONFIG_ATTRIBUTES_RGBA_1010102);
    }

    @RequiresApi(value=17)
    public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface) {
        return Api17.getEglSurface(eglDisplay, surface, EGL_CONFIG_ATTRIBUTES_RGBA_8888, EGL_WINDOW_SURFACE_ATTRIBUTES_NONE);
    }

    @RequiresApi(value=17)
    public static EGLSurface getEglSurfaceBt2020Pq(EGLDisplay eglDisplay, Object surface) {
        return Api17.getEglSurface(eglDisplay, surface, EGL_CONFIG_ATTRIBUTES_RGBA_1010102, EGL_WINDOW_SURFACE_ATTRIBUTES_BT2020_PQ);
    }

    @RequiresApi(value=17)
    private static EGLSurface createPbufferSurface(EGLDisplay eglDisplay, int width, int height) {
        int[] pbufferAttributes = new int[]{12375, width, 12374, height, 12344};
        return Api17.createEglPbufferSurface(eglDisplay, EGL_CONFIG_ATTRIBUTES_RGBA_8888, pbufferAttributes);
    }

    @RequiresApi(value=17)
    public static EGLSurface createPlaceholderEglSurface(EGLDisplay eglDisplay) {
        return GlUtil.isSurfacelessContextExtensionSupported() ? EGL14.EGL_NO_SURFACE : GlUtil.createPbufferSurface(eglDisplay, 1, 1);
    }

    @RequiresApi(value=17)
    public static void focusPlaceholderEglSurface(EGLContext eglContext, EGLDisplay eglDisplay) {
        EGLSurface eglSurface = GlUtil.createPbufferSurface(eglDisplay, 1, 1);
        GlUtil.focusEglSurface(eglDisplay, eglContext, eglSurface, 1, 1);
    }

    @RequiresApi(value=17)
    public static void focusPlaceholderEglSurfaceBt2020Pq(EGLContext eglContext, EGLDisplay eglDisplay) {
        int[] pbufferAttributes = new int[]{12375, 1, 12374, 1, 12445, 13120, 12344};
        EGLSurface eglSurface = Api17.createEglPbufferSurface(eglDisplay, EGL_CONFIG_ATTRIBUTES_RGBA_1010102, pbufferAttributes);
        GlUtil.focusEglSurface(eglDisplay, eglContext, eglSurface, 1, 1);
    }

    public static void checkGlError() {
        int error;
        int lastError = 0;
        while ((error = GLES20.glGetError()) != 0) {
            Log.e(TAG, "glError: " + GLU.gluErrorString((int)error));
            lastError = error;
        }
        if (lastError != 0) {
            GlUtil.throwGlException("glError: " + GLU.gluErrorString((int)lastError));
        }
    }

    public static void assertValidTextureSize(int width, int height) {
        int[] maxTextureSizeBuffer = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])maxTextureSizeBuffer, (int)0);
        int maxTextureSize = maxTextureSizeBuffer[0];
        if (width < 0 || height < 0) {
            GlUtil.throwGlException("width or height is less than 0");
        }
        if (width > maxTextureSize || height > maxTextureSize) {
            GlUtil.throwGlException("width or height is greater than GL_MAX_TEXTURE_SIZE " + maxTextureSize);
        }
    }

    @RequiresApi(value=17)
    public static void focusEglSurface(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int width, int height) {
        Api17.focusRenderTarget(eglDisplay, eglContext, eglSurface, 0, width, height);
    }

    @RequiresApi(value=17)
    public static void focusFramebuffer(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int framebuffer, int width, int height) {
        Api17.focusRenderTarget(eglDisplay, eglContext, eglSurface, framebuffer, width, height);
    }

    public static void deleteTexture(int textureId) {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        GlUtil.checkGlError();
    }

    @RequiresApi(value=17)
    public static void destroyEglContext(@Nullable EGLDisplay eglDisplay, @Nullable EGLContext eglContext) {
        Api17.destroyEglContext(eglDisplay, eglContext);
    }

    public static FloatBuffer createBuffer(float[] data) {
        return (FloatBuffer)GlUtil.createBuffer(data.length).put(data).flip();
    }

    public static FloatBuffer createBuffer(int capacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(capacity * 4);
        return byteBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAsset(Context context, String assetPath) throws IOException {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetPath);
            string = Util.fromUtf8Bytes(Util.toByteArray(inputStream));
        }
        catch (Throwable throwable) {
            Util.closeQuietly(inputStream);
            throw throwable;
        }
        Util.closeQuietly(inputStream);
        return string;
    }

    public static int createExternalTexture() {
        int texId = GlUtil.generateTexture();
        GlUtil.bindTexture(36197, texId);
        return texId;
    }

    public static int createTexture(int width, int height) {
        GlUtil.assertValidTextureSize(width, height);
        int texId = GlUtil.generateTexture();
        GlUtil.bindTexture(3553, texId);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkGlError();
        return texId;
    }

    private static int generateTexture() {
        GlUtil.checkEglException(!Util.areEqual(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT), "No current context");
        int[] texId = new int[1];
        GLES20.glGenTextures((int)1, (int[])texId, (int)0);
        GlUtil.checkGlError();
        return texId[0];
    }

    public static void bindTexture(int textureTarget, int texId) {
        GLES20.glBindTexture((int)textureTarget, (int)texId);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10240, (int)9729);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10241, (int)9729);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10242, (int)33071);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10243, (int)33071);
        GlUtil.checkGlError();
    }

    public static int createFboForTexture(int texId) {
        GlUtil.checkEglException(!Util.areEqual(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT), "No current context");
        int[] fboId = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])fboId, (int)0);
        GlUtil.checkGlError();
        GLES20.glBindFramebuffer((int)36160, (int)fboId[0]);
        GlUtil.checkGlError();
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texId, (int)0);
        GlUtil.checkGlError();
        return fboId[0];
    }

    static void throwGlException(String errorMsg) {
        if (glAssertionsEnabled) {
            throw new GlException(errorMsg);
        }
        Log.e(TAG, errorMsg);
    }

    private static void checkEglException(boolean expression, String errorMessage) {
        if (!expression) {
            GlUtil.throwGlException(errorMessage);
        }
    }

    private static void checkEglException(String errorMessage) {
        int error = EGL14.eglGetError();
        GlUtil.checkEglException(error == 12288, errorMessage + ", error code: " + error);
    }

    @RequiresApi(value=17)
    private static final class Api17 {
        private Api17() {
        }

        @DoNotInline
        public static EGLDisplay createEglDisplay() {
            EGLDisplay eglDisplay = EGL14.eglGetDisplay((int)0);
            GlUtil.checkEglException(!eglDisplay.equals((Object)EGL14.EGL_NO_DISPLAY), "No EGL display.");
            if (!EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])new int[1], (int)0, (int[])new int[1], (int)0)) {
                GlUtil.throwGlException("Error in eglInitialize.");
            }
            GlUtil.checkGlError();
            return eglDisplay;
        }

        @DoNotInline
        public static EGLContext createEglContext(EGLDisplay eglDisplay, int version, int[] configAttributes) {
            int[] contextAttributes = new int[]{12440, version, 12344};
            EGLContext eglContext = EGL14.eglCreateContext((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])contextAttributes, (int)0);
            if (eglContext == null) {
                EGL14.eglTerminate((EGLDisplay)eglDisplay);
                GlUtil.throwGlException("eglCreateContext() failed to create a valid context. The device may not support EGL version " + version);
            }
            GlUtil.checkGlError();
            return eglContext;
        }

        @DoNotInline
        public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface, int[] configAttributes, int[] windowSurfaceAttributes) {
            EGLSurface eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (Object)surface, (int[])windowSurfaceAttributes, (int)0);
            GlUtil.checkEglException("Error creating surface");
            return eglSurface;
        }

        @DoNotInline
        public static EGLSurface createEglPbufferSurface(EGLDisplay eglDisplay, int[] configAttributes, int[] pbufferAttributes) {
            EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (int[])pbufferAttributes, (int)0);
            GlUtil.checkEglException("Error creating surface");
            return eglSurface;
        }

        @DoNotInline
        public static void focusRenderTarget(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int framebuffer, int width, int height) {
            int[] boundFramebuffer = new int[1];
            GLES20.glGetIntegerv((int)36006, (int[])boundFramebuffer, (int)0);
            if (boundFramebuffer[0] != framebuffer) {
                GLES20.glBindFramebuffer((int)36160, (int)framebuffer);
            }
            GlUtil.checkGlError();
            EGL14.eglMakeCurrent((EGLDisplay)eglDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)eglContext);
            GlUtil.checkEglException("Error making context current");
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            GlUtil.checkGlError();
        }

        @DoNotInline
        public static void destroyEglContext(@Nullable EGLDisplay eglDisplay, @Nullable EGLContext eglContext) {
            if (eglDisplay == null) {
                return;
            }
            EGL14.eglMakeCurrent((EGLDisplay)eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            GlUtil.checkEglException("Error releasing context");
            if (eglContext != null) {
                EGL14.eglDestroyContext((EGLDisplay)eglDisplay, (EGLContext)eglContext);
                GlUtil.checkEglException("Error destroying context");
            }
            EGL14.eglReleaseThread();
            GlUtil.checkEglException("Error releasing thread");
            EGL14.eglTerminate((EGLDisplay)eglDisplay);
            GlUtil.checkEglException("Error terminating display");
        }

        @DoNotInline
        private static EGLConfig getEglConfig(EGLDisplay eglDisplay, int[] attributes) {
            EGLConfig[] eglConfigs = new EGLConfig[1];
            if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])attributes, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)1, (int[])new int[1], (int)0)) {
                GlUtil.throwGlException("eglChooseConfig failed.");
            }
            return eglConfigs[0];
        }
    }

    public static final class GlException
    extends RuntimeException {
        public GlException(String message) {
            super(message);
        }
    }
}

