/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import com.google.android.exoplayer2.util.Assertions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@Deprecated
public class FrameInfo {
    public final int width;
    public final int height;
    public final float pixelWidthHeightRatio;
    public final long offsetToAddUs;

    private FrameInfo(int width, int height, float pixelWidthHeightRatio, long offsetToAddUs) {
        Assertions.checkArgument(width > 0, "width must be positive, but is: " + width);
        Assertions.checkArgument(height > 0, "height must be positive, but is: " + height);
        this.width = width;
        this.height = height;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.offsetToAddUs = offsetToAddUs;
    }

    public static final class Builder {
        private int width;
        private int height;
        private float pixelWidthHeightRatio;
        private long offsetToAddUs;

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.pixelWidthHeightRatio = 1.0f;
        }

        public Builder(FrameInfo frameInfo) {
            this.width = frameInfo.width;
            this.height = frameInfo.height;
            this.pixelWidthHeightRatio = frameInfo.pixelWidthHeightRatio;
            this.offsetToAddUs = frameInfo.offsetToAddUs;
        }

        @CanIgnoreReturnValue
        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPixelWidthHeightRatio(float pixelWidthHeightRatio) {
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOffsetToAddUs(long offsetToAddUs) {
            this.offsetToAddUs = offsetToAddUs;
            return this;
        }

        public FrameInfo build() {
            return new FrameInfo(this.width, this.height, this.pixelWidthHeightRatio, this.offsetToAddUs);
        }
    }
}

