/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import org.checkerframework.dataflow.qual.Pure;

@Deprecated
public final class ColorInfo
implements Bundleable {
    public static final ColorInfo SDR_BT709_LIMITED = new ColorInfo(1, 2, 3, null);
    public static final ColorInfo SRGB_BT709_FULL = new Builder().setColorSpace(1).setColorRange(1).setColorTransfer(2).build();
    public final int colorSpace;
    public final int colorRange;
    public final int colorTransfer;
    @Nullable
    public final byte[] hdrStaticInfo;
    private int hashCode;
    private static final String FIELD_COLOR_SPACE = Util.intToStringMaxRadix(0);
    private static final String FIELD_COLOR_RANGE = Util.intToStringMaxRadix(1);
    private static final String FIELD_COLOR_TRANSFER = Util.intToStringMaxRadix(2);
    private static final String FIELD_HDR_STATIC_INFO = Util.intToStringMaxRadix(3);
    public static final Bundleable.Creator<ColorInfo> CREATOR = bundle -> new ColorInfo(bundle.getInt(FIELD_COLOR_SPACE, -1), bundle.getInt(FIELD_COLOR_RANGE, -1), bundle.getInt(FIELD_COLOR_TRANSFER, -1), bundle.getByteArray(FIELD_HDR_STATIC_INFO));

    @Pure
    public static int isoColorPrimariesToColorSpace(int isoColorPrimaries) {
        switch (isoColorPrimaries) {
            case 1: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
            case 9: {
                return 6;
            }
        }
        return -1;
    }

    @Pure
    public static int isoTransferCharacteristicsToColorTransfer(int isoTransferCharacteristics) {
        switch (isoTransferCharacteristics) {
            case 1: 
            case 6: 
            case 7: {
                return 3;
            }
            case 4: {
                return 10;
            }
            case 13: {
                return 2;
            }
            case 16: {
                return 6;
            }
            case 18: {
                return 7;
            }
        }
        return -1;
    }

    public static boolean isTransferHdr(@Nullable ColorInfo colorInfo) {
        return colorInfo != null && (colorInfo.colorTransfer == 7 || colorInfo.colorTransfer == 6);
    }

    @Deprecated
    public ColorInfo(int colorSpace, int colorRange, int colorTransfer, @Nullable byte[] hdrStaticInfo) {
        this.colorSpace = colorSpace;
        this.colorRange = colorRange;
        this.colorTransfer = colorTransfer;
        this.hdrStaticInfo = hdrStaticInfo;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean isValid() {
        return this.colorSpace != -1 && this.colorRange != -1 && this.colorTransfer != -1;
    }

    public String toLogString() {
        if (!this.isValid()) {
            return "NA";
        }
        return Util.formatInvariant("%s/%s/%s", ColorInfo.colorSpaceToString(this.colorSpace), ColorInfo.colorRangeToString(this.colorRange), ColorInfo.colorTransferToString(this.colorTransfer));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColorInfo other = (ColorInfo)obj;
        return this.colorSpace == other.colorSpace && this.colorRange == other.colorRange && this.colorTransfer == other.colorTransfer && Arrays.equals(this.hdrStaticInfo, other.hdrStaticInfo);
    }

    public String toString() {
        return "ColorInfo(" + ColorInfo.colorSpaceToString(this.colorSpace) + ", " + ColorInfo.colorRangeToString(this.colorRange) + ", " + ColorInfo.colorTransferToString(this.colorTransfer) + ", " + (this.hdrStaticInfo != null) + ")";
    }

    private static String colorSpaceToString(int colorSpace) {
        switch (colorSpace) {
            case -1: {
                return "Unset color space";
            }
            case 2: {
                return "BT601";
            }
            case 1: {
                return "BT709";
            }
            case 6: {
                return "BT2020";
            }
        }
        return "Undefined color space";
    }

    private static String colorTransferToString(int colorTransfer) {
        switch (colorTransfer) {
            case -1: {
                return "Unset color transfer";
            }
            case 1: {
                return "Linear";
            }
            case 3: {
                return "SDR SMPTE 170M";
            }
            case 2: {
                return "sRGB";
            }
            case 10: {
                return "Gamma 2.2";
            }
            case 6: {
                return "ST2084 PQ";
            }
            case 7: {
                return "HLG";
            }
        }
        return "Undefined color transfer";
    }

    private static String colorRangeToString(int colorRange) {
        switch (colorRange) {
            case -1: {
                return "Unset color range";
            }
            case 2: {
                return "Limited range";
            }
            case 1: {
                return "Full range";
            }
        }
        return "Undefined color range";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + this.colorSpace;
            result = 31 * result + this.colorRange;
            result = 31 * result + this.colorTransfer;
            this.hashCode = result = 31 * result + Arrays.hashCode(this.hdrStaticInfo);
        }
        return this.hashCode;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(FIELD_COLOR_SPACE, this.colorSpace);
        bundle.putInt(FIELD_COLOR_RANGE, this.colorRange);
        bundle.putInt(FIELD_COLOR_TRANSFER, this.colorTransfer);
        bundle.putByteArray(FIELD_HDR_STATIC_INFO, this.hdrStaticInfo);
        return bundle;
    }

    public static final class Builder {
        private int colorSpace;
        private int colorRange;
        private int colorTransfer;
        @Nullable
        private byte[] hdrStaticInfo;

        public Builder() {
            this.colorSpace = -1;
            this.colorRange = -1;
            this.colorTransfer = -1;
        }

        private Builder(ColorInfo colorInfo) {
            this.colorSpace = colorInfo.colorSpace;
            this.colorRange = colorInfo.colorRange;
            this.colorTransfer = colorInfo.colorTransfer;
            this.hdrStaticInfo = colorInfo.hdrStaticInfo;
        }

        @CanIgnoreReturnValue
        public Builder setColorSpace(int colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setColorRange(int colorRange) {
            this.colorRange = colorRange;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setColorTransfer(int colorTransfer) {
            this.colorTransfer = colorTransfer;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHdrStaticInfo(@Nullable byte[] hdrStaticInfo) {
            this.hdrStaticInfo = hdrStaticInfo;
            return this;
        }

        public ColorInfo build() {
            return new ColorInfo(this.colorSpace, this.colorRange, this.colorTransfer, this.hdrStaticInfo);
        }
    }
}

