/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class AssetDataSource
extends BaseDataSource {
    private final AssetManager assetManager;
    @Nullable
    private Uri uri;
    @Nullable
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public AssetDataSource(Context context) {
        super(false);
        this.assetManager = context.getAssets();
    }

    @Override
    public long open(DataSpec dataSpec) throws AssetDataSourceException {
        try {
            this.uri = dataSpec.uri;
            String path = (String)Assertions.checkNotNull((Object)this.uri.getPath());
            if (path.startsWith("/android_asset/")) {
                path = path.substring(15);
            } else if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.transferInitializing(dataSpec);
            this.inputStream = this.assetManager.open(path, 1);
            long skipped = this.inputStream.skip(dataSpec.position);
            if (skipped < dataSpec.position) {
                throw new AssetDataSourceException(null, 2008);
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.inputStream.available();
                if (this.bytesRemaining == Integer.MAX_VALUE) {
                    this.bytesRemaining = -1L;
                }
            }
        }
        catch (AssetDataSourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssetDataSourceException(e, e instanceof FileNotFoundException ? 2005 : 2000);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) throws AssetDataSourceException {
        int bytesRead;
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? length : (int)Math.min(this.bytesRemaining, (long)length);
            bytesRead = ((InputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new AssetDataSourceException(e, 2000);
        }
        if (bytesRead == -1) {
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() throws AssetDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw new AssetDataSourceException(e, 2000);
        }
        finally {
            this.inputStream = null;
            if (this.opened) {
                this.opened = false;
                this.transferEnded();
            }
        }
    }

    public static final class AssetDataSourceException
    extends DataSourceException {
        @Deprecated
        public AssetDataSourceException(IOException cause) {
            super(cause, 2000);
        }

        public AssetDataSourceException(@Nullable Throwable cause, int errorCode) {
            super(cause, errorCode);
        }
    }
}

