/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Deprecated
public final class TeeDataSource
implements DataSource {
    private final DataSource upstream;
    private final DataSink dataSink;
    private boolean dataSinkNeedsClosing;
    private long bytesRemaining;

    public TeeDataSource(DataSource upstream, DataSink dataSink) {
        this.upstream = (DataSource)Assertions.checkNotNull((Object)upstream);
        this.dataSink = (DataSink)Assertions.checkNotNull((Object)dataSink);
    }

    @Override
    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull((Object)transferListener);
        this.upstream.addTransferListener(transferListener);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.bytesRemaining = this.upstream.open(dataSpec);
        if (this.bytesRemaining == 0L) {
            return 0L;
        }
        if (dataSpec.length == -1L && this.bytesRemaining != -1L) {
            dataSpec = dataSpec.subrange(0L, this.bytesRemaining);
        }
        this.dataSinkNeedsClosing = true;
        this.dataSink.open(dataSpec);
        return this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesRead = this.upstream.read(buffer, offset, length);
        if (bytesRead > 0) {
            this.dataSink.write(buffer, offset, bytesRead);
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= (long)bytesRead;
            }
        }
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.upstream.getUri();
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.upstream.getResponseHeaders();
    }

    @Override
    public void close() throws IOException {
        try {
            this.upstream.close();
        }
        finally {
            if (this.dataSinkNeedsClosing) {
                this.dataSinkNeedsClosing = false;
                this.dataSink.close();
            }
        }
    }
}

