/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.dvbsi;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.SimpleMetadataDecoder;
import com.google.android.exoplayer2.metadata.dvbsi.AppInfoTable;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class AppInfoTableDecoder
extends SimpleMetadataDecoder {
    private static final int DESCRIPTOR_TRANSPORT_PROTOCOL = 2;
    private static final int DESCRIPTOR_SIMPLE_APPLICATION_LOCATION = 21;
    private static final int TRANSPORT_PROTOCOL_HTTP = 3;
    public static final int APPLICATION_INFORMATION_TABLE_ID = 116;

    @Override
    @Nullable
    protected Metadata decode(MetadataInputBuffer inputBuffer, ByteBuffer buffer) {
        byte tableId = buffer.get();
        return tableId == 116 ? AppInfoTableDecoder.parseAit(new ParsableBitArray(buffer.array(), buffer.limit())) : null;
    }

    @Nullable
    private static Metadata parseAit(ParsableBitArray sectionData) {
        sectionData.skipBits(12);
        int sectionLength = sectionData.readBits(12);
        int endOfSection = sectionData.getBytePosition() + sectionLength - 4;
        sectionData.skipBits(44);
        int commonDescriptorsLength = sectionData.readBits(12);
        sectionData.skipBytes(commonDescriptorsLength);
        sectionData.skipBits(16);
        ArrayList<AppInfoTable> appInfoTables = new ArrayList<AppInfoTable>();
        while (sectionData.getBytePosition() < endOfSection) {
            String urlBase = null;
            String urlExtension = null;
            sectionData.skipBits(48);
            int controlCode = sectionData.readBits(8);
            sectionData.skipBits(4);
            int applicationDescriptorsLoopLength = sectionData.readBits(12);
            int positionOfNextApplication = sectionData.getBytePosition() + applicationDescriptorsLoopLength;
            while (sectionData.getBytePosition() < positionOfNextApplication) {
                int descriptorTag = sectionData.readBits(8);
                int descriptorLength = sectionData.readBits(8);
                int positionOfNextDescriptor = sectionData.getBytePosition() + descriptorLength;
                if (descriptorTag == 2) {
                    int protocolId = sectionData.readBits(16);
                    sectionData.skipBits(8);
                    if (protocolId == 3) {
                        while (sectionData.getBytePosition() < positionOfNextDescriptor) {
                            int urlBaseLength = sectionData.readBits(8);
                            urlBase = sectionData.readBytesAsString(urlBaseLength, Charsets.US_ASCII);
                            int extensionCount = sectionData.readBits(8);
                            for (int urlExtensionIndex = 0; urlExtensionIndex < extensionCount; ++urlExtensionIndex) {
                                int urlExtensionLength = sectionData.readBits(8);
                                sectionData.skipBytes(urlExtensionLength);
                            }
                        }
                    }
                } else if (descriptorTag == 21) {
                    urlExtension = sectionData.readBytesAsString(descriptorLength, Charsets.US_ASCII);
                }
                sectionData.setPosition(positionOfNextDescriptor * 8);
            }
            sectionData.setPosition(positionOfNextApplication * 8);
            if (urlBase == null || urlExtension == null) continue;
            String string = String.valueOf(urlBase);
            String string2 = String.valueOf(urlExtension);
            appInfoTables.add(new AppInfoTable(controlCode, string2.length() != 0 ? string.concat(string2) : new String(string)));
        }
        return appInfoTables.isEmpty() ? null : new Metadata(appInfoTables);
    }
}

