/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorUtil;
import com.google.android.exoplayer2.extractor.FlacStreamMetadata;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class FlacFrameReader {
    public static boolean checkAndReadFrameHeader(ParsableByteArray data, FlacStreamMetadata flacStreamMetadata, int frameStartMarker, SampleNumberHolder sampleNumberHolder) {
        int frameStartPosition = data.getPosition();
        long frameHeaderBytes = data.readUnsignedInt();
        if (frameHeaderBytes >>> 16 != (long)frameStartMarker) {
            return false;
        }
        boolean isBlockSizeVariable = (frameHeaderBytes >>> 16 & 1L) == 1L;
        int blockSizeKey = (int)(frameHeaderBytes >> 12 & 0xFL);
        int sampleRateKey = (int)(frameHeaderBytes >> 8 & 0xFL);
        int channelAssignmentKey = (int)(frameHeaderBytes >> 4 & 0xFL);
        int bitsPerSampleKey = (int)(frameHeaderBytes >> 1 & 7L);
        boolean reservedBit = (frameHeaderBytes & 1L) == 1L;
        return FlacFrameReader.checkChannelAssignment(channelAssignmentKey, flacStreamMetadata) && FlacFrameReader.checkBitsPerSample(bitsPerSampleKey, flacStreamMetadata) && !reservedBit && FlacFrameReader.checkAndReadFirstSampleNumber(data, flacStreamMetadata, isBlockSizeVariable, sampleNumberHolder) && FlacFrameReader.checkAndReadBlockSizeSamples(data, flacStreamMetadata, blockSizeKey) && FlacFrameReader.checkAndReadSampleRate(data, flacStreamMetadata, sampleRateKey) && FlacFrameReader.checkAndReadCrc(data, frameStartPosition);
    }

    public static boolean checkFrameHeaderFromPeek(ExtractorInput input, FlacStreamMetadata flacStreamMetadata, int frameStartMarker, SampleNumberHolder sampleNumberHolder) throws IOException {
        long originalPeekPosition = input.getPeekPosition();
        byte[] frameStartBytes = new byte[2];
        input.peekFully(frameStartBytes, 0, 2);
        int frameStart = (frameStartBytes[0] & 0xFF) << 8 | frameStartBytes[1] & 0xFF;
        if (frameStart != frameStartMarker) {
            input.resetPeekPosition();
            input.advancePeekPosition((int)(originalPeekPosition - input.getPosition()));
            return false;
        }
        ParsableByteArray scratch = new ParsableByteArray(16);
        System.arraycopy(frameStartBytes, 0, scratch.getData(), 0, 2);
        int totalBytesPeeked = ExtractorUtil.peekToLength(input, scratch.getData(), 2, 14);
        scratch.setLimit(totalBytesPeeked);
        input.resetPeekPosition();
        input.advancePeekPosition((int)(originalPeekPosition - input.getPosition()));
        return FlacFrameReader.checkAndReadFrameHeader(scratch, flacStreamMetadata, frameStartMarker, sampleNumberHolder);
    }

    public static long getFirstSampleNumber(ExtractorInput input, FlacStreamMetadata flacStreamMetadata) throws IOException {
        input.resetPeekPosition();
        input.advancePeekPosition(1);
        byte[] blockingStrategyByte = new byte[1];
        input.peekFully(blockingStrategyByte, 0, 1);
        boolean isBlockSizeVariable = (blockingStrategyByte[0] & 1) == 1;
        input.advancePeekPosition(2);
        int maxUtf8SampleNumberSize = isBlockSizeVariable ? 7 : 6;
        ParsableByteArray scratch = new ParsableByteArray(maxUtf8SampleNumberSize);
        int totalBytesPeeked = ExtractorUtil.peekToLength(input, scratch.getData(), 0, maxUtf8SampleNumberSize);
        scratch.setLimit(totalBytesPeeked);
        input.resetPeekPosition();
        SampleNumberHolder sampleNumberHolder = new SampleNumberHolder();
        if (!FlacFrameReader.checkAndReadFirstSampleNumber(scratch, flacStreamMetadata, isBlockSizeVariable, sampleNumberHolder)) {
            throw ParserException.createForMalformedContainer(null, null);
        }
        return sampleNumberHolder.sampleNumber;
    }

    public static int readFrameBlockSizeSamplesFromKey(ParsableByteArray data, int blockSizeKey) {
        switch (blockSizeKey) {
            case 1: {
                return 192;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 576 << blockSizeKey - 2;
            }
            case 6: {
                return data.readUnsignedByte() + 1;
            }
            case 7: {
                return data.readUnsignedShort() + 1;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return 256 << blockSizeKey - 8;
            }
        }
        return -1;
    }

    private static boolean checkChannelAssignment(int channelAssignmentKey, FlacStreamMetadata flacStreamMetadata) {
        if (channelAssignmentKey <= 7) {
            return channelAssignmentKey == flacStreamMetadata.channels - 1;
        }
        if (channelAssignmentKey <= 10) {
            return flacStreamMetadata.channels == 2;
        }
        return false;
    }

    private static boolean checkBitsPerSample(int bitsPerSampleKey, FlacStreamMetadata flacStreamMetadata) {
        if (bitsPerSampleKey == 0) {
            return true;
        }
        return bitsPerSampleKey == flacStreamMetadata.bitsPerSampleLookupKey;
    }

    private static boolean checkAndReadFirstSampleNumber(ParsableByteArray data, FlacStreamMetadata flacStreamMetadata, boolean isBlockSizeVariable, SampleNumberHolder sampleNumberHolder) {
        long utf8Value;
        try {
            utf8Value = data.readUtf8EncodedLong();
        }
        catch (NumberFormatException e) {
            return false;
        }
        sampleNumberHolder.sampleNumber = isBlockSizeVariable ? utf8Value : utf8Value * (long)flacStreamMetadata.maxBlockSizeSamples;
        return true;
    }

    private static boolean checkAndReadBlockSizeSamples(ParsableByteArray data, FlacStreamMetadata flacStreamMetadata, int blockSizeKey) {
        int blockSizeSamples = FlacFrameReader.readFrameBlockSizeSamplesFromKey(data, blockSizeKey);
        return blockSizeSamples != -1 && blockSizeSamples <= flacStreamMetadata.maxBlockSizeSamples;
    }

    private static boolean checkAndReadSampleRate(ParsableByteArray data, FlacStreamMetadata flacStreamMetadata, int sampleRateKey) {
        int expectedSampleRate = flacStreamMetadata.sampleRate;
        if (sampleRateKey == 0) {
            return true;
        }
        if (sampleRateKey <= 11) {
            return sampleRateKey == flacStreamMetadata.sampleRateLookupKey;
        }
        if (sampleRateKey == 12) {
            return data.readUnsignedByte() * 1000 == expectedSampleRate;
        }
        if (sampleRateKey <= 14) {
            int sampleRate = data.readUnsignedShort();
            if (sampleRateKey == 14) {
                sampleRate *= 10;
            }
            return sampleRate == expectedSampleRate;
        }
        return false;
    }

    private static boolean checkAndReadCrc(ParsableByteArray data, int frameStartPosition) {
        int crc = data.readUnsignedByte();
        int frameEndPosition = data.getPosition();
        int expectedCrc = Util.crc8((byte[])data.getData(), (int)frameStartPosition, (int)(frameEndPosition - 1), (int)0);
        return crc == expectedCrc;
    }

    private FlacFrameReader() {
    }

    public static final class SampleNumberHolder {
        public long sampleNumber;
    }
}

