/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ogg.FlacReader;
import com.google.android.exoplayer2.extractor.ogg.OggPageHeader;
import com.google.android.exoplayer2.extractor.ogg.OpusReader;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.extractor.ogg.VorbisReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public class OggExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new OggExtractor()};
    private static final int MAX_VERIFICATION_BYTES = 8;
    private @MonotonicNonNull ExtractorOutput output;
    private @MonotonicNonNull StreamReader streamReader;
    private boolean streamReaderInitialized;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        try {
            return this.sniffInternal(input);
        }
        catch (ParserException e) {
            return false;
        }
    }

    @Override
    public void init(ExtractorOutput output) {
        this.output = output;
    }

    @Override
    public void seek(long position, long timeUs) {
        if (this.streamReader != null) {
            this.streamReader.seek(position, timeUs);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        Assertions.checkStateNotNull((Object)this.output);
        if (this.streamReader == null) {
            if (!this.sniffInternal(input)) {
                throw ParserException.createForMalformedContainer((String)"Failed to determine bitstream type", null);
            }
            input.resetPeekPosition();
        }
        if (!this.streamReaderInitialized) {
            TrackOutput trackOutput = this.output.track(0, 1);
            this.output.endTracks();
            this.streamReader.init(this.output, trackOutput);
            this.streamReaderInitialized = true;
        }
        return this.streamReader.read(input, seekPosition);
    }

    @EnsuresNonNullIf(expression={"streamReader"}, result=true)
    private boolean sniffInternal(ExtractorInput input) throws IOException {
        OggPageHeader header = new OggPageHeader();
        if (!header.populate(input, true) || (header.type & 2) != 2) {
            return false;
        }
        int length = Math.min(header.bodySize, 8);
        ParsableByteArray scratch = new ParsableByteArray(length);
        input.peekFully(scratch.getData(), 0, length);
        if (FlacReader.verifyBitstreamType(OggExtractor.resetPosition(scratch))) {
            this.streamReader = new FlacReader();
        } else if (VorbisReader.verifyBitstreamType(OggExtractor.resetPosition(scratch))) {
            this.streamReader = new VorbisReader();
        } else if (OpusReader.verifyBitstreamType(OggExtractor.resetPosition(scratch))) {
            this.streamReader = new OpusReader();
        } else {
            return false;
        }
        return true;
    }

    private static ParsableByteArray resetPosition(ParsableByteArray scratch) {
        scratch.setPosition(0);
        return scratch;
    }
}

