/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ssa;

import android.text.Layout;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.SimpleSubtitleDecoder;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.ssa.SsaDialogueFormat;
import com.google.android.exoplayer2.text.ssa.SsaStyle;
import com.google.android.exoplayer2.text.ssa.SsaSubtitle;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class SsaDecoder
extends SimpleSubtitleDecoder {
    private static final String TAG = "SsaDecoder";
    private static final Pattern SSA_TIMECODE_PATTERN = Pattern.compile("(?:(\\d+):)?(\\d+):(\\d+)[:.](\\d+)");
    static final String FORMAT_LINE_PREFIX = "Format:";
    static final String STYLE_LINE_PREFIX = "Style:";
    private static final String DIALOGUE_LINE_PREFIX = "Dialogue:";
    private static final float DEFAULT_MARGIN = 0.05f;
    private final boolean haveInitializationData;
    @Nullable
    private final SsaDialogueFormat dialogueFormatFromInitializationData;
    private @MonotonicNonNull Map<String, SsaStyle> styles;
    private float screenWidth = -3.4028235E38f;
    private float screenHeight = -3.4028235E38f;

    public SsaDecoder() {
        this((List<byte[]>)null);
    }

    public SsaDecoder(@Nullable List<byte[]> initializationData) {
        super(TAG);
        if (initializationData != null && !initializationData.isEmpty()) {
            this.haveInitializationData = true;
            String formatLine = Util.fromUtf8Bytes((byte[])initializationData.get(0));
            Assertions.checkArgument((boolean)formatLine.startsWith(FORMAT_LINE_PREFIX));
            this.dialogueFormatFromInitializationData = (SsaDialogueFormat)Assertions.checkNotNull((Object)SsaDialogueFormat.fromFormatLine(formatLine));
            this.parseHeader(new ParsableByteArray(initializationData.get(1)), Charsets.UTF_8);
        } else {
            this.haveInitializationData = false;
            this.dialogueFormatFromInitializationData = null;
        }
    }

    @Override
    protected Subtitle decode(byte[] data, int length, boolean reset) {
        ArrayList<List<Cue>> cues = new ArrayList<List<Cue>>();
        ArrayList<Long> cueTimesUs = new ArrayList<Long>();
        ParsableByteArray parsableData = new ParsableByteArray(data, length);
        Charset charset = this.detectUtfCharset(parsableData);
        if (!this.haveInitializationData) {
            this.parseHeader(parsableData, charset);
        }
        this.parseEventBody(parsableData, cues, cueTimesUs, charset);
        return new SsaSubtitle(cues, cueTimesUs);
    }

    private Charset detectUtfCharset(ParsableByteArray data) {
        Charset charset = data.readUtfCharsetFromBom();
        return charset != null ? charset : Charsets.UTF_8;
    }

    private void parseHeader(ParsableByteArray data, Charset charset) {
        String currentLine;
        while ((currentLine = data.readLine(charset)) != null) {
            if ("[Script Info]".equalsIgnoreCase(currentLine)) {
                this.parseScriptInfo(data, charset);
                continue;
            }
            if ("[V4+ Styles]".equalsIgnoreCase(currentLine)) {
                this.styles = SsaDecoder.parseStyles(data, charset);
                continue;
            }
            if ("[V4 Styles]".equalsIgnoreCase(currentLine)) {
                Log.i((String)TAG, (String)"[V4 Styles] are not supported");
                continue;
            }
            if (!"[Events]".equalsIgnoreCase(currentLine)) continue;
            return;
        }
    }

    private void parseScriptInfo(ParsableByteArray data, Charset charset) {
        String currentLine;
        while ((currentLine = data.readLine(charset)) != null && (data.bytesLeft() == 0 || data.peekChar(charset) != '[')) {
            String[] infoNameAndValue = currentLine.split(":");
            if (infoNameAndValue.length != 2) continue;
            switch (Ascii.toLowerCase((String)infoNameAndValue[0].trim())) {
                case "playresx": {
                    try {
                        this.screenWidth = Float.parseFloat(infoNameAndValue[1].trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "playresy": {
                    try {
                        this.screenHeight = Float.parseFloat(infoNameAndValue[1].trim());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static Map<String, SsaStyle> parseStyles(ParsableByteArray data, Charset charset) {
        String currentLine;
        LinkedHashMap<String, SsaStyle> styles = new LinkedHashMap<String, SsaStyle>();
        SsaStyle.Format formatInfo = null;
        while ((currentLine = data.readLine(charset)) != null && (data.bytesLeft() == 0 || data.peekChar(charset) != '[')) {
            if (currentLine.startsWith(FORMAT_LINE_PREFIX)) {
                formatInfo = SsaStyle.Format.fromFormatLine(currentLine);
                continue;
            }
            if (!currentLine.startsWith(STYLE_LINE_PREFIX)) continue;
            if (formatInfo == null) {
                Log.w((String)TAG, (String)("Skipping 'Style:' line before 'Format:' line: " + currentLine));
                continue;
            }
            SsaStyle style = SsaStyle.fromStyleLine(currentLine, formatInfo);
            if (style == null) continue;
            styles.put(style.name, style);
        }
        return styles;
    }

    private void parseEventBody(ParsableByteArray data, List<List<Cue>> cues, List<Long> cueTimesUs, Charset charset) {
        String currentLine;
        SsaDialogueFormat format;
        SsaDialogueFormat ssaDialogueFormat = format = this.haveInitializationData ? this.dialogueFormatFromInitializationData : null;
        while ((currentLine = data.readLine(charset)) != null) {
            if (currentLine.startsWith(FORMAT_LINE_PREFIX)) {
                format = SsaDialogueFormat.fromFormatLine(currentLine);
                continue;
            }
            if (!currentLine.startsWith(DIALOGUE_LINE_PREFIX)) continue;
            if (format == null) {
                Log.w((String)TAG, (String)("Skipping dialogue line before complete format: " + currentLine));
                continue;
            }
            this.parseDialogueLine(currentLine, format, cues, cueTimesUs);
        }
    }

    private void parseDialogueLine(String dialogueLine, SsaDialogueFormat format, List<List<Cue>> cues, List<Long> cueTimesUs) {
        Assertions.checkArgument((boolean)dialogueLine.startsWith(DIALOGUE_LINE_PREFIX));
        String[] lineValues = dialogueLine.substring(DIALOGUE_LINE_PREFIX.length()).split(",", format.length);
        if (lineValues.length != format.length) {
            Log.w((String)TAG, (String)("Skipping dialogue line with fewer columns than format: " + dialogueLine));
            return;
        }
        long startTimeUs = SsaDecoder.parseTimecodeUs(lineValues[format.startTimeIndex]);
        if (startTimeUs == -9223372036854775807L) {
            Log.w((String)TAG, (String)("Skipping invalid timing: " + dialogueLine));
            return;
        }
        long endTimeUs = SsaDecoder.parseTimecodeUs(lineValues[format.endTimeIndex]);
        if (endTimeUs == -9223372036854775807L) {
            Log.w((String)TAG, (String)("Skipping invalid timing: " + dialogueLine));
            return;
        }
        SsaStyle style = this.styles != null && format.styleIndex != -1 ? this.styles.get(lineValues[format.styleIndex].trim()) : null;
        String rawText = lineValues[format.textIndex];
        SsaStyle.Overrides styleOverrides = SsaStyle.Overrides.parseFromDialogue(rawText);
        String text = SsaStyle.Overrides.stripStyleOverrides(rawText).replace("\\N", "\n").replace("\\n", "\n").replace("\\h", "\u00a0");
        Cue cue = SsaDecoder.createCue(text, style, styleOverrides, this.screenWidth, this.screenHeight);
        int startTimeIndex = SsaDecoder.addCuePlacerholderByTime(startTimeUs, cueTimesUs, cues);
        int endTimeIndex = SsaDecoder.addCuePlacerholderByTime(endTimeUs, cueTimesUs, cues);
        for (int i = startTimeIndex; i < endTimeIndex; ++i) {
            cues.get(i).add(cue);
        }
    }

    private static long parseTimecodeUs(String timeString) {
        Matcher matcher = SSA_TIMECODE_PATTERN.matcher(timeString.trim());
        if (!matcher.matches()) {
            return -9223372036854775807L;
        }
        long timestampUs = Long.parseLong((String)Util.castNonNull((Object)matcher.group(1))) * 60L * 60L * 1000000L;
        timestampUs += Long.parseLong((String)Util.castNonNull((Object)matcher.group(2))) * 60L * 1000000L;
        timestampUs += Long.parseLong((String)Util.castNonNull((Object)matcher.group(3))) * 1000000L;
        return timestampUs += Long.parseLong((String)Util.castNonNull((Object)matcher.group(4))) * 10000L;
    }

    private static Cue createCue(String text, @Nullable SsaStyle style, SsaStyle.Overrides styleOverrides, float screenWidth, float screenHeight) {
        SpannableString spannableText = new SpannableString((CharSequence)text);
        Cue.Builder cue = new Cue.Builder().setText((CharSequence)spannableText);
        if (style != null) {
            if (style.primaryColor != null) {
                spannableText.setSpan((Object)new ForegroundColorSpan(style.primaryColor.intValue()), 0, spannableText.length(), 33);
            }
            if (style.borderStyle == 3 && style.outlineColor != null) {
                spannableText.setSpan((Object)new BackgroundColorSpan(style.outlineColor.intValue()), 0, spannableText.length(), 33);
            }
            if (style.fontSize != -3.4028235E38f && screenHeight != -3.4028235E38f) {
                cue.setTextSize(style.fontSize / screenHeight, 1);
            }
            if (style.bold && style.italic) {
                spannableText.setSpan((Object)new StyleSpan(3), 0, spannableText.length(), 33);
            } else if (style.bold) {
                spannableText.setSpan((Object)new StyleSpan(1), 0, spannableText.length(), 33);
            } else if (style.italic) {
                spannableText.setSpan((Object)new StyleSpan(2), 0, spannableText.length(), 33);
            }
            if (style.underline) {
                spannableText.setSpan((Object)new UnderlineSpan(), 0, spannableText.length(), 33);
            }
            if (style.strikeout) {
                spannableText.setSpan((Object)new StrikethroughSpan(), 0, spannableText.length(), 33);
            }
        }
        int alignment = styleOverrides.alignment != -1 ? styleOverrides.alignment : (style != null ? style.alignment : -1);
        cue.setTextAlignment(SsaDecoder.toTextAlignment(alignment)).setPositionAnchor(SsaDecoder.toPositionAnchor(alignment)).setLineAnchor(SsaDecoder.toLineAnchor(alignment));
        if (styleOverrides.position != null && screenHeight != -3.4028235E38f && screenWidth != -3.4028235E38f) {
            cue.setPosition(styleOverrides.position.x / screenWidth);
            cue.setLine(styleOverrides.position.y / screenHeight, 0);
        } else {
            cue.setPosition(SsaDecoder.computeDefaultLineOrPosition(cue.getPositionAnchor()));
            cue.setLine(SsaDecoder.computeDefaultLineOrPosition(cue.getLineAnchor()), 0);
        }
        return cue.build();
    }

    @Nullable
    private static Layout.Alignment toTextAlignment(int alignment) {
        switch (alignment) {
            case 1: 
            case 4: 
            case 7: {
                return Layout.Alignment.ALIGN_NORMAL;
            }
            case 2: 
            case 5: 
            case 8: {
                return Layout.Alignment.ALIGN_CENTER;
            }
            case 3: 
            case 6: 
            case 9: {
                return Layout.Alignment.ALIGN_OPPOSITE;
            }
            case -1: {
                return null;
            }
        }
        Log.w((String)TAG, (String)("Unknown alignment: " + alignment));
        return null;
    }

    private static int toLineAnchor(int alignment) {
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: 
            case 8: 
            case 9: {
                return 0;
            }
            case -1: {
                return Integer.MIN_VALUE;
            }
        }
        Log.w((String)TAG, (String)("Unknown alignment: " + alignment));
        return Integer.MIN_VALUE;
    }

    private static int toPositionAnchor(int alignment) {
        switch (alignment) {
            case 1: 
            case 4: 
            case 7: {
                return 0;
            }
            case 2: 
            case 5: 
            case 8: {
                return 1;
            }
            case 3: 
            case 6: 
            case 9: {
                return 2;
            }
            case -1: {
                return Integer.MIN_VALUE;
            }
        }
        Log.w((String)TAG, (String)("Unknown alignment: " + alignment));
        return Integer.MIN_VALUE;
    }

    private static float computeDefaultLineOrPosition(int anchor) {
        switch (anchor) {
            case 0: {
                return 0.05f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 0.95f;
            }
        }
        return -3.4028235E38f;
    }

    private static int addCuePlacerholderByTime(long timeUs, List<Long> sortedCueTimesUs, List<List<Cue>> cues) {
        int insertionIndex = 0;
        for (int i = sortedCueTimesUs.size() - 1; i >= 0; --i) {
            if (sortedCueTimesUs.get(i) == timeUs) {
                return i;
            }
            if (sortedCueTimesUs.get(i) >= timeUs) continue;
            insertionIndex = i + 1;
            break;
        }
        sortedCueTimesUs.add(insertionIndex, timeUs);
        cues.add(insertionIndex, insertionIndex == 0 ? new ArrayList() : new ArrayList(cues.get(insertionIndex - 1)));
        return insertionIndex;
    }
}

