/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Collections;
import java.util.List;

@Deprecated
public final class HevcConfig {
    private static final int SPS_NAL_UNIT_TYPE = 33;
    public final List<byte[]> initializationData;
    public final int nalUnitLengthFieldLength;
    public final int width;
    public final int height;
    public final int colorSpace;
    public final int colorRange;
    public final int colorTransfer;
    public final float pixelWidthHeightRatio;
    @Nullable
    public final String codecs;

    public static HevcConfig parse(ParsableByteArray data) throws ParserException {
        try {
            data.skipBytes(21);
            int lengthSizeMinusOne = data.readUnsignedByte() & 3;
            int numberOfArrays = data.readUnsignedByte();
            int csdLength = 0;
            int csdStartPosition = data.getPosition();
            for (int i = 0; i < numberOfArrays; ++i) {
                data.skipBytes(1);
                int numberOfNalUnits = data.readUnsignedShort();
                for (int j = 0; j < numberOfNalUnits; ++j) {
                    int nalUnitLength = data.readUnsignedShort();
                    csdLength += 4 + nalUnitLength;
                    data.skipBytes(nalUnitLength);
                }
            }
            data.setPosition(csdStartPosition);
            byte[] buffer = new byte[csdLength];
            int bufferPosition = 0;
            int width = -1;
            int height = -1;
            int colorSpace = -1;
            int colorRange = -1;
            int colorTransfer = -1;
            float pixelWidthHeightRatio = 1.0f;
            String codecs = null;
            for (int i = 0; i < numberOfArrays; ++i) {
                int nalUnitType = data.readUnsignedByte() & 0x3F;
                int numberOfNalUnits = data.readUnsignedShort();
                for (int j = 0; j < numberOfNalUnits; ++j) {
                    int nalUnitLength = data.readUnsignedShort();
                    System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, buffer, bufferPosition, NalUnitUtil.NAL_START_CODE.length);
                    System.arraycopy(data.getData(), data.getPosition(), buffer, bufferPosition += NalUnitUtil.NAL_START_CODE.length, nalUnitLength);
                    if (nalUnitType == 33 && j == 0) {
                        NalUnitUtil.H265SpsData spsData = NalUnitUtil.parseH265SpsNalUnit((byte[])buffer, (int)bufferPosition, (int)(bufferPosition + nalUnitLength));
                        width = spsData.width;
                        height = spsData.height;
                        colorSpace = spsData.colorSpace;
                        colorRange = spsData.colorRange;
                        colorTransfer = spsData.colorTransfer;
                        pixelWidthHeightRatio = spsData.pixelWidthHeightRatio;
                        codecs = CodecSpecificDataUtil.buildHevcCodecString((int)spsData.generalProfileSpace, (boolean)spsData.generalTierFlag, (int)spsData.generalProfileIdc, (int)spsData.generalProfileCompatibilityFlags, (int[])spsData.constraintBytes, (int)spsData.generalLevelIdc);
                    }
                    bufferPosition += nalUnitLength;
                    data.skipBytes(nalUnitLength);
                }
            }
            List<byte[]> initializationData = csdLength == 0 ? Collections.emptyList() : Collections.singletonList(buffer);
            return new HevcConfig(initializationData, lengthSizeMinusOne + 1, width, height, colorSpace, colorRange, colorTransfer, pixelWidthHeightRatio, codecs);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ParserException.createForMalformedContainer((String)"Error parsing HEVC config", (Throwable)e);
        }
    }

    private HevcConfig(List<byte[]> initializationData, int nalUnitLengthFieldLength, int width, int height, int colorSpace, int colorRange, int colorTransfer, float pixelWidthHeightRatio, @Nullable String codecs) {
        this.initializationData = initializationData;
        this.nalUnitLengthFieldLength = nalUnitLengthFieldLength;
        this.width = width;
        this.height = height;
        this.colorSpace = colorSpace;
        this.colorRange = colorRange;
        this.colorTransfer = colorTransfer;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.codecs = codecs;
    }
}

