/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.StyledPlayerControlView;
import java.util.ArrayList;
import java.util.List;

final class StyledPlayerControlViewLayoutManager {
    private static final long ANIMATION_INTERVAL_MS = 2000L;
    private static final long DURATION_FOR_HIDING_ANIMATION_MS = 250L;
    private static final long DURATION_FOR_SHOWING_ANIMATION_MS = 250L;
    private static final int UX_STATE_ALL_VISIBLE = 0;
    private static final int UX_STATE_ONLY_PROGRESS_VISIBLE = 1;
    private static final int UX_STATE_NONE_VISIBLE = 2;
    private static final int UX_STATE_ANIMATING_HIDE = 3;
    private static final int UX_STATE_ANIMATING_SHOW = 4;
    private final StyledPlayerControlView playerControlView;
    @Nullable
    private final View controlsBackground;
    @Nullable
    private final ViewGroup centerControls;
    @Nullable
    private final ViewGroup bottomBar;
    @Nullable
    private final ViewGroup minimalControls;
    @Nullable
    private final ViewGroup basicControls;
    @Nullable
    private final ViewGroup extraControls;
    @Nullable
    private final ViewGroup extraControlsScrollView;
    @Nullable
    private final ViewGroup timeView;
    @Nullable
    private final View timeBar;
    @Nullable
    private final View overflowShowButton;
    private final AnimatorSet hideMainBarAnimator;
    private final AnimatorSet hideProgressBarAnimator;
    private final AnimatorSet hideAllBarsAnimator;
    private final AnimatorSet showMainBarAnimator;
    private final AnimatorSet showAllBarsAnimator;
    private final ValueAnimator overflowShowAnimator;
    private final ValueAnimator overflowHideAnimator;
    private final Runnable showAllBarsRunnable;
    private final Runnable hideAllBarsRunnable;
    private final Runnable hideProgressBarRunnable;
    private final Runnable hideMainBarRunnable;
    private final Runnable hideControllerRunnable;
    private final View.OnLayoutChangeListener onLayoutChangeListener;
    private final List<View> shownButtons;
    private int uxState;
    private boolean isMinimalMode;
    private boolean needToShowBars;
    private boolean animationEnabled;

    public StyledPlayerControlViewLayoutManager(final StyledPlayerControlView playerControlView) {
        this.playerControlView = playerControlView;
        this.showAllBarsRunnable = this::showAllBars;
        this.hideAllBarsRunnable = this::hideAllBars;
        this.hideProgressBarRunnable = this::hideProgressBar;
        this.hideMainBarRunnable = this::hideMainBar;
        this.hideControllerRunnable = this::hideController;
        this.onLayoutChangeListener = this::onLayoutChange;
        this.animationEnabled = true;
        this.uxState = 0;
        this.shownButtons = new ArrayList<View>();
        this.controlsBackground = playerControlView.findViewById(R.id.exo_controls_background);
        this.centerControls = (ViewGroup)playerControlView.findViewById(R.id.exo_center_controls);
        this.minimalControls = (ViewGroup)playerControlView.findViewById(R.id.exo_minimal_controls);
        this.bottomBar = (ViewGroup)playerControlView.findViewById(R.id.exo_bottom_bar);
        this.timeView = (ViewGroup)playerControlView.findViewById(R.id.exo_time);
        this.timeBar = playerControlView.findViewById(R.id.exo_progress);
        this.basicControls = (ViewGroup)playerControlView.findViewById(R.id.exo_basic_controls);
        this.extraControls = (ViewGroup)playerControlView.findViewById(R.id.exo_extra_controls);
        this.extraControlsScrollView = (ViewGroup)playerControlView.findViewById(R.id.exo_extra_controls_scroll_view);
        this.overflowShowButton = playerControlView.findViewById(R.id.exo_overflow_show);
        View overflowHideButton = playerControlView.findViewById(R.id.exo_overflow_hide);
        if (this.overflowShowButton != null && overflowHideButton != null) {
            this.overflowShowButton.setOnClickListener(this::onOverflowButtonClick);
            overflowHideButton.setOnClickListener(this::onOverflowButtonClick);
        }
        ValueAnimator fadeOutAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        fadeOutAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeOutAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            if (this.controlsBackground != null) {
                this.controlsBackground.setAlpha(animatedValue);
            }
            if (this.centerControls != null) {
                this.centerControls.setAlpha(animatedValue);
            }
            if (this.minimalControls != null) {
                this.minimalControls.setAlpha(animatedValue);
            }
        });
        fadeOutAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.timeBar instanceof DefaultTimeBar && !StyledPlayerControlViewLayoutManager.this.isMinimalMode) {
                    ((DefaultTimeBar)StyledPlayerControlViewLayoutManager.this.timeBar).hideScrubber(250L);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.controlsBackground != null) {
                    StyledPlayerControlViewLayoutManager.this.controlsBackground.setVisibility(4);
                }
                if (StyledPlayerControlViewLayoutManager.this.centerControls != null) {
                    StyledPlayerControlViewLayoutManager.this.centerControls.setVisibility(4);
                }
                if (StyledPlayerControlViewLayoutManager.this.minimalControls != null) {
                    StyledPlayerControlViewLayoutManager.this.minimalControls.setVisibility(4);
                }
            }
        });
        ValueAnimator fadeInAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        fadeInAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeInAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            if (this.controlsBackground != null) {
                this.controlsBackground.setAlpha(animatedValue);
            }
            if (this.centerControls != null) {
                this.centerControls.setAlpha(animatedValue);
            }
            if (this.minimalControls != null) {
                this.minimalControls.setAlpha(animatedValue);
            }
        });
        fadeInAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.controlsBackground != null) {
                    StyledPlayerControlViewLayoutManager.this.controlsBackground.setVisibility(0);
                }
                if (StyledPlayerControlViewLayoutManager.this.centerControls != null) {
                    StyledPlayerControlViewLayoutManager.this.centerControls.setVisibility(0);
                }
                if (StyledPlayerControlViewLayoutManager.this.minimalControls != null) {
                    StyledPlayerControlViewLayoutManager.this.minimalControls.setVisibility(StyledPlayerControlViewLayoutManager.this.isMinimalMode ? 0 : 4);
                }
                if (StyledPlayerControlViewLayoutManager.this.timeBar instanceof DefaultTimeBar && !StyledPlayerControlViewLayoutManager.this.isMinimalMode) {
                    ((DefaultTimeBar)StyledPlayerControlViewLayoutManager.this.timeBar).showScrubber(250L);
                }
            }
        });
        Resources resources = playerControlView.getResources();
        float translationYForProgressBar = resources.getDimension(R.dimen.exo_styled_bottom_bar_height) - resources.getDimension(R.dimen.exo_styled_progress_bar_height);
        float translationYForNoBars = resources.getDimension(R.dimen.exo_styled_bottom_bar_height);
        this.hideMainBarAnimator = new AnimatorSet();
        this.hideMainBarAnimator.setDuration(250L);
        this.hideMainBarAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(1);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    playerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideMainBarAnimator.play((Animator)fadeOutAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, translationYForProgressBar, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, translationYForProgressBar, (View)this.bottomBar));
        this.hideProgressBarAnimator = new AnimatorSet();
        this.hideProgressBarAnimator.setDuration(250L);
        this.hideProgressBarAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(2);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    playerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideProgressBarAnimator.play((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(translationYForProgressBar, translationYForNoBars, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(translationYForProgressBar, translationYForNoBars, (View)this.bottomBar));
        this.hideAllBarsAnimator = new AnimatorSet();
        this.hideAllBarsAnimator.setDuration(250L);
        this.hideAllBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(2);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    playerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideAllBarsAnimator.play((Animator)fadeOutAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, translationYForNoBars, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, translationYForNoBars, (View)this.bottomBar));
        this.showMainBarAnimator = new AnimatorSet();
        this.showMainBarAnimator.setDuration(250L);
        this.showMainBarAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(4);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(0);
            }
        });
        this.showMainBarAnimator.play((Animator)fadeInAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(translationYForProgressBar, 0.0f, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(translationYForProgressBar, 0.0f, (View)this.bottomBar));
        this.showAllBarsAnimator = new AnimatorSet();
        this.showAllBarsAnimator.setDuration(250L);
        this.showAllBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(4);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(0);
            }
        });
        this.showAllBarsAnimator.play((Animator)fadeInAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(translationYForNoBars, 0.0f, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(translationYForNoBars, 0.0f, (View)this.bottomBar));
        this.overflowShowAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.overflowShowAnimator.setDuration(250L);
        this.overflowShowAnimator.addUpdateListener(animation -> this.animateOverflow(((Float)animation.getAnimatedValue()).floatValue()));
        this.overflowShowAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.extraControlsScrollView != null) {
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setVisibility(0);
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setTranslationX((float)StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.getWidth());
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.scrollTo(StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.getWidth(), 0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.basicControls != null) {
                    StyledPlayerControlViewLayoutManager.this.basicControls.setVisibility(4);
                }
            }
        });
        this.overflowHideAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.overflowHideAnimator.setDuration(250L);
        this.overflowHideAnimator.addUpdateListener(animation -> this.animateOverflow(((Float)animation.getAnimatedValue()).floatValue()));
        this.overflowHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.basicControls != null) {
                    StyledPlayerControlViewLayoutManager.this.basicControls.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.extraControlsScrollView != null) {
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setVisibility(4);
                }
            }
        });
    }

    public void show() {
        if (!this.playerControlView.isVisible()) {
            this.playerControlView.setVisibility(0);
            this.playerControlView.updateAll();
            this.playerControlView.requestPlayPauseFocus();
        }
        this.showAllBars();
    }

    public void hide() {
        if (this.uxState == 3 || this.uxState == 2) {
            return;
        }
        this.removeHideCallbacks();
        if (!this.animationEnabled) {
            this.hideController();
        } else if (this.uxState == 1) {
            this.hideProgressBar();
        } else {
            this.hideAllBars();
        }
    }

    public void hideImmediately() {
        if (this.uxState == 3 || this.uxState == 2) {
            return;
        }
        this.removeHideCallbacks();
        this.hideController();
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void resetHideCallbacks() {
        if (this.uxState == 3) {
            return;
        }
        this.removeHideCallbacks();
        int showTimeoutMs = this.playerControlView.getShowTimeoutMs();
        if (showTimeoutMs > 0) {
            if (!this.animationEnabled) {
                this.postDelayedRunnable(this.hideControllerRunnable, showTimeoutMs);
            } else if (this.uxState == 1) {
                this.postDelayedRunnable(this.hideProgressBarRunnable, 2000L);
            } else {
                this.postDelayedRunnable(this.hideMainBarRunnable, showTimeoutMs);
            }
        }
    }

    public void removeHideCallbacks() {
        this.playerControlView.removeCallbacks(this.hideControllerRunnable);
        this.playerControlView.removeCallbacks(this.hideAllBarsRunnable);
        this.playerControlView.removeCallbacks(this.hideMainBarRunnable);
        this.playerControlView.removeCallbacks(this.hideProgressBarRunnable);
    }

    public void onAttachedToWindow() {
        this.playerControlView.addOnLayoutChangeListener(this.onLayoutChangeListener);
    }

    public void onDetachedFromWindow() {
        this.playerControlView.removeOnLayoutChangeListener(this.onLayoutChangeListener);
    }

    public boolean isFullyVisible() {
        return this.uxState == 0 && this.playerControlView.isVisible();
    }

    public void setShowButton(@Nullable View button, boolean showButton) {
        if (button == null) {
            return;
        }
        if (!showButton) {
            button.setVisibility(8);
            this.shownButtons.remove(button);
            return;
        }
        if (this.isMinimalMode && this.shouldHideInMinimalMode(button)) {
            button.setVisibility(4);
        } else {
            button.setVisibility(0);
        }
        this.shownButtons.add(button);
    }

    public boolean getShowButton(@Nullable View button) {
        return button != null && this.shownButtons.contains(button);
    }

    private void setUxState(int uxState) {
        int prevUxState = this.uxState;
        this.uxState = uxState;
        if (uxState == 2) {
            this.playerControlView.setVisibility(8);
        } else if (prevUxState == 2) {
            this.playerControlView.setVisibility(0);
        }
        if (prevUxState != uxState) {
            this.playerControlView.notifyOnVisibilityChange();
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.controlsBackground != null) {
            this.controlsBackground.layout(0, 0, right - left, bottom - top);
        }
    }

    private void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        boolean widthChanged;
        boolean useMinimalMode = this.useMinimalMode();
        if (this.isMinimalMode != useMinimalMode) {
            this.isMinimalMode = useMinimalMode;
            v.post(this::updateLayoutForSizeChange);
        }
        boolean bl = widthChanged = right - left != oldRight - oldLeft;
        if (!this.isMinimalMode && widthChanged) {
            v.post(this::onLayoutWidthChanged);
        }
    }

    private void onOverflowButtonClick(View v) {
        this.resetHideCallbacks();
        if (v.getId() == R.id.exo_overflow_show) {
            this.overflowShowAnimator.start();
        } else if (v.getId() == R.id.exo_overflow_hide) {
            this.overflowHideAnimator.start();
        }
    }

    private void showAllBars() {
        if (!this.animationEnabled) {
            this.setUxState(0);
            this.resetHideCallbacks();
            return;
        }
        switch (this.uxState) {
            case 2: {
                this.showAllBarsAnimator.start();
                break;
            }
            case 1: {
                this.showMainBarAnimator.start();
                break;
            }
            case 3: {
                this.needToShowBars = true;
                break;
            }
            case 4: {
                return;
            }
        }
        this.resetHideCallbacks();
    }

    private void hideAllBars() {
        this.hideAllBarsAnimator.start();
    }

    private void hideProgressBar() {
        this.hideProgressBarAnimator.start();
    }

    private void hideMainBar() {
        this.hideMainBarAnimator.start();
        this.postDelayedRunnable(this.hideProgressBarRunnable, 2000L);
    }

    private void hideController() {
        this.setUxState(2);
    }

    private static ObjectAnimator ofTranslationY(float startValue, float endValue, View target) {
        return ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{startValue, endValue});
    }

    private void postDelayedRunnable(Runnable runnable, long interval) {
        if (interval >= 0L) {
            this.playerControlView.postDelayed(runnable, interval);
        }
    }

    private void animateOverflow(float animatedValue) {
        if (this.extraControlsScrollView != null) {
            int extraControlTranslationX = (int)((float)this.extraControlsScrollView.getWidth() * (1.0f - animatedValue));
            this.extraControlsScrollView.setTranslationX((float)extraControlTranslationX);
        }
        if (this.timeView != null) {
            this.timeView.setAlpha(1.0f - animatedValue);
        }
        if (this.basicControls != null) {
            this.basicControls.setAlpha(1.0f - animatedValue);
        }
    }

    private boolean useMinimalMode() {
        int width = this.playerControlView.getWidth() - this.playerControlView.getPaddingLeft() - this.playerControlView.getPaddingRight();
        int height = this.playerControlView.getHeight() - this.playerControlView.getPaddingBottom() - this.playerControlView.getPaddingTop();
        int centerControlWidth = StyledPlayerControlViewLayoutManager.getWidthWithMargins((View)this.centerControls) - (this.centerControls != null ? this.centerControls.getPaddingLeft() + this.centerControls.getPaddingRight() : 0);
        int centerControlHeight = StyledPlayerControlViewLayoutManager.getHeightWithMargins((View)this.centerControls) - (this.centerControls != null ? this.centerControls.getPaddingTop() + this.centerControls.getPaddingBottom() : 0);
        int defaultModeMinimumWidth = Math.max(centerControlWidth, StyledPlayerControlViewLayoutManager.getWidthWithMargins((View)this.timeView) + StyledPlayerControlViewLayoutManager.getWidthWithMargins(this.overflowShowButton));
        int defaultModeMinimumHeight = centerControlHeight + 2 * StyledPlayerControlViewLayoutManager.getHeightWithMargins((View)this.bottomBar);
        return width <= defaultModeMinimumWidth || height <= defaultModeMinimumHeight;
    }

    private void updateLayoutForSizeChange() {
        if (this.minimalControls != null) {
            this.minimalControls.setVisibility(this.isMinimalMode ? 0 : 4);
        }
        if (this.timeBar != null) {
            int timeBarMarginBottom = this.playerControlView.getResources().getDimensionPixelSize(R.dimen.exo_styled_progress_margin_bottom);
            ViewGroup.MarginLayoutParams timeBarParams = (ViewGroup.MarginLayoutParams)this.timeBar.getLayoutParams();
            if (timeBarParams != null) {
                timeBarParams.bottomMargin = this.isMinimalMode ? 0 : timeBarMarginBottom;
                this.timeBar.setLayoutParams((ViewGroup.LayoutParams)timeBarParams);
            }
            if (this.timeBar instanceof DefaultTimeBar) {
                DefaultTimeBar defaultTimeBar = (DefaultTimeBar)this.timeBar;
                if (this.isMinimalMode) {
                    defaultTimeBar.hideScrubber(true);
                } else if (this.uxState == 1) {
                    defaultTimeBar.hideScrubber(false);
                } else if (this.uxState != 3) {
                    defaultTimeBar.showScrubber();
                }
            }
        }
        for (View v : this.shownButtons) {
            v.setVisibility(this.isMinimalMode && this.shouldHideInMinimalMode(v) ? 4 : 0);
        }
    }

    private boolean shouldHideInMinimalMode(View button) {
        int id2 = button.getId();
        return id2 == R.id.exo_bottom_bar || id2 == R.id.exo_prev || id2 == R.id.exo_next || id2 == R.id.exo_rew || id2 == R.id.exo_rew_with_amount || id2 == R.id.exo_ffwd || id2 == R.id.exo_ffwd_with_amount;
    }

    private void onLayoutWidthChanged() {
        if (this.basicControls == null || this.extraControls == null) {
            return;
        }
        int width = this.playerControlView.getWidth() - this.playerControlView.getPaddingLeft() - this.playerControlView.getPaddingRight();
        while (this.extraControls.getChildCount() > 1) {
            int controlViewIndex = this.extraControls.getChildCount() - 2;
            View controlView = this.extraControls.getChildAt(controlViewIndex);
            this.extraControls.removeViewAt(controlViewIndex);
            this.basicControls.addView(controlView, 0);
        }
        if (this.overflowShowButton != null) {
            this.overflowShowButton.setVisibility(8);
        }
        int occupiedWidth = StyledPlayerControlViewLayoutManager.getWidthWithMargins((View)this.timeView);
        int endIndex = this.basicControls.getChildCount() - 1;
        for (int i = 0; i < endIndex; ++i) {
            View controlView = this.basicControls.getChildAt(i);
            occupiedWidth += StyledPlayerControlViewLayoutManager.getWidthWithMargins(controlView);
        }
        if (occupiedWidth > width) {
            int i;
            if (this.overflowShowButton != null) {
                this.overflowShowButton.setVisibility(0);
                occupiedWidth += StyledPlayerControlViewLayoutManager.getWidthWithMargins(this.overflowShowButton);
            }
            ArrayList<View> controlsToMove = new ArrayList<View>();
            for (i = 0; i < endIndex; ++i) {
                View control = this.basicControls.getChildAt(i);
                controlsToMove.add(control);
                if ((occupiedWidth -= StyledPlayerControlViewLayoutManager.getWidthWithMargins(control)) <= width) break;
            }
            if (!controlsToMove.isEmpty()) {
                this.basicControls.removeViews(0, controlsToMove.size());
                for (i = 0; i < controlsToMove.size(); ++i) {
                    int index = this.extraControls.getChildCount() - 1;
                    this.extraControls.addView((View)controlsToMove.get(i), index);
                }
            }
        } else if (this.extraControlsScrollView != null && this.extraControlsScrollView.getVisibility() == 0 && !this.overflowHideAnimator.isStarted()) {
            this.overflowShowAnimator.cancel();
            this.overflowHideAnimator.start();
        }
    }

    private static int getWidthWithMargins(@Nullable View v) {
        if (v == null) {
            return 0;
        }
        int width = v.getWidth();
        ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            width += marginLayoutParams.leftMargin + marginLayoutParams.rightMargin;
        }
        return width;
    }

    private static int getHeightWithMargins(@Nullable View v) {
        if (v == null) {
            return 0;
        }
        int height = v.getHeight();
        ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            height += marginLayoutParams.topMargin + marginLayoutParams.bottomMargin;
        }
        return height;
    }
}

