/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.aa;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler tL;
    private final Tracker tM;
    private final Context mContext;
    private ExceptionParser tN;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.tL = originalHandler;
        this.tM = tracker;
        this.tN = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        aa.C("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.tN;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.tN = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e2) {
        String string = "UncaughtException";
        if (this.tN != null) {
            String string2 = t2 != null ? t2.getName() : null;
            string = this.tN.getDescription(string2, e2);
        }
        aa.C("Tracking Exception: " + string);
        this.tM.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        if (this.tL != null) {
            aa.C("Passing exception to original handler.");
            this.tL.uncaughtException(t2, e2);
        }
    }

    Thread.UncaughtExceptionHandler cy() {
        return this.tL;
    }
}

