/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ab;
import com.google.android.gms.analytics.ah;
import com.google.android.gms.analytics.d;
import com.google.android.gms.analytics.e;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.n;
import com.google.android.gms.analytics.p;
import com.google.android.gms.analytics.x;
import com.google.android.gms.analytics.y;
import com.google.android.gms.internal.fe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class ac
implements d {
    private static final String wM = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private final a wN;
    private volatile n wO;
    private final e tZ;
    private final Context mContext;
    private final String wP;
    private ab wQ;
    private long wR;
    private final int wS;
    private i ur;

    ac(e e2, Context context) {
        this(e2, context, "google_analytics_v4.db", 2000);
    }

    ac(e e2, Context context, String string, int n2) {
        this.mContext = context.getApplicationContext();
        this.wP = string;
        this.tZ = e2;
        this.ur = new i(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.wN = new a(this.mContext, this.wP);
        this.wO = new ah((HttpClient)new DefaultHttpClient(), this.mContext);
        this.wR = 0L;
        this.wS = n2;
    }

    @Override
    public void l(long l2) {
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for clearHits");
        if (sQLiteDatabase != null) {
            if (l2 == 0L) {
                sQLiteDatabase.delete("hits2", null, null);
            } else {
                String[] stringArray = new String[]{Long.valueOf(l2).toString()};
                sQLiteDatabase.delete("hits2", "hit_app_id = ?", stringArray);
            }
            this.tZ.s(this.do() == 0);
        }
    }

    @Override
    public void a(Map<String, String> map, long l2, String string, Collection<fe> collection) {
        this.dn();
        this.dm();
        this.a(map, collection);
        this.a(map, l2, string);
    }

    private void a(Map<String, String> map, Collection<fe> collection) {
        String string = "&_v".substring(1);
        if (collection != null) {
            for (fe fe2 : collection) {
                if (!"appendVersion".equals(fe2.getId())) continue;
                map.put(string, fe2.getValue());
                break;
            }
        }
    }

    private void dm() {
        int n2 = this.do() - this.wS + 1;
        if (n2 > 0) {
            List<String> list = this.A(n2);
            aa.C("Store full, deleting " + list.size() + " hits to make room.");
            this.a(list.toArray(new String[0]));
        }
    }

    private void a(Map<String, String> map, long l2, String string) {
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", ac.v(map));
        contentValues.put("hit_time", Long.valueOf(l2));
        long l3 = 0L;
        if (map.containsKey("AppUID")) {
            try {
                l3 = Long.parseLong(map.get("AppUID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        contentValues.put("hit_app_id", Long.valueOf(l3));
        if (string == null) {
            string = "http://www.google-analytics.com/collect";
        }
        if (string.length() == 0) {
            aa.D("Empty path: not sending hit");
            return;
        }
        contentValues.put("hit_url", string);
        try {
            sQLiteDatabase.insert("hits2", null, contentValues);
            this.tZ.s(false);
        }
        catch (SQLiteException sQLiteException) {
            aa.D("Error storing hit");
        }
    }

    static String v(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(y.encode(entry.getKey()) + "=" + y.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> A(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            aa.D("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<x> B(int n2) {
        ArrayList<x> arrayList = new ArrayList<x>();
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    x x2 = new x(null, cursor.getLong(0), cursor.getLong(1));
                    arrayList.add(x2);
                } while (cursor.moveToNext());
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_string", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((x)arrayList.get(n3)).Q(cursor.getString(1));
                        ((x)arrayList.get(n3)).R(cursor.getString(2));
                    } else {
                        aa.D(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((x)arrayList.get(n3)).dg()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            aa.D("Error in peekHits fetching hitString: " + sQLiteException.getMessage());
            ArrayList<x> arrayList2 = new ArrayList<x>();
            boolean bl2 = false;
            for (x x3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)x3.df())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList2.add(x3);
            }
            ArrayList<x> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int dn() {
        long l2 = this.ur.currentTimeMillis();
        if (l2 <= this.wR + 86400000L) {
            return 0;
        }
        this.wR = l2;
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.ur.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("hits2", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.tZ.s(this.do() == 0);
        return n2;
    }

    @Deprecated
    void b(Collection<x> collection) {
        if (collection == null || collection.isEmpty()) {
            aa.D("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (x x2 : collection) {
            stringArray[n2++] = String.valueOf(x2.dg());
        }
        this.a(stringArray);
    }

    void a(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            aa.D("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("hits2", string, stringArray);
            this.tZ.s(this.do() == 0);
        }
        catch (SQLiteException sQLiteException) {
            aa.D("Error deleting hits " + stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int do() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.S("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        return n2;
    }

    @Override
    public void cl() {
        int n2;
        aa.C("Dispatch running...");
        if (!this.wO.cx()) {
            return;
        }
        List<x> list = this.B(40);
        if (list.isEmpty()) {
            aa.C("...nothing to dispatch");
            this.tZ.s(true);
            return;
        }
        if (this.wQ == null) {
            this.wQ = new ab("_t=dispatch&_v=ma4.0.2", true);
        }
        boolean bl2 = (n2 = this.do()) <= list.size();
        int n3 = this.wO.a(list, this.wQ, bl2);
        aa.C("sent " + n3 + " of " + list.size() + " hits");
        this.b(list.subList(0, Math.min(n3, list.size())));
        if (n3 == list.size() && this.do() > 0) {
            GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        } else {
            this.wQ = null;
        }
    }

    @Override
    public n cm() {
        return this.wO;
    }

    private SQLiteDatabase S(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.wN.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            aa.D(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class a
    extends SQLiteOpenHelper {
        private boolean wU;
        private long wV;

        a(Context context, String string) {
            super(context, string, null, 1);
            this.wV = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.wU && this.wV + 3600000L > ac.this.ur.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.wU = true;
            this.wV = ac.this.ur.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                ac.this.mContext.getDatabasePath(ac.this.wP).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.wU = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.a("hits2", db2)) {
                db2.execSQL(wM);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            boolean bl2;
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM hits2 WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_string") && hashSet.remove("hit_time"))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl3 = bl2 = !hashSet.remove("hit_app_id");
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (bl2) {
                sQLiteDatabase.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            p.N(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }
}

