/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.internal.gj;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    private long AG;
    private MediaInfo Ay;
    private double AH;
    private int AI;
    private int AJ;
    private long AK;
    private long AL;
    private double AM;
    private boolean AN;
    private long[] AO;
    private JSONObject Ax;

    public MediaStatus(JSONObject json) throws JSONException {
        this.a(json, 0);
    }

    public long dV() {
        return this.AG;
    }

    public int getPlayerState() {
        return this.AI;
    }

    public int getIdleReason() {
        return this.AJ;
    }

    public double getPlaybackRate() {
        return this.AH;
    }

    public MediaInfo getMediaInfo() {
        return this.Ay;
    }

    public long getStreamPosition() {
        return this.AK;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.AL & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.AM;
    }

    public boolean isMute() {
        return this.AN;
    }

    public long[] getActiveTrackIds() {
        return this.AO;
    }

    public JSONObject getCustomData() {
        return this.Ax;
    }

    public int a(JSONObject jSONObject, int n2) throws JSONException {
        int n3;
        long l2;
        long l3;
        double d2;
        int n4 = 0;
        long l4 = jSONObject.getLong("mediaSessionId");
        if (l4 != this.AG) {
            this.AG = l4;
            n4 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n5 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n5 = 1;
            } else if (string2.equals("PLAYING")) {
                n5 = 2;
            } else if (string2.equals("PAUSED")) {
                n5 = 3;
            } else if (string2.equals("BUFFERING")) {
                n5 = 4;
            }
            if (n5 != this.AI) {
                this.AI = n5;
                n4 |= 2;
            }
            if (n5 == 1 && jSONObject.has("idleReason")) {
                int n6 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n6 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n6 = 3;
                } else if (string2.equals("FINISHED")) {
                    n6 = 1;
                } else if (string2.equals("ERROR")) {
                    n6 = 4;
                }
                if (n6 != this.AJ) {
                    this.AJ = n6;
                    n4 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.AH != (d2 = jSONObject.getDouble("playbackRate"))) {
            this.AH = d2;
            n4 |= 2;
        }
        if (jSONObject.has("currentTime") && (n2 & 2) == 0 && (l3 = gj.b(jSONObject.getDouble("currentTime"))) != this.AK) {
            this.AK = l3;
            n4 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l2 = jSONObject.getLong("supportedMediaCommands")) != this.AL) {
            this.AL = l2;
            n4 |= 2;
        }
        if (jSONObject.has("volume") && (n2 & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d3 = jSONObject2.getDouble("level");
            if (d3 != this.AM) {
                this.AM = d3;
                n4 |= 2;
            }
            if ((n3 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.AN) {
                this.AN = n3;
                n4 |= 2;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n7;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n3 = jSONArray.length();
            lArray = new long[n3];
            for (n7 = 0; n7 < n3; ++n7) {
                lArray[n7] = jSONArray.getLong(n7);
            }
            if (this.AO == null) {
                bl2 = true;
            } else if (this.AO.length != n3) {
                bl2 = true;
            } else {
                for (n7 = 0; n7 < n3; ++n7) {
                    if (this.AO[n7] == lArray[n7]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                this.AO = lArray;
            }
        } else if (this.AO != null) {
            bl2 = true;
        }
        if (bl2) {
            this.AO = lArray;
            n4 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.Ax = jSONObject.getJSONObject("customData");
            n4 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.Ay = new MediaInfo(jSONObject3);
            n4 |= 2;
            if (jSONObject3.has("metadata")) {
                n4 |= 4;
            }
        }
        return n4;
    }
}

