/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.gp;
import com.google.android.gms.internal.gq;
import com.google.android.gms.internal.gr;
import java.io.IOException;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object lq = new Object();
    private final gp AT;
    private final a AU = new a();
    private OnMetadataUpdatedListener AV;
    private OnStatusUpdatedListener AW;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_CANCELED = 2;
    public static final int STATUS_TIMED_OUT = 3;
    public static final int STATUS_REPLACED = 4;

    public RemoteMediaPlayer() {
        this.AT = new gp(){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.AT.a(this.AU);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, mediaInfo, autoplay, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.b(this.Bn, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.c(this.Bn, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.b(this.l(new Status(1)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.b(this.l(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.b(this.l(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, trackIds);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(gi gi2) {
                Object object = RemoteMediaPlayer.this.lq;
                synchronized (object) {
                    RemoteMediaPlayer.this.AU.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.AT.a(this.Bn, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.AU.b(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.lq;
        synchronized (object) {
            return this.AT.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.lq;
        synchronized (object) {
            return this.AT.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.lq;
        synchronized (object) {
            return this.AT.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.lq;
        synchronized (object) {
            return this.AT.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.AW = listener;
    }

    private void onStatusUpdated() {
        if (this.AW != null) {
            this.AW.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.AV = listener;
    }

    private void onMetadataUpdated() {
        if (this.AV != null) {
            this.AV.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.AT.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.AT.ai(message);
    }

    private static abstract class b
    extends Cast.a<MediaChannelResult> {
        gr Bn = new gr(){

            @Override
            public void n(long l2) {
                b.this.b(b.this.l(new Status(4)));
            }

            @Override
            public void a(long l2, int n2, JSONObject jSONObject) {
                b.this.b(new c(new Status(n2), jSONObject));
            }
        };

        b() {
        }

        public MediaChannelResult l(final Status status) {
            return new MediaChannelResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.l(status);
        }
    }

    private static final class c
    implements MediaChannelResult {
        private final Status yw;
        private final JSONObject Ax;

        c(Status status, JSONObject jSONObject) {
            this.yw = status;
            this.Ax = jSONObject;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public JSONObject getCustomData() {
            return this.Ax;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$a
    implements gq {
        private GoogleApiClient Bj;
        private long Bk = 0L;

        public void b(GoogleApiClient googleApiClient) {
            this.Bj = googleApiClient;
        }

        @Override
        public long dW() {
            return ++this.Bk;
        }

        @Override
        public void a(String string2, String string3, long l2, String string4) throws IOException {
            if (this.Bj == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.Bj, string2, string3).setResultCallback(new a(l2));
        }

        private final class a
        implements ResultCallback<Status> {
            private final long Bl;

            a(long l2) {
                this.Bl = l2;
            }

            public void k(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.AT.a(this.Bl, status.getStatusCode());
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.k((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

