/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.c;
import com.google.android.gms.internal.hh;
import com.google.android.gms.internal.hn;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class a {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class c<R extends Result>
    extends Handler {
        public c() {
            this(Looper.getMainLooper());
        }

        public c(Looper looper) {
            super(looper);
        }

        public void a(ResultCallback<R> resultCallback, R r2) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r2)));
        }

        public void a(a<R> a2, long l2) {
            this.sendMessageDelayed(this.obtainMessage(2, a2), l2);
        }

        public void eC() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.b((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    a a2 = (a)msg.obj;
                    a2.eA();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void b(ResultCallback<R> resultCallback, R r2) {
            try {
                resultCallback.onResult(r2);
            }
            catch (RuntimeException runtimeException) {
                a.a(r2);
                throw runtimeException;
            }
        }
    }

    public static abstract class a<R extends Result>
    implements PendingResult<R>,
    d<R> {
        private final Object Dm = new Object();
        private c<R> Dn;
        private final CountDownLatch kI = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> Do = new ArrayList();
        private ResultCallback<R> Dp;
        private volatile R Dq;
        private volatile boolean Dr;
        private boolean Ds;
        private boolean Dt;
        private hh Du;

        a() {
        }

        public a(Looper looper) {
            this.Dn = new c(looper);
        }

        public a(c<R> c2) {
            this.Dn = c2;
        }

        protected abstract R c(Status var1);

        public final boolean isReady() {
            return this.kI.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R ex() {
            Object object = this.Dm;
            synchronized (object) {
                hn.a(!this.Dr, "Result has already been consumed.");
                hn.a(this.isReady(), "Result is not ready.");
                R r2 = this.Dq;
                this.ey();
                return r2;
            }
        }

        @Override
        public final R await() {
            hn.a(Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            hn.a(!this.Dr, "Result has already been consumed");
            try {
                this.kI.await();
            }
            catch (InterruptedException interruptedException) {
                this.ez();
            }
            hn.a(this.isReady(), "Result is not ready.");
            return this.ex();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            hn.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread when time is greater than zero.");
            hn.a(!this.Dr, "Result has already been consumed.");
            try {
                boolean bl2 = this.kI.await(time, units);
                if (!bl2) {
                    this.eA();
                }
            }
            catch (InterruptedException interruptedException) {
                this.ez();
            }
            hn.a(this.isReady(), "Result is not ready.");
            return this.ex();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            hn.a(!this.Dr, "Result has already been consumed.");
            Object object = this.Dm;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.Dn.a(callback, this.ex());
                } else {
                    this.Dp = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            hn.a(!this.Dr, "Result has already been consumed.");
            Object object = this.Dm;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.Dn.a(callback, this.ex());
                } else {
                    this.Dp = callback;
                    this.Dn.a(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            hn.a(!this.Dr, "Result has already been consumed.");
            Object object = this.Dm;
            synchronized (object) {
                if (this.isReady()) {
                    a2.n(this.Dq.getStatus());
                } else {
                    this.Do.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void a(hh hh2) {
            Object object = this.Dm;
            synchronized (object) {
                this.Du = hh2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.Dm;
            synchronized (object) {
                if (this.Ds || this.Dr) {
                    return;
                }
                if (this.Du != null) {
                    try {
                        this.Du.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                a.a(this.Dq);
                this.Dp = null;
                this.Ds = true;
                this.c(this.c(Status.Eo));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.Dm;
            synchronized (object) {
                return this.Ds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void b(R r2) {
            Object object = this.Dm;
            synchronized (object) {
                if (this.Dt || this.Ds) {
                    a.a(r2);
                    return;
                }
                hn.a(!this.isReady(), "Results have already been set");
                hn.a(!this.Dr, "Result has already been consumed");
                this.c(r2);
            }
        }

        protected void ey() {
            this.Dr = true;
            this.Dq = null;
            this.Dp = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ez() {
            Object object = this.Dm;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.El));
                    this.Dt = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eA() {
            Object object = this.Dm;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.En));
                    this.Dt = true;
                }
            }
        }

        private void c(R r2) {
            this.Dq = r2;
            this.Du = null;
            this.kI.countDown();
            Status status = this.Dq.getStatus();
            if (this.Dp != null) {
                this.Dn.eC();
                if (!this.Ds) {
                    this.Dn.a(this.Dp, this.ex());
                }
            }
            for (PendingResult.a a2 : this.Do) {
                a2.n(status);
            }
            this.Do.clear();
        }

        @Override
        protected void a(c<R> c2) {
            this.Dn = c2;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.b((Result)object);
        }
    }

    public static abstract class b<R extends Result, A extends Api.a>
    extends a<R>
    implements c.c<A> {
        private final Api.c<A> Dk;
        private c.a Dv;

        protected b(Api.c<A> c2) {
            this.Dk = hn.f(c2);
        }

        @Override
        public final Api.c<A> ew() {
            return this.Dk;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            this.a((A)((Object)new c(a2.getLooper())));
            try {
                this.a(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void m(Status status) {
            hn.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.c(status));
        }

        @Override
        public void a(c.a a2) {
            this.Dv = a2;
        }

        @Override
        public int eB() {
            return 0;
        }

        @Override
        protected abstract void a(A var1) throws RemoteException;

        @Override
        protected void ey() {
            super.ey();
            if (this.Dv != null) {
                this.Dv.b(this);
                this.Dv = null;
            }
        }

        @Override
        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.m(status);
        }
    }

    public static interface d<R> {
        public void a(R var1);
    }
}

