/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends d
implements Player {
    private final PlayerColumnNames Nd;
    private final PlayerLevelInfo MU;
    private final MostRecentGameInfoRef Ne;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.Nd = new PlayerColumnNames(prefix);
        this.Ne = new MostRecentGameInfoRef(holder, dataRow, this.Nd);
        if (this.gQ()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.Nd.RV);
            int n3 = this.getInteger(this.Nd.RY);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.Nd.RW), this.getLong(this.Nd.RX));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.Nd.RX), this.getLong(this.Nd.RZ));
            }
            this.MU = new PlayerLevelInfo(this.getLong(this.Nd.RU), this.getLong(this.Nd.Sa), playerLevel, playerLevel2);
        } else {
            this.MU = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.Nd.RL);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.Nd.RM);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a(this.Nd.RM, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.aw(this.Nd.RN);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.Nd.RO);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.aw(this.Nd.RP);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.Nd.RQ);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.Nd.RR);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.av(this.Nd.RT) || this.ax(this.Nd.RT)) {
            return -1L;
        }
        return this.getLong(this.Nd.RT);
    }

    @Override
    public int gN() {
        return this.getInteger(this.Nd.RS);
    }

    @Override
    public boolean gO() {
        return this.getBoolean(this.Nd.Sc);
    }

    @Override
    public String getTitle() {
        return this.getString(this.Nd.Sb);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.a(this.Nd.Sb, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.MU;
    }

    @Override
    public MostRecentGameInfo gP() {
        if (this.ax(this.Nd.Sd)) {
            return null;
        }
        return this.Ne;
    }

    @Override
    public Player freeze() {
        return new PlayerEntity(this);
    }

    @Override
    public int hashCode() {
        return PlayerEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean gQ() {
        if (this.ax(this.Nd.RU)) {
            return false;
        }
        return this.getLong(this.Nd.RU) != -1L;
    }
}

