/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.iq;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl OV;
    protected PopupLocationInfo OW;

    public static PopupManager a(GamesClientImpl gamesClientImpl, int n2) {
        if (iq.fY()) {
            return new PopupManagerHCMR1(gamesClientImpl, n2);
        }
        return new PopupManager(gamesClientImpl, n2);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.OV = gamesClientImpl;
        this.cl(gravity);
    }

    protected void cl(int n2) {
        this.OW = new PopupLocationInfo(n2, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.OW.gravity = gravity;
    }

    public void g(View view) {
    }

    public void hG() {
        this.OV.a(this.OW.OX, this.OW.hJ());
    }

    public Bundle hH() {
        return this.OW.hJ();
    }

    public IBinder hI() {
        return this.OW.OX;
    }

    public static final class PopupLocationInfo {
        public IBinder OX;
        public int gravity;
        public int OY = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.OX = windowToken;
        }

        public Bundle hJ() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.OY);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> OZ;
        private boolean Ns = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void cl(int n2) {
            this.OW = new PopupLocationInfo(n2, null);
        }

        @Override
        public void g(View view) {
            Context context;
            View view2;
            this.OV.hr();
            if (this.OZ != null) {
                view2 = (View)this.OZ.get();
                context = this.OV.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (iq.gb()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.OZ = null;
            view2 = this.OV.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.j("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view which may not work properly in future versions of the API. Use setViewForPopups() to set your content view.");
            }
            if (view != null) {
                this.h(view);
                this.OZ = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.k("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void hG() {
            if (this.OW.OX != null) {
                super.hG();
                return;
            }
            this.Ns = this.OZ != null;
        }

        public void onViewAttachedToWindow(View v2) {
            this.h(v2);
        }

        public void onViewDetachedFromWindow(View v2) {
            this.OV.hr();
            v2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.OZ == null) {
                return;
            }
            View view = (View)this.OZ.get();
            if (view == null) {
                return;
            }
            this.h(view);
        }

        private void h(View view) {
            Display display;
            int n2 = -1;
            if (iq.gc()) {
                display = view.getDisplay();
                n2 = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n3 = view.getWidth();
            int n4 = view.getHeight();
            this.OW.OY = n2;
            this.OW.OX = display;
            this.OW.left = nArray[0];
            this.OW.top = nArray[1];
            this.OW.right = nArray[0] + n3;
            this.OW.bottom = nArray[1] + n4;
            if (this.Ns) {
                this.hG();
                this.Ns = false;
            }
        }
    }
}

