/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.internal.hl;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int xJ;
    private final GameEntity Rq;
    private final int Rr;
    private final boolean Rs;
    private final int Rt;
    private final long Ru;
    private final long Rv;
    private final String Rw;
    private final long Rx;
    private final String Ry;
    private final ArrayList<GameBadgeEntity> Rz;
    private final SnapshotMetadataEntity RA;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.xJ = 2;
        Game game = extendedGame.getGame();
        this.Rq = game == null ? null : new GameEntity(game);
        this.Rr = extendedGame.hM();
        this.Rs = extendedGame.hN();
        this.Rt = extendedGame.hO();
        this.Ru = extendedGame.hP();
        this.Rv = extendedGame.hQ();
        this.Rw = extendedGame.hR();
        this.Rx = extendedGame.hS();
        this.Ry = extendedGame.hT();
        SnapshotMetadata snapshotMetadata = extendedGame.hU();
        this.RA = snapshotMetadata == null ? null : new SnapshotMetadataEntity(snapshotMetadata);
        ArrayList<GameBadge> arrayList = extendedGame.hL();
        int n2 = arrayList.size();
        this.Rz = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Rz.add((GameBadgeEntity)arrayList.get(i2).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges, SnapshotMetadataEntity snapshot) {
        this.xJ = versionCode;
        this.Rq = game;
        this.Rr = availability;
        this.Rs = owned;
        this.Rt = achievementUnlockedCount;
        this.Ru = lastPlayedServerTimestamp;
        this.Rv = priceMicros;
        this.Rw = formattedPrice;
        this.Rx = fullPriceMicros;
        this.Ry = formattedFullPrice;
        this.Rz = badges;
        this.RA = snapshot;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    public GameEntity hV() {
        return this.Rq;
    }

    @Override
    public ArrayList<GameBadge> hL() {
        return new ArrayList<GameBadge>(this.Rz);
    }

    @Override
    public int hM() {
        return this.Rr;
    }

    @Override
    public boolean hN() {
        return this.Rs;
    }

    @Override
    public int hO() {
        return this.Rt;
    }

    @Override
    public long hP() {
        return this.Ru;
    }

    @Override
    public long hQ() {
        return this.Rv;
    }

    @Override
    public String hR() {
        return this.Rw;
    }

    @Override
    public long hS() {
        return this.Rx;
    }

    @Override
    public String hT() {
        return this.Ry;
    }

    @Override
    public SnapshotMetadata hU() {
        return this.RA;
    }

    public ExtendedGame hW() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.a(this);
    }

    static int a(ExtendedGame extendedGame) {
        return hl.hashCode(extendedGame.getGame(), extendedGame.hM(), extendedGame.hN(), extendedGame.hO(), extendedGame.hP(), extendedGame.hQ(), extendedGame.hR(), extendedGame.hS(), extendedGame.hT());
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.a(this, obj);
    }

    static boolean a(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return hl.equal(extendedGame2.getGame(), extendedGame.getGame()) && hl.equal(extendedGame2.hM(), extendedGame.hM()) && hl.equal(extendedGame2.hN(), extendedGame.hN()) && hl.equal(extendedGame2.hO(), extendedGame.hO()) && hl.equal(extendedGame2.hP(), extendedGame.hP()) && hl.equal(extendedGame2.hQ(), extendedGame.hQ()) && hl.equal(extendedGame2.hR(), extendedGame.hR()) && hl.equal(extendedGame2.hS(), extendedGame.hS()) && hl.equal(extendedGame2.hT(), extendedGame.hT());
    }

    public String toString() {
        return ExtendedGameEntity.b(this);
    }

    static String b(ExtendedGame extendedGame) {
        return hl.e(extendedGame).a("Game", extendedGame.getGame()).a("Availability", extendedGame.hM()).a("Owned", extendedGame.hN()).a("AchievementUnlockedCount", extendedGame.hO()).a("LastPlayedServerTimestamp", extendedGame.hP()).a("PriceMicros", extendedGame.hQ()).a("FormattedPrice", extendedGame.hR()).a("FullPriceMicros", extendedGame.hS()).a("FormattedFullPrice", extendedGame.hT()).a("Snapshot", extendedGame.hU()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fm()) {
            ExtendedGameEntityCreator.a(this, dest, flags);
        } else {
            this.Rq.writeToParcel(dest, flags);
            dest.writeInt(this.Rr);
            dest.writeInt(this.Rs ? 1 : 0);
            dest.writeInt(this.Rt);
            dest.writeLong(this.Ru);
            dest.writeLong(this.Rv);
            dest.writeString(this.Rw);
            dest.writeLong(this.Rx);
            dest.writeString(this.Ry);
            int n2 = this.Rz.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Rz.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.hV();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.hW();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity bg(Parcel parcel) {
            boolean bl2 = ExtendedGameEntity.c(ExtendedGameEntity.fl());
            if (bl2 || ExtendedGameEntity.aA(ExtendedGameEntity.class.getCanonicalName())) {
                return super.bg(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            boolean bl3 = parcel.readInt() == 1;
            int n3 = parcel.readInt();
            long l2 = parcel.readLong();
            long l3 = parcel.readLong();
            String string2 = parcel.readString();
            long l4 = parcel.readLong();
            String string3 = parcel.readString();
            int n4 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(GameBadgeEntity.CREATOR.bh(parcel));
            }
            SnapshotMetadataEntity snapshotMetadataEntity = null;
            return new ExtendedGameEntity(2, gameEntity, n2, bl3, n3, l2, l3, string2, l4, string3, arrayList, snapshotMetadataEntity);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bg(x0);
        }
    }
}

