/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;
import com.google.android.gms.internal.hl;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int xJ;
    private int AQ;
    private String HV;
    private String Mm;
    private Uri Mo;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.xJ = 1;
        this.AQ = gameBadge.getType();
        this.HV = gameBadge.getTitle();
        this.Mm = gameBadge.getDescription();
        this.Mo = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.xJ = versionCode;
        this.AQ = type;
        this.HV = title;
        this.Mm = description;
        this.Mo = iconImageUri;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public int getType() {
        return this.AQ;
    }

    @Override
    public String getTitle() {
        return this.HV;
    }

    @Override
    public String getDescription() {
        return this.Mm;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mo;
    }

    public GameBadge hX() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.a(this);
    }

    static int a(GameBadge gameBadge) {
        return hl.hashCode(gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri());
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.a(this, obj);
    }

    static boolean a(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return hl.equal(gameBadge2.getType(), gameBadge.getTitle()) && hl.equal(gameBadge2.getDescription(), gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.b(this);
    }

    static String b(GameBadge gameBadge) {
        return hl.e(gameBadge).a("Type", gameBadge.getType()).a("Title", gameBadge.getTitle()).a("Description", gameBadge.getDescription()).a("IconImageUri", gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fm()) {
            GameBadgeEntityCreator.a(this, dest, flags);
        } else {
            dest.writeInt(this.AQ);
            dest.writeString(this.HV);
            dest.writeString(this.Mm);
            dest.writeString(this.Mo == null ? null : this.Mo.toString());
        }
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.hX();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity bh(Parcel parcel) {
            boolean bl2 = GameBadgeEntity.c(GameBadgeEntity.fl());
            if (bl2 || GameBadgeEntity.aA(GameBadgeEntity.class.getCanonicalName())) {
                return super.bh(parcel);
            }
            int n2 = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            return new GameBadgeEntity(1, n2, string2, string3, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bh(x0);
        }
    }
}

