/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.games.internal.constants.LeaderboardCollection;
import com.google.android.gms.games.internal.constants.TimeSpan;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.internal.hl;

public final class LeaderboardVariantEntity
implements LeaderboardVariant {
    private final int SE;
    private final int SF;
    private final boolean SG;
    private final long SH;
    private final String SI;
    private final long SJ;
    private final String SK;
    private final String SL;
    private final long SM;
    private final String SN;
    private final String SO;
    private final String SP;

    public LeaderboardVariantEntity(LeaderboardVariant variant) {
        this.SE = variant.getTimeSpan();
        this.SF = variant.getCollection();
        this.SG = variant.hasPlayerInfo();
        this.SH = variant.getRawPlayerScore();
        this.SI = variant.getDisplayPlayerScore();
        this.SJ = variant.getPlayerRank();
        this.SK = variant.getDisplayPlayerRank();
        this.SL = variant.getPlayerScoreTag();
        this.SM = variant.getNumScores();
        this.SN = variant.iy();
        this.SO = variant.iz();
        this.SP = variant.iA();
    }

    @Override
    public int getTimeSpan() {
        return this.SE;
    }

    @Override
    public int getCollection() {
        return this.SF;
    }

    @Override
    public boolean hasPlayerInfo() {
        return this.SG;
    }

    @Override
    public long getRawPlayerScore() {
        return this.SH;
    }

    @Override
    public String getDisplayPlayerScore() {
        return this.SI;
    }

    @Override
    public long getPlayerRank() {
        return this.SJ;
    }

    @Override
    public String getDisplayPlayerRank() {
        return this.SK;
    }

    @Override
    public String getPlayerScoreTag() {
        return this.SL;
    }

    @Override
    public long getNumScores() {
        return this.SM;
    }

    @Override
    public String iy() {
        return this.SN;
    }

    @Override
    public String iz() {
        return this.SO;
    }

    @Override
    public String iA() {
        return this.SP;
    }

    public LeaderboardVariant iB() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardVariantEntity.a(this);
    }

    static int a(LeaderboardVariant leaderboardVariant) {
        return hl.hashCode(leaderboardVariant.getTimeSpan(), leaderboardVariant.getCollection(), leaderboardVariant.hasPlayerInfo(), leaderboardVariant.getRawPlayerScore(), leaderboardVariant.getDisplayPlayerScore(), leaderboardVariant.getPlayerRank(), leaderboardVariant.getDisplayPlayerRank(), leaderboardVariant.getNumScores(), leaderboardVariant.iy(), leaderboardVariant.iA(), leaderboardVariant.iz());
    }

    public boolean equals(Object obj) {
        return LeaderboardVariantEntity.a(this, obj);
    }

    static boolean a(LeaderboardVariant leaderboardVariant, Object object) {
        if (!(object instanceof LeaderboardVariant)) {
            return false;
        }
        if (leaderboardVariant == object) {
            return true;
        }
        LeaderboardVariant leaderboardVariant2 = (LeaderboardVariant)object;
        return hl.equal(leaderboardVariant2.getTimeSpan(), leaderboardVariant.getTimeSpan()) && hl.equal(leaderboardVariant2.getCollection(), leaderboardVariant.getCollection()) && hl.equal(leaderboardVariant2.hasPlayerInfo(), leaderboardVariant.hasPlayerInfo()) && hl.equal(leaderboardVariant2.getRawPlayerScore(), leaderboardVariant.getRawPlayerScore()) && hl.equal(leaderboardVariant2.getDisplayPlayerScore(), leaderboardVariant.getDisplayPlayerScore()) && hl.equal(leaderboardVariant2.getPlayerRank(), leaderboardVariant.getPlayerRank()) && hl.equal(leaderboardVariant2.getDisplayPlayerRank(), leaderboardVariant.getDisplayPlayerRank()) && hl.equal(leaderboardVariant2.getNumScores(), leaderboardVariant.getNumScores()) && hl.equal(leaderboardVariant2.iy(), leaderboardVariant.iy()) && hl.equal(leaderboardVariant2.iA(), leaderboardVariant.iA()) && hl.equal(leaderboardVariant2.iz(), leaderboardVariant.iz());
    }

    public String toString() {
        return LeaderboardVariantEntity.b(this);
    }

    static String b(LeaderboardVariant leaderboardVariant) {
        return hl.e(leaderboardVariant).a("TimeSpan", TimeSpan.cm(leaderboardVariant.getTimeSpan())).a("Collection", LeaderboardCollection.cm(leaderboardVariant.getCollection())).a("RawPlayerScore", leaderboardVariant.hasPlayerInfo() ? Long.valueOf(leaderboardVariant.getRawPlayerScore()) : "none").a("DisplayPlayerScore", leaderboardVariant.hasPlayerInfo() ? leaderboardVariant.getDisplayPlayerScore() : "none").a("PlayerRank", leaderboardVariant.hasPlayerInfo() ? Long.valueOf(leaderboardVariant.getPlayerRank()) : "none").a("DisplayPlayerRank", leaderboardVariant.hasPlayerInfo() ? leaderboardVariant.getDisplayPlayerRank() : "none").a("NumScores", leaderboardVariant.getNumScores()).a("TopPageNextToken", leaderboardVariant.iy()).a("WindowPageNextToken", leaderboardVariant.iA()).a("WindowPagePrevToken", leaderboardVariant.iz()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iB();
    }
}

