/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.hn;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int xJ;
    private final GameEntity Rq;
    private final String NN;
    private final long SR;
    private final int SS;
    private final ParticipantEntity ST;
    private final ArrayList<ParticipantEntity> SU;
    private final int SV;
    private final int SW;

    InvitationEntity(Invitation invitation) {
        this.xJ = 2;
        this.Rq = new GameEntity(invitation.getGame());
        this.NN = invitation.getInvitationId();
        this.SR = invitation.getCreationTimestamp();
        this.SS = invitation.getInvitationType();
        this.SV = invitation.getVariant();
        this.SW = invitation.getAvailableAutoMatchSlots();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.SU = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.SU.add((ParticipantEntity)participant2.freeze());
        }
        hn.b(participant, (Object)"Must have a valid inviter!");
        this.ST = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.xJ = versionCode;
        this.Rq = game;
        this.NN = invitationId;
        this.SR = creationTimestamp;
        this.SS = invitationType;
        this.ST = inviter;
        this.SU = participants;
        this.SV = variant;
        this.SW = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public Game getGame() {
        return this.Rq;
    }

    @Override
    public String getInvitationId() {
        return this.NN;
    }

    @Override
    public Participant getInviter() {
        return this.ST;
    }

    @Override
    public long getCreationTimestamp() {
        return this.SR;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.SU);
    }

    @Override
    public int getInvitationType() {
        return this.SS;
    }

    @Override
    public int getVariant() {
        return this.SV;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.SW;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return hl.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return hl.equal(invitation2.getGame(), invitation.getGame()) && hl.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && hl.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && hl.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && hl.equal(invitation2.getInviter(), invitation.getInviter()) && hl.equal(invitation2.getParticipants(), invitation.getParticipants()) && hl.equal(invitation2.getVariant(), invitation.getVariant()) && hl.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return hl.e(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).a("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fm()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.Rq.writeToParcel(dest, flags);
            dest.writeString(this.NN);
            dest.writeLong(this.SR);
            dest.writeInt(this.SS);
            this.ST.writeToParcel(dest, flags);
            int n2 = this.SU.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.SU.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity bl(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.fl());
            if (bl2 || InvitationEntity.aA(InvitationEntity.class.getCanonicalName())) {
                return super.bl(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            int n5 = 0;
            return new InvitationEntity(2, gameEntity, string2, l2, n3, participantEntity, arrayList, n2, n5);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bl(x0);
        }
    }
}

